﻿function drawCircle(movieClipHandle:MovieClip, x:Number, y:Number, radius:Number) : Void
{
	var c1 = radius * (Math.SQRT2 - 1);
    var c2 = radius * Math.SQRT2 / 2;
	
	movieClipHandle.beginFill(0x000000, 100);
    movieClipHandle.moveTo(x + radius, y);
    movieClipHandle.curveTo(x + radius, y + c1, x + c2, y + c2);
    movieClipHandle.curveTo(x + c1, y + radius, x, y + radius);
    movieClipHandle.curveTo(x - c1, y + radius, x - c2, y + c2);
    movieClipHandle.curveTo(x - radius, y + c1, x - radius, y);
    movieClipHandle.curveTo(x - radius, y - c1, x - c2, y - c2);
    movieClipHandle.curveTo(x - c1, y - radius, x, y - radius);
    movieClipHandle.curveTo(x + c1, y - radius, x + c2, y - c2);
    movieClipHandle.curveTo(x + radius, y - c1, x + radius, y);
}

this.createEmptyMovieClip("contentClip", this.getNextHighestDepth());
this.createEmptyMovieClip("maskClip", this.getNextHighestDepth());

contentClip.beginFill(0x000066, 100);
contentClip.moveTo(200, 0);
contentClip.lineTo(400, 300);
contentClip.lineTo(0, 300);
contentClip.lineTo(200, 0);

drawCircle(maskClip, 0, 0, 30);

contentClip.setMask(maskClip);

var mouseListener:Object = new Object();
mouseListener.onMouseMove = function()
{
	maskClip._x = _xmouse;
	maskClip._y = _ymouse;
}

Mouse.addListener(mouseListener);
