unit Unit_26;

interface

uses
  SysUtils, Types, Classes, Variants, QTypes,
  QGraphics, QControls, QForms,
  QDialogs, QStdCtrls, QExtCtrls,
  QComCtrls, QFileCtrls, QMenus, QConsts;

type
  TForm1 = class(TForm)
    DirectoryTreeView1: TDirectoryTreeView;
    FileListView1: TFileListView;
    Splitter1: TSplitter;
    procedure DirectoryTreeView1Change(Sender: TObject;
                                       Node: TTreeNode);
    procedure FileListView1Change(Sender: TObject;
                                  Item: TListItem;
                                  Change: TItemChange);
    procedure FileListView1SelectItem(Sender: TObject;
                                      Item: TListItem;
                                      Selected: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.xfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  FileListView1.ViewStyle := vsReport; //vsList;
end;
//---------------------------------------------------------
procedure TForm1.DirectoryTreeView1Change(Sender: TObject;
                                          Node: TTreeNode);
begin
  FileListView1.Directory.Location :=
                          DirectoryTreeView1.Directory;
end;
//---------------------------------------------------------
procedure TForm1.FileListView1Change(Sender: TObject;
                                     Item: TListItem;
                                     Change: TItemChange);
begin
  DirectoryTreeView1.Directory :=
                     FileListView1.Directory.Location;
end;
//---------------------------------------------------------
procedure TForm1.FileListView1SelectItem(Sender: TObject;
                                         Item: TListItem;
                                         Selected: Boolean);
var
  FileInfo: PFileInfo;
  DateTime: WideString;
begin
  if (Item <> NIL) and (Item.Data <> NIL) then
    begin
      FileInfo := PFileInfo(Item.Data);
      if FileListView1.Directory.Location = '' then
         DateTime := Format('%d MB', [FileInfo.SR.Time])
         else
           DateTime :=
           DateTimeToStr(FileDateToDateTime(FileInfo.SR.Time));
    end
end;
//---------------------------------------------------------
procedure TForm1.FormClose(Sender: TObject;
                           var Action: TCloseAction);
begin
  Action := caFree;
end;
//---------------------------------------------------------
end.
