unit Unit_21;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    LabeledEdit1: TLabeledEdit;
    LabeledEdit2: TLabeledEdit;
    LabeledEdit3: TLabeledEdit;
    LabeledEdit4: TLabeledEdit;
    LabeledEdit5: TLabeledEdit;
    LabeledEdit6: TLabeledEdit;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    procedure Button5Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
    procedure ShowData;
    procedure ClearData;
    procedure SaveData;
    procedure LoadData;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}
type
  TStudent = record
    Imie: String[15];
    Nazwisko: String[20];
    EgzaminMat: Single;
    EgzaminFiz: Single;
    EgzaminInf: Single;
    JakiStudent: String[40];
  end;
TStudentFile = File of TStudent;
var
  F: TStudentFile;
  S: TStudent;
  CurRec: Integer;
//---------------------------------------------------------
procedure TForm1.ShowData;
begin
   LabeledEdit1.Text:=S.Imie;
   LabeledEdit2.Text:=S.Nazwisko;
   LabeledEdit3.Text:=FloatToStr(S.EgzaminMat);
   LabeledEdit4.Text:=FloatToStr(S.EgzaminFiz);
   LabeledEdit5.Text:=FloatToStr(S.EgzaminInf);
   LabeledEdit6.Text:=S.JakiStudent;
end;
//---------------------------------------------------------
procedure TForm1.LoadData;
begin
  Read(F, S);
  ShowData;
end;
//---------------------------------------------------------
procedure TForm1.ClearData;
begin
   LabeledEdit1.Text:='';
   LabeledEdit2.Text:='';
   LabeledEdit3.Text:='0';
   LabeledEdit4.Text:='0';
   LabeledEdit5.Text:='0';
   LabeledEdit6.Text:='';
end;
//---------------------------------------------------------
procedure TForm1.SaveData;
begin
   S.Imie:=LabeledEdit1.Text;
   S.Nazwisko:=LabeledEdit2.Text;
   S.EgzaminMat:=StrToFloat(LabeledEdit3.Text);
   S.EgzaminFiz:=StrToFloat(LabeledEdit4.Text);
   S.EgzaminInf:=StrToFloat(LabeledEdit5.Text);
   S.JakiStudent:=LabeledEdit6.Text;
   Write(F, S);
end;
//---------------------------------------------------------
procedure TForm1.Button5Click(Sender: TObject);
begin
   SaveData;
   CloseFile(F);
   Application.Terminate();
end;
//---------------------------------------------------------
procedure TForm1.Button3Click(Sender: TObject);
begin
   SaveData;
   ShowData;
end;
//---------------------------------------------------------
procedure TForm1.FormCreate(Sender: TObject);
begin
   ClearData;
   CurRec:=0;
   AssignFile(F, 'SdudentsData.dat');
   if FileExists('SdudentsData.dat') then
     begin
       Reset(F);
       while not EOF(F) do
         LoadData;
     end
       else
         begin
           ClearData;
           Rewrite(F);
         end;
end;
//---------------------------------------------------------
procedure TForm1.Button1Click(Sender: TObject);
begin
  repeat
    Inc(CurRec,1);
    Seek(F, CurRec);
  until EOF(F);
  ClearData;
  SaveData;
  Seek(F, CurRec);
end;
//--------------------------------------------------------
procedure TForm1.Button2Click(Sender: TObject);
begin
  if (CurRec-1) < 0 then
    begin
      CurRec:=0;
      Seek(F, CurRec);
      ShowMessage('Osignito pocztek pliku z danymi');
    end
      else
        begin
          Inc(CurRec,-1);
          Seek(F, CurRec);
          Read(F, S);
          Seek(F, CurRec);
          ShowData;
        end;
end;
//---------------------------------------------------------
procedure TForm1.Button4Click(Sender: TObject);
begin
  Inc(CurRec,1);
  Seek(F, CurRec);
  if not EOF(F) then
    begin
      Read(F, S);
      Seek(F, CurRec);
      ShowData;
    end
      else
        begin
          Inc(CurRec, -1);   // to samo, co CurRec:=CurRec-1;
          Seek(F, CurRec);
          ShowMessage('Osignito koniec pliku z danymi');
        end;
end;
//---------------------------------------------------------
end.
