unit EditClock;

interface

uses
  SysUtils, Classes, Controls, StdCtrls,
  ExtCtrls;

type
  TEditClock = class(TEdit)
  private
    { Private declarations }
    MyTimer: TTimer;
    procedure ShowTime(Sender: TObject);
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Published declarations }
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TEditClock]);
end;
//---------------------------------------------------------
constructor TEditClock.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  MyTimer := TTimer.Create(AOwner);
  MyTimer.Interval := 1000;
  MyTimer.OnTimer := ShowTime;
  MyTimer.Enabled := True;
end;
//---------------------------------------------------------
destructor TEditClock.Destroy;
begin
  // jawnie wywolany destruktor
  MyTimer.Destroy;
  inherited Destroy;
end;
//---------------------------------------------------------
procedure TEditClock.ShowTime(Sender: TObject);
begin
  Text := DateTimeToStr(Now());
end;
//---------------------------------------------------------
end.
