unit Unit_19;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls, ComCtrls,
  FileCtrl, ToolWin, Buttons, Menus;

type
  TForm1 = class(TForm)
    Button1: TButton;
    RichEdit1: TRichEdit;
    SaveDialog1: TSaveDialog;
    CoolBar1: TCoolBar;
    CopyText: TSpeedButton;
    PasteText: TSpeedButton;
    CutText: TSpeedButton;
    MainMenu1: TMainMenu;
    OpenDialog1: TOpenDialog;
    SaveFileAs: TMenuItem;
    OpenFile: TMenuItem;
    NewFile: TMenuItem;
    CloseApplication: TMenuItem;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CopyTextClick(Sender: TObject);
    procedure PasteTextClick(Sender: TObject);
    procedure CutTextClick(Sender: TObject);
    procedure FileOpenClick(Sender: TObject);
    procedure NewFileClick(Sender: TObject);
    procedure SaveFileAsClick(Sender: TObject);
    procedure FormClose(Sender: TObject;
                        var Action: TCloseAction);
    procedure FormCloseQuery(Sender: TObject;
                             var CanClose: Boolean);

  private
    { Private declarations }
    sFile: String;
    procedure FormCaption(const sFile_s: String);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

//---------------------------------------------------------
procedure TForm1.Button1Click(Sender: TObject);
begin
   case (MessageBox(0, 'Zamknicie aplikacji ', 'Uwaga !',
         MB_YESNO or MB_ICONQUESTION)) of
     ID_YES:
        Application.Terminate();
     ID_NO: Abort();
    end;
end;
//---------------------------------------------------------
procedure TForm1.FormCreate(Sender: TObject);
begin
  OpenDialog1.InitialDir := ExtractFilePath(ParamStr(0));
  SaveDialog1.InitialDir := OpenDialog1.InitialDir;
end;
//---------------------------------------------------------
procedure TForm1.CopyTextClick(Sender: TObject);
begin
  RichEdit1.CopyToClipboard();
end;
//---------------------------------------------------------
procedure TForm1.PasteTextClick(Sender: TObject);
begin
  RichEdit1.PasteFromClipboard();
end;
//---------------------------------------------------------
procedure TForm1.CutTextClick(Sender: TObject);
begin
  RichEdit1.CutToClipboard();
end;
//---------------------------------------------------------
procedure TForm1.FormCaption(const sFile_s: String);
begin
  sFile := sFile_s;
  Caption := Format('%s - %s', [ExtractFileName(sFile_s),
                    Application.Title]);
end;
//---------------------------------------------------------
procedure TForm1.FileOpenClick(Sender: TObject);
var
  InFile: TextFile;
  Data: string;
begin
  RichEdit1.Lines.Clear();
  if OpenDialog1.Execute then
    begin
      AssignFile(InFile, OpenDialog1.FileName);
      Reset(InFile);
      while not EOF(InFile) do
        begin
          ReadLn(InFile, Data);
          RichEdit1.Lines.Add(Data);
        end;
      CloseFile(InFile);
      Form1.Caption:='Edycja ['+ OpenDialog1.FileName +']';
    end;
end;
//---------------------------------------------------------
procedure TForm1.NewFileClick(Sender: TObject);
begin
  FormCaption('Bez nazwy');
  RichEdit1.Lines.Clear();
  RichEdit1.Modified := FALSE;
end;
//---------------------------------------------------------
procedure TForm1.SaveFileAsClick(Sender: TObject);
var
  OutFile: TextFile;
begin
  if SaveDialog1.Execute then
    begin
      AssignFile(OutFile, SaveDialog1.FileName);
      Rewrite(OutFile);
      WriteLn(OutFile, RichEdit1.Text);
      CloseFile(OutFile);
      Form1.Caption:='Zapisany [ ' +SaveDialog1.FileName+ ']';
      RichEdit1.Modified := FALSE;
    end;
end;
//---------------------------------------------------------
procedure TForm1.FormClose(Sender: TObject;
                           var Action: TCloseAction);
begin
  Action:=caFree;
end;
//---------------------------------------------------------
procedure TForm1.FormCloseQuery(Sender: TObject;
                           var CanClose: Boolean);
begin
   case (MessageBox(0, 'Zamknicie aplikacji ', 'Uwaga !',
         MB_YESNO or MB_ICONQUESTION)) of
     mrYES:
       CanClose:=TRUE;
     mrNO:
       CanClose:=FALSE;
   end;
end;
//---------------------------------------------------------
end.

