unit Unit_17;

interface

uses
  Windows, Messages, SysUtils, Variants,
  Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, FileCtrl;

type
  TForm1 = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
implementation

{$R *.dfm}

var
  // Deklaracja egzemplarzy klas
  // TSplitter, TFileListBox, TDirectoryListBox,
  // TEdit oraz TDriveComboBox

  ps: TSplitter;
  pflb: TFileListBox;
  pdlb: TDirectoryListBox;
  pdcb: TDriveComboBox;
  pe: TEdit;
//---------------------------------------------------------
procedure TForm1.FormCreate(Sender: TObject);
begin
  // Inicjowanie obiektw klas
  // TSplitter, TFileListBox, TDirectoryListBox,
  // TEdit oraz TDriveComboBox. Obiekty inicjowane s
  // konstruktorami odpowiednich klas
  ps := TSplitter.Create(Self); // Form1
  pflb := TFileListBox.Create(Self);
  pdlb := TDirectoryListBox.Create(Self);
  pdcb := TDriveComboBox.Create(Self);
  pe :=   TEdit.Create(Self);

  // Ustalenie relacji wacicielstwa i pooenia
  // na formularzu obiektu klasy TDirectoryListBox
  pdlb.Parent := Self;// Form1
  pdlb.Align := alLeft;
  pdlb.Width := Self.ClientWidth div 3;

  // Ustalenie relacji wacicielstwa i pooenia
  // na formularzu obiektu klasy TDriveComboBox
  pdcb.Parent := Self;
  pdcb.Align := alTop;
  pdcb.Width := Self.ClientWidth div 4;

  // Ustalenie relacji wacicielstwa i pooenia
  // na formularzu obiektu klasy TEdit
  pe.Parent := Self;
  pe.Align := alTop;
  pe.Width := Self.ClientWidth div 6;

  // Ustalenie relacji wacicielstwa i pooenia
  // na formularzu obiektu klasy TSplitter
  ps.Parent := Self;
  ps.Left := pdlb.Left + pdlb.Width + 2;
  ps.Align := pdlb.Align;
  ps.MinSize := Self.ClientWidth div 4;

  // Ustalenie relacji wacicielstwa i pooenia
  // na formularzu obiektu klasy TFileListBox
  pflb.Parent := Self;
  pflb.Align := alClient;

  // Powizanie wasnoci FileList, DirList i FileEdit
  // obiektw klas TFileListBox, TDirectoryListBox,
  // TEdit oraz TDriveComboBox
  pdlb.FileList := pflb;
  pdcb.DirList := pdlb;
  pflb.FileEdit := pe;
end;
//---------------------------------------------------------
procedure TForm1.FormDestroy(Sender: TObject);
begin
  // niszczenie obiektw poszczeglnych klas
  ps.Free;
  pflb.Free;
  pdlb.Free;
  pdcb.Free;
  pe.Free;
end;
//----------------------------------------------------------
end.
