unit Unit_24;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes,
  Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, MPlayer, Menus;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    plik1: TMenuItem;
    Open1: TMenuItem;
    N1: TMenuItem;
    Close1: TMenuItem;
    OpenDialog1: TOpenDialog;
    MediaPlayer1: TMediaPlayer;
    PaintBox1: TPaintBox;
    Button1: TButton;
    procedure Open1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure PaintBox1Paint(Sender: TObject);
    procedure Close1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Bitmap: TBitmap;

implementation
{$R *.dfm}
//---------------------------------------------------------
procedure TForm1.FormCreate(Sender: TObject);
begin
  Bitmap:=TBitmap.Create;
  Bitmap.Height := 200;
  Bitmap.Width := 200;
  Bitmap.Canvas.Rectangle(0,0,200,200);
end;
//---------------------------------------------------------
procedure TForm1.Open1Click(Sender: TObject);
var
  MPError: AnsiString;
begin
  // otwiera plik video i rozpoczyna jego odtwarzanie
  if (OpenDialog1.Execute()) then
    begin
      MediaPlayer1.FileName := OpenDialog1.FileName;
    try
      MediaPlayer1.Open();
      // film video wywietlany w obszarze formularza
      MediaPlayer1.Display := Form1;
      MediaPlayer1.DisplayRect := Rect(0,0,200,200);

    except
       MPError := 'ErrorCode: ' + IntToStr(Error) + #13#10;
       MessageDlg(MPError + MediaPlayer1.ErrorMessage,
                  mtError, [mbOk], 0);
       MediaPlayer1.Close();
    end;
  end;

end;
//---------------------------------------------------------
procedure TForm1.Button1Click(Sender: TObject);
begin
  // przechwytywanie biecej klatki filmu i zapisywanie
  // jej w postaci mapy bitowej
  Bitmap.Canvas.CopyRect(Rect(0,0,200,200),Form1.Canvas,
                           Rect(0,0,200,200));
  // wypenia i za kadym razem odwiea obraz
  // zawarty w obszarze okrelonym przez PaintBox1
  PaintBox1.Invalidate();

end;
//---------------------------------------------------------
procedure TForm1.PaintBox1Paint(Sender: TObject);
begin
  // wywietlanie zawartoci mapy bitowej
  PaintBox1.Canvas.CopyRect(Rect(0,0,210,210),
                     Bitmap.Canvas,Rect(0,0,210,210));
end;
//---------------------------------------------------------
procedure TForm1.FormDestroy(Sender: TObject);
begin
  Bitmap.Free;
end;
//---------------------------------------------------------
procedure TForm1.Close1Click(Sender: TObject);
begin
   Application.Terminate();
end;
//---------------------------------------------------------
end.
