unit Unit_19;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics,
  Controls, Forms, Dialogs, Buttons, StdCtrls, Grids;

type
  TForm1 = class(TForm)
    Button3: TButton;
    Sum: TButton;
    SumOfInverse: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    StringGrid1: TStringGrid;
    procedure FormClose(Sender: TObject;
                        var Action: TCloseAction);
    procedure Button3Click(Sender: TObject);
    procedure SumClick(Sender: TObject);
    procedure SumOfInverseClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    procedure ReadGrid;
  public
    { Public declarations }

  end;

var
  Form1: TForm1;

var
  Data : array of Double;
  // tablica dynamiczna przechowujca
  // wartoci typu Double
  Value: Double;


  function SumOfElement(const Data: array of Double): Double;
                        stdcall external 'Library_19.dll';
  function SumOfInverseElement(const Data: array of Double):
                  Double; stdcall external 'Library_19.dll';

implementation

{$R *.DFM}


resourcestring
  s1 ='Zamknicie aplikacji ?';
//---------------------------------------------------------
procedure TForm1.ReadGrid;
var
  i: Integer;
begin
  with StringGrid1 do
      for i:= 0 to RowCount -1 do
        begin
          if(Cells[1,i]= '') then
            Value:=0
              else
                Value:=StrToFloat(Cells[1,i]);
          SetLength(Data, Length(Data)+1);
          Data[i]:=Value;
        end;
end;
//---------------------------------------------------------
procedure TForm1.FormCreate(Sender: TObject);
var
  k,i : Integer;
begin
  k := 0;
  with StringGrid1 do
      for i:= 0 to RowCount - 1 do
        begin
          k := k + 1;
          Cells[0,i]:=IntToStr(k);
        end;
end;
//---------------------------------------------------------
procedure TForm1.SumClick(Sender: TObject);
begin
   ReadGrid;
   Edit1.Text:=FloatToStr(SumOfElement(Data));
end;
//---------------------------------------------------------
procedure TForm1.SumOfInverseClick(Sender: TObject);
begin
   ReadGrid;
   Edit2.Text:=FloatToStr(SumOfInverseElement(Data));
end;
//---------------------------------------------------------
procedure TForm1.FormClose(Sender: TObject;
                           var Action: TCloseAction);
begin
  Action := caFree;
end;
//---------------------------------------------------------
procedure TForm1.Button3Click(Sender: TObject);
var
  iCheck: Integer;
begin
   iCheck := MessageDlg(s1, mtConfirmation,[mbYes, mbNo], 0);
   case iCheck of
      idYes: Application.Terminate();
      idNo:  Exit;
   end;
end;
//---------------------------------------------------------

end.

