unit Unit_14;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls, ComCtrls,
  FileCtrl, ToolWin, Buttons, Menus, ActnList, ImgList;

type
  TForm1 = class(TForm)
    Button1: TButton;
    RichEdit1: TRichEdit;
    SaveDialog1: TSaveDialog;
    MainMenu1: TMainMenu;
    OpenDialog1: TOpenDialog;
    SaveFileAs: TMenuItem;
    OpenFile: TMenuItem;
    NewFile: TMenuItem;
    CloseApplication: TMenuItem;
    ActionList1: TActionList;
    ImageList1: TImageList;
    FileNew: TAction;
    FileOpen: TAction;
    FileSaveAs: TAction;
    FileExit: TAction;
    ActionList2: TActionList;
    Edycja1: TMenuItem;
    Wytnij1: TMenuItem;
    Kopiuj1: TMenuItem;
    Wklej1: TMenuItem;
    EditCut: TAction;
    EditCopy: TAction;
    EditPaste: TAction;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure EditCopyClick(Sender: TObject);
    procedure EditPasteClick(Sender: TObject);
    procedure EditCutClick(Sender: TObject);
    procedure FileOpenClick(Sender: TObject);
    procedure FileNewClick(Sender: TObject);
    procedure FileSaveAsClick(Sender: TObject);
    procedure FormClose(Sender: TObject;
                        var Action: TCloseAction);
    procedure FormCloseQuery(Sender: TObject;
                             var CanClose: Boolean);

  private
    { Private declarations }
    sFile: String;
    procedure FormCaption(const sFile_s: String);
    procedure CheckFileSave;
    procedure ShowFileOpen(const sFile_O: String);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

resourcestring
  s1 =  'Uwaga !';
  s2 = 'Zawarto pliku lub okna'+
        ' zostaa zmieniona. Zapisa zmiany ? ';
  s3 = 'Plik zapisany ponownie %s';
  s4 = 'Zamknicie aplikacji ';
//---------------------------------------------------------
procedure TForm1.Button1Click(Sender: TObject);
begin
   case (MessageBox(0, PChar(s4), PChar(s1),
         MB_YESNO or MB_ICONQUESTION)) of
     ID_YES:
      begin
        CheckFileSave;
        Application.Terminate();
      end;
     ID_NO: Abort();
    end;
end;
//---------------------------------------------------------
procedure TForm1.FormCreate(Sender: TObject);
begin
  OpenDialog1.InitialDir := ExtractFilePath(ParamStr(0));
  SaveDialog1.InitialDir := OpenDialog1.InitialDir;
end;
//---------------------------------------------------------
procedure TForm1.EditCopyClick(Sender: TObject);
begin
  RichEdit1.CopyToClipboard;
end;
//---------------------------------------------------------
procedure TForm1.EditPasteClick(Sender: TObject);
begin
  RichEdit1.PasteFromClipboard;
end;
//---------------------------------------------------------
procedure TForm1.EditCutClick(Sender: TObject);
begin
  RichEdit1.CutToClipboard;
end;
//---------------------------------------------------------
procedure TForm1.FormCaption(const sFile_s: String);
begin
  sFile := sFile_s;
  Caption := Format('%s - %s', [ExtractFileName(sFile_s),
                    Application.Title]);
end;
//---------------------------------------------------------
procedure TForm1.CheckFileSave;
begin
  if (RichEdit1.Modified) then
    begin
     case(MessageBox(0, PChar(s2),PChar(s1),
          MB_YESNOCANCEL or MB_ICONQUESTION)) of
        ID_YES : FileSaveAsClick(Self);
        ID_CANCEL : Abort();
         end;
      end;
end;
//---------------------------------------------------------
procedure TForm1.FileOpenClick(Sender: TObject);
begin
  CheckFileSave;
  if OpenDialog1.Execute then
  begin
    ShowFileOpen(OpenDialog1.FileName);
    RichEdit1.ReadOnly := ofReadOnly in OpenDialog1.Options;
  end;
end;
//---------------------------------------------------------
procedure TForm1.FileNewClick(Sender: TObject);
begin
  FormCaption('Bez nazwy');
  RichEdit1.Lines.Clear;
  RichEdit1.Modified := FALSE;
end;
//---------------------------------------------------------
procedure TForm1.FileSaveAsClick(Sender: TObject);
begin
  if SaveDialog1.Execute then
    begin
      if FileExists(SaveDialog1.FileName) then
        if MessageDlg(Format(s3, [SaveDialog1.FileName]),
                      mtConfirmation,
                      mbYesNoCancel, 0) <> idYes then Abort();
       RichEdit1.Lines.SaveToFile(SaveDialog1.FileName);
       FormCaption(SaveDialog1.FileName);
       RichEdit1.Modified := FALSE;
     end;
end;
//---------------------------------------------------------
procedure TForm1.ShowFileOpen(const sFile_O: string);
begin
  RichEdit1.Lines.LoadFromFile(sFile_O);
  FormCaption(sFile_O);
  RichEdit1.SetFocus;
  RichEdit1.Modified := FALSE;
end;
//---------------------------------------------------------
procedure TForm1.FormClose(Sender: TObject;
                           var Action: TCloseAction);
begin
  Action:=caFree;
end;
//---------------------------------------------------------
procedure TForm1.FormCloseQuery(Sender: TObject;
                           var CanClose: Boolean);
begin
   case (MessageBox(0, PChar(s4), PChar(s1),
         MB_YESNO or MB_ICONQUESTION)) of
     mrYES:
        CheckFileSave;
     mrNO:
       CanClose:=FALSE;
   end;
end;
//---------------------------------------------------------
end.

