prawidowy_hetman((Wiersz, Kolumna)) :- naley(Kolumna, [1,2,3,4,5,6,7,8]).

prawidowa_szachownica([]).
prawidowa_szachownica([Gowa|Ogon]) :- prawidowy_hetman(Gowa), prawidowa_szachownica(Ogon).

kolumny([], []).
kolumny([(_, Kolumna)|HetmanyOgon], [Kolumna|KolumnyOgon]) :-
    kolumny(HetmanyOgon, KolumnyOgon).

przektne1([], []).
przektne1([(Wiersz, Kolumna)|HetmanyOgon], [Przektna|PrzektneOgon]) :-
    Przektna is Kolumna - Wiersz,
    przektne1(HetmanyOgon, PrzektneOgon).

przektne2([], []).
przektne2([(Wiersz, Kolumna)|HetmanyOgon], [Przektna|PrzektneOgon]) :-
    Przektna is Kolumna + Wiersz,
    przektne2(HetmanyOgon, PrzektneOgon).

omiu_hetmanw(Szachownica) :-
    Szachownica = [(1, _), (2, _), (3, _), (4, _), (5, _), (6, _), (7, _), (8, _)],
    prawidowa_szachownica(Szachownica),

    kolumny(Szachownica, Kolumny),
    przektne1(Szachownica, Przektne1),
    przektne2(Szachownica, Przektne2),

    fd_all_different(Kolumny),
    fd_all_different(Przektne1),
    fd_all_different(Przektne2).
