/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;

public class MatchReturnTypeInference
implements SqlReturnTypeInference {
    private final int start;
    private final List<SqlTypeName> typeNames;

    public MatchReturnTypeInference(int start, SqlTypeName ... typeNames) {
        this(start, (List<SqlTypeName>)ImmutableList.copyOf((Object[])typeNames));
    }

    public MatchReturnTypeInference(int start, List<SqlTypeName> typeNames) {
        assert (start >= 0);
        assert (null != typeNames);
        assert (typeNames.size() > 0);
        this.start = start;
        this.typeNames = ImmutableList.copyOf(typeNames);
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        for (int i = this.start; i < opBinding.getOperandCount(); ++i) {
            RelDataType argType = opBinding.getOperandType(i);
            if (!SqlTypeUtil.isOfSameTypeName(this.typeNames, argType)) continue;
            return argType;
        }
        return null;
    }
}

