/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.util.Util;

public abstract class Calc
extends SingleRel {
    protected final RexProgram program;

    protected Calc(RelOptCluster cluster, RelTraitSet traits, RelNode child, RexProgram program) {
        super(cluster, traits, child);
        this.rowType = program.getOutputRowType();
        this.program = program;
        assert (this.isValid(true));
    }

    @Deprecated
    protected Calc(RelOptCluster cluster, RelTraitSet traits, RelNode child, RexProgram program, List<RelCollation> collationList) {
        this(cluster, traits, child, program);
        Util.discard(collationList);
    }

    @Override
    public final Calc copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, Calc.sole(inputs), this.program);
    }

    public abstract Calc copy(RelTraitSet var1, RelNode var2, RexProgram var3);

    @Deprecated
    public Calc copy(RelTraitSet traitSet, RelNode child, RexProgram program, List<RelCollation> collationList) {
        Util.discard(collationList);
        return this.copy(traitSet, child, program);
    }

    @Override
    public boolean isValid(boolean fail) {
        if (!RelOptUtil.equal("program's input type", this.program.getInputRowType(), "child's output type", this.getInput().getRowType(), fail)) {
            return false;
        }
        if (!this.program.isValid(fail)) {
            return false;
        }
        return this.program.isNormalized(fail, this.getCluster().getRexBuilder());
    }

    public RexProgram getProgram() {
        return this.program;
    }

    @Override
    public double getRows() {
        return LogicalFilter.estimateFilteredRows(this.getInput(), this.program);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        double dRows = RelMetadataQuery.getRowCount(this);
        double dCpu = RelMetadataQuery.getRowCount(this.getInput()) * (double)this.program.getExprCount();
        double dIo = 0.0;
        return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return this.program.explainCalc(super.explainTerms(pw));
    }

    @Override
    public RelNode accept(RexShuttle shuttle) {
        RexNode condition;
        List<RexNode> oldExprs = this.program.getExprList();
        List<RexNode> exprs = shuttle.apply(oldExprs);
        List<RexLocalRef> oldProjects = this.program.getProjectList();
        List<RexLocalRef> projects = shuttle.apply(oldProjects);
        RexLocalRef oldCondition = this.program.getCondition();
        if (oldCondition != null) {
            condition = shuttle.apply(oldCondition);
            assert (condition instanceof RexLocalRef) : "Invalid condition after rewrite. Expected RexLocalRef, got " + condition;
        } else {
            condition = null;
        }
        if (exprs == oldExprs && projects == oldProjects && condition == oldCondition) {
            return this;
        }
        return this.copy(this.traitSet, this.getInput(), new RexProgram(this.program.getInputRowType(), exprs, projects, (RexLocalRef)condition, this.program.getOutputRowType()));
    }
}

