/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql;

import org.apache.spark.examples.sql.SparkSQLExample;
import org.apache.spark.examples.sql.SparkSQLExample$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class SparkSQLExample$ {
    public static final SparkSQLExample$ MODULE$;

    static {
        new SparkSQLExample$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("Spark SQL basic example").config("spark.some.config.option", "some-value").getOrCreate();
        this.runBasicDataFrameExample(spark);
        this.runDatasetCreationExample(spark);
        this.runInferSchemaExample(spark);
        this.runProgrammaticSchemaExample(spark);
        spark.stop();
    }

    private void runBasicDataFrameExample(SparkSession spark) {
        Dataset df = spark.read().json("examples/src/main/resources/people.json");
        df.show();
        df.printSchema();
        df.select("name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).show();
        df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name"}))).$((Seq)Nil$.MODULE$), spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"age"}))).$((Seq)Nil$.MODULE$).$plus((Object)BoxesRunTime.boxToInteger((int)1))})).show();
        df.filter(spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"age"}))).$((Seq)Nil$.MODULE$).$greater((Object)BoxesRunTime.boxToInteger((int)21))).show();
        df.groupBy("age", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count().show();
        df.createOrReplaceTempView("people");
        Dataset sqlDF = spark.sql("SELECT * FROM people");
        sqlDF.show();
        df.createGlobalTempView("people");
        spark.sql("SELECT * FROM global_temp.people").show();
        spark.newSession().sql("SELECT * FROM global_temp.people").show();
    }

    private void runDatasetCreationExample(SparkSession spark) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_sql_SparkSQLExample$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.examples.sql.SparkSQLExample.Person").asType().toTypeConstructor();
            }

            public Org_apache_spark_examples_sql_SparkSQLExample$$typecreator5$1() {
            }
        }
        Dataset caseClassDS = spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SparkSQLExample.Person[]{new SparkSQLExample.Person("Andy", 32L)})), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_sql_SparkSQLExample$$typecreator5$1()))).toDS();
        caseClassDS.show();
        Dataset primitiveDS = spark.implicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), spark.implicits().newIntEncoder()).toDS();
        primitiveDS.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$1) {
                return this.apply$mcII$sp(x$1);
            }

            public int apply$mcII$sp(int x$1) {
                return x$1 + 1;
            }
        }, spark.implicits().newIntEncoder()).collect();
        String path = "examples/src/main/resources/people.json";
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_sql_SparkSQLExample$$typecreator9$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.examples.sql.SparkSQLExample.Person").asType().toTypeConstructor();
            }

            public Org_apache_spark_examples_sql_SparkSQLExample$$typecreator9$1() {
            }
        }
        Dataset peopleDS = spark.read().json(path).as(spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_examples_sql_SparkSQLExample$$typecreator9$1())));
        peopleDS.show();
    }

    private void runInferSchemaExample(SparkSession spark) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_sql_SparkSQLExample$$typecreator17$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.examples.sql.SparkSQLExample.Person").asType().toTypeConstructor();
            }

            public Org_apache_spark_examples_sql_SparkSQLExample$$typecreator17$1() {
            }
        }
        Dataset peopleDF = spark.implicits().rddToDatasetHolder(spark.sparkContext().textFile("examples/src/main/resources/people.txt", spark.sparkContext().textFile$default$2()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$2) {
                return x$2.split(",");
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SparkSQLExample.Person apply(String[] attributes) {
                return new SparkSQLExample.Person(attributes[0], new StringOps(Predef$.MODULE$.augmentString(attributes[1].trim())).toInt());
            }
        }, ClassTag$.MODULE$.apply(SparkSQLExample.Person.class)), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_sql_SparkSQLExample$$typecreator17$1()))).toDF();
        peopleDF.createOrReplaceTempView("people");
        Dataset teenagersDF = spark.sql("SELECT name, age FROM people WHERE age BETWEEN 13 AND 19");
        teenagersDF.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row teenager) {
                return new StringBuilder().append((Object)"Name: ").append(teenager.apply(0)).toString();
            }
        }, spark.implicits().newStringEncoder()).show();
        teenagersDF.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row teenager) {
                return new StringBuilder().append((Object)"Name: ").append(teenager.getAs("name")).toString();
            }
        }, spark.implicits().newStringEncoder()).show();
        Encoder mapEncoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Map.class));
        teenagersDF.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<String, Object> apply(Row teenager) {
                return teenager.getValuesMap((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "age"})));
            }
        }, mapEncoder).collect();
    }

    private void runProgrammaticSchemaExample(SparkSession spark) {
        RDD peopleRDD = spark.sparkContext().textFile("examples/src/main/resources/people.txt", spark.sparkContext().textFile$default$2());
        String schemaString = "name age";
        StructField[] fields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])schemaString.split(" ")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructField apply(String fieldName) {
                return new StructField(fieldName, (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        StructType schema = new StructType(fields);
        RDD rowRDD = peopleRDD.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$3) {
                return x$3.split(",");
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Row apply(String[] attributes) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attributes[0], attributes[1].trim()}));
            }
        }, ClassTag$.MODULE$.apply(Row.class));
        Dataset peopleDF = spark.createDataFrame(rowRDD, schema);
        peopleDF.createOrReplaceTempView("people");
        Dataset results = spark.sql("SELECT name FROM people");
        results.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row attributes) {
                return new StringBuilder().append((Object)"Name: ").append(attributes.apply(0)).toString();
            }
        }, spark.implicits().newStringEncoder()).show();
    }

    private SparkSQLExample$() {
        MODULE$ = this;
    }
}

