/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.DoubleFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.mllib.regression.IsotonicRegression;
import org.apache.spark.mllib.regression.IsotonicRegressionModel;
import org.apache.spark.mllib.util.MLUtils;
import scala.Tuple2;
import scala.Tuple3;

public class JavaIsotonicRegressionExample {
    public static void main(String[] args) {
        SparkConf sparkConf = new SparkConf().setAppName("JavaIsotonicRegressionExample");
        JavaSparkContext jsc = new JavaSparkContext(sparkConf);
        JavaRDD data = MLUtils.loadLibSVMFile((SparkContext)jsc.sc(), (String)"data/mllib/sample_isotonic_regression_libsvm_data.txt").toJavaRDD();
        JavaRDD parsedData = data.map((Function & Serializable)point -> new Tuple3((Object)point.label(), (Object)point.features().apply(0), (Object)1.0));
        JavaRDD[] splits = parsedData.randomSplit(new double[]{0.6, 0.4}, 11L);
        JavaRDD training = splits[0];
        JavaRDD test = splits[1];
        IsotonicRegressionModel model = new IsotonicRegression().setIsotonic(true).run(training);
        JavaPairRDD predictionAndLabel = test.mapToPair((PairFunction & Serializable)point -> new Tuple2((Object)model.predict(((Double)point._2()).doubleValue()), point._1()));
        double meanSquaredError2 = predictionAndLabel.mapToDouble((DoubleFunction & Serializable)pl -> {
            double diff = (Double)pl._1() - (Double)pl._2();
            return diff * diff;
        }).mean();
        System.out.println("Mean Squared Error = " + meanSquaredError2);
        model.save(jsc.sc(), "target/tmp/myIsotonicRegressionModel");
        IsotonicRegressionModel sameModel = IsotonicRegressionModel.load((SparkContext)jsc.sc(), (String)"target/tmp/myIsotonicRegressionModel");
        jsc.stop();
    }
}

