/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.linalg.Vectors;
import org.apache.spark.ml.stat.Summarizer;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaSummarizerExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaSummarizerExample").getOrCreate();
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{Vectors.dense((double)2.0, (double[])new double[]{3.0, 5.0}), 1.0}), RowFactory.create((Object[])new Object[]{Vectors.dense((double)4.0, (double[])new double[]{6.0, 7.0}), 2.0}));
        StructType schema = new StructType(new StructField[]{new StructField("features", (DataType)new VectorUDT(), false, Metadata.empty()), new StructField("weight", DataTypes.DoubleType, false, Metadata.empty())});
        Dataset df = spark.createDataFrame(data, schema);
        Row result1 = (Row)df.select(new Column[]{Summarizer.metrics((String[])new String[]{"mean", "variance"}).summary(new Column("features"), new Column("weight")).as("summary")}).select("summary.mean", new String[]{"summary.variance"}).first();
        System.out.println("with weight: mean = " + ((Vector)result1.getAs(0)).toString() + ", variance = " + ((Vector)result1.getAs(1)).toString());
        Row result2 = (Row)df.select(new Column[]{Summarizer.mean((Column)new Column("features")), Summarizer.variance((Column)new Column("features"))}).first();
        System.out.println("without weight: mean = " + ((Vector)result2.getAs(0)).toString() + ", variance = " + ((Vector)result2.getAs(1)).toString());
        spark.stop();
    }
}

