/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.ClassUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.MetaStoreInit;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class RawStoreProxy
implements InvocationHandler {
    private final RawStore base;
    private final MetaStoreInit.MetaStoreInitData metaStoreInitData = new MetaStoreInit.MetaStoreInitData();
    private final int id;
    private final HiveConf hiveConf;
    private final Configuration conf;

    protected RawStoreProxy(HiveConf hiveConf, Configuration conf, Class<? extends RawStore> rawStoreClass, int id) throws MetaException {
        this.conf = conf;
        this.hiveConf = hiveConf;
        this.id = id;
        this.init();
        this.base = (RawStore)ReflectionUtils.newInstance(rawStoreClass, (Configuration)conf);
    }

    public static RawStore getProxy(HiveConf hiveConf, Configuration conf, String rawStoreClassName, int id) throws MetaException {
        Class<?> baseClass = MetaStoreUtils.getClass(rawStoreClassName);
        RawStoreProxy handler = new RawStoreProxy(hiveConf, conf, baseClass, id);
        return (RawStore)Proxy.newProxyInstance(RawStoreProxy.class.getClassLoader(), RawStoreProxy.getAllInterfaces(baseClass), (InvocationHandler)handler);
    }

    private static Class<?>[] getAllInterfaces(Class<?> baseClass) {
        List interfaces = ClassUtils.getAllInterfaces(baseClass);
        Class[] result = new Class[interfaces.size()];
        int i = 0;
        for (Object o : interfaces) {
            result[i++] = (Class)o;
        }
        return result;
    }

    private void init() throws MetaException {
        MetaStoreInit.updateConnectionURL(this.hiveConf, this.getConf(), null, this.metaStoreInitData);
    }

    private void initMS() {
        this.base.setConf(this.getConf());
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object ret = null;
        boolean isTimerStarted = false;
        try {
            try {
                if (!Deadline.isStarted()) {
                    Deadline.startTimer(method.getName());
                    isTimerStarted = true;
                }
            }
            catch (MetaException e) {
                long timeout = HiveConf.getTimeVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_CLIENT_SOCKET_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
                Deadline.registerIfNot(timeout);
                Deadline.startTimer(method.getName());
                isTimerStarted = true;
            }
            ret = method.invoke((Object)this.base, args);
            if (isTimerStarted) {
                Deadline.stopTimer();
            }
        }
        catch (UndeclaredThrowableException e) {
            throw e.getCause();
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        return ret;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

