/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dht;

import edu.emory.mathcs.jtransforms.dht.DoubleDHT_1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DoubleDHT_2D {
    private int rows;
    private int columns;
    private double[] t;
    private DoubleDHT_1D dhtColumns;
    private DoubleDHT_1D dhtRows;
    private int oldNthreads;
    private int nt;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public DoubleDHT_2D(int rows, int column) {
        if (rows <= 1 || column <= 1) {
            throw new IllegalArgumentException("rows and columns must be greater than 1");
        }
        this.rows = rows;
        this.columns = column;
        if (rows * column >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2(rows) && ConcurrencyUtils.isPowerOf2(column)) {
            this.isPowerOfTwo = true;
            this.oldNthreads = ConcurrencyUtils.getNumberOfThreads();
            this.nt = 4 * this.oldNthreads * rows;
            if (column == 2 * this.oldNthreads) {
                this.nt >>= 1;
            } else if (column < 2 * this.oldNthreads) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
        }
        this.dhtColumns = new DoubleDHT_1D(column);
        this.dhtRows = column == rows ? this.dhtColumns : new DoubleDHT_1D(rows);
    }

    public void forward(final double[] a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = 4 * nthreads * this.rows;
                if (this.columns == 2 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 2 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, a, true);
                this.ddxt2d0_subth(-1, a, true);
            } else {
                this.ddxt2d_sub(-1, a, true);
                int i = 0;
                while (i < this.rows) {
                    this.dhtColumns.forward(a, i * this.columns);
                    ++i;
                }
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
                Future[] futures = new Future[nthreads];
                int p = this.rows / nthreads;
                int l = 0;
                while (l < nthreads) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int i = firstRow;
                            while (i < lastRow) {
                                DoubleDHT_2D.this.dhtColumns.forward(a, i * DoubleDHT_2D.this.columns);
                                ++i;
                            }
                        }
                    });
                    ++l;
                }
                ConcurrencyUtils.waitForCompletion(futures);
                p = this.columns / nthreads;
                l = 0;
                while (l < nthreads) {
                    final int firstColumn = l * p;
                    final int lastColumn = l == nthreads - 1 ? this.columns : firstColumn + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            double[] temp = new double[DoubleDHT_2D.this.rows];
                            int c = firstColumn;
                            while (c < lastColumn) {
                                int r = 0;
                                while (r < DoubleDHT_2D.this.rows) {
                                    temp[r] = a[r * DoubleDHT_2D.this.columns + c];
                                    ++r;
                                }
                                DoubleDHT_2D.this.dhtRows.forward(temp);
                                r = 0;
                                while (r < DoubleDHT_2D.this.rows) {
                                    a[r * ((DoubleDHT_2D)DoubleDHT_2D.this).columns + c] = temp[r];
                                    ++r;
                                }
                                ++c;
                            }
                        }
                    });
                    ++l;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int i = 0;
                while (i < this.rows) {
                    this.dhtColumns.forward(a, i * this.columns);
                    ++i;
                }
                double[] temp = new double[this.rows];
                int c = 0;
                while (c < this.columns) {
                    int r = 0;
                    while (r < this.rows) {
                        temp[r] = a[r * this.columns + c];
                        ++r;
                    }
                    this.dhtRows.forward(temp);
                    r = 0;
                    while (r < this.rows) {
                        a[r * this.columns + c] = temp[r];
                        ++r;
                    }
                    ++c;
                }
            }
            this.yTransform(a);
        }
    }

    public void forward(final double[][] a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = 4 * nthreads * this.rows;
                if (this.columns == 2 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 2 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, a, true);
                this.ddxt2d0_subth(-1, a, true);
            } else {
                this.ddxt2d_sub(-1, a, true);
                int i = 0;
                while (i < this.rows) {
                    this.dhtColumns.forward(a[i]);
                    ++i;
                }
            }
            this.y_transform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
                Future[] futures = new Future[nthreads];
                int p = this.rows / nthreads;
                int l = 0;
                while (l < nthreads) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int i = firstRow;
                            while (i < lastRow) {
                                DoubleDHT_2D.this.dhtColumns.forward(a[i]);
                                ++i;
                            }
                        }
                    });
                    ++l;
                }
                ConcurrencyUtils.waitForCompletion(futures);
                p = this.columns / nthreads;
                l = 0;
                while (l < nthreads) {
                    final int firstColumn = l * p;
                    final int lastColumn = l == nthreads - 1 ? this.columns : firstColumn + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            double[] temp = new double[DoubleDHT_2D.this.rows];
                            int c = firstColumn;
                            while (c < lastColumn) {
                                int r = 0;
                                while (r < DoubleDHT_2D.this.rows) {
                                    temp[r] = a[r][c];
                                    ++r;
                                }
                                DoubleDHT_2D.this.dhtRows.forward(temp);
                                r = 0;
                                while (r < DoubleDHT_2D.this.rows) {
                                    a[r][c] = temp[r];
                                    ++r;
                                }
                                ++c;
                            }
                        }
                    });
                    ++l;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int i = 0;
                while (i < this.rows) {
                    this.dhtColumns.forward(a[i]);
                    ++i;
                }
                double[] temp = new double[this.rows];
                int c = 0;
                while (c < this.columns) {
                    int r = 0;
                    while (r < this.rows) {
                        temp[r] = a[r][c];
                        ++r;
                    }
                    this.dhtRows.forward(temp);
                    r = 0;
                    while (r < this.rows) {
                        a[r][c] = temp[r];
                        ++r;
                    }
                    ++c;
                }
            }
            this.y_transform(a);
        }
    }

    public void inverse(final double[] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = 4 * nthreads * this.rows;
                if (this.columns == 2 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 2 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(1, a, scale);
                this.ddxt2d0_subth(1, a, scale);
            } else {
                this.ddxt2d_sub(1, a, scale);
                int i = 0;
                while (i < this.rows) {
                    this.dhtColumns.inverse(a, i * this.columns, scale);
                    ++i;
                }
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
                Future[] futures = new Future[nthreads];
                int p = this.rows / nthreads;
                int l = 0;
                while (l < nthreads) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int i = firstRow;
                            while (i < lastRow) {
                                DoubleDHT_2D.this.dhtColumns.inverse(a, i * DoubleDHT_2D.this.columns, scale);
                                ++i;
                            }
                        }
                    });
                    ++l;
                }
                ConcurrencyUtils.waitForCompletion(futures);
                p = this.columns / nthreads;
                l = 0;
                while (l < nthreads) {
                    final int firstColumn = l * p;
                    final int lastColumn = l == nthreads - 1 ? this.columns : firstColumn + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            double[] temp = new double[DoubleDHT_2D.this.rows];
                            int c = firstColumn;
                            while (c < lastColumn) {
                                int r = 0;
                                while (r < DoubleDHT_2D.this.rows) {
                                    temp[r] = a[r * DoubleDHT_2D.this.columns + c];
                                    ++r;
                                }
                                DoubleDHT_2D.this.dhtRows.inverse(temp, scale);
                                r = 0;
                                while (r < DoubleDHT_2D.this.rows) {
                                    a[r * ((DoubleDHT_2D)DoubleDHT_2D.this).columns + c] = temp[r];
                                    ++r;
                                }
                                ++c;
                            }
                        }
                    });
                    ++l;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int i = 0;
                while (i < this.rows) {
                    this.dhtColumns.inverse(a, i * this.columns, scale);
                    ++i;
                }
                double[] temp = new double[this.rows];
                int c = 0;
                while (c < this.columns) {
                    int r = 0;
                    while (r < this.rows) {
                        temp[r] = a[r * this.columns + c];
                        ++r;
                    }
                    this.dhtRows.inverse(temp, scale);
                    r = 0;
                    while (r < this.rows) {
                        a[r * this.columns + c] = temp[r];
                        ++r;
                    }
                    ++c;
                }
            }
            this.yTransform(a);
        }
    }

    public void inverse(final double[][] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = 4 * nthreads * this.rows;
                if (this.columns == 2 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 2 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(1, a, scale);
                this.ddxt2d0_subth(1, a, scale);
            } else {
                this.ddxt2d_sub(1, a, scale);
                int i = 0;
                while (i < this.rows) {
                    this.dhtColumns.inverse(a[i], scale);
                    ++i;
                }
            }
            this.y_transform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
                Future[] futures = new Future[nthreads];
                int p = this.rows / nthreads;
                int l = 0;
                while (l < nthreads) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int i = firstRow;
                            while (i < lastRow) {
                                DoubleDHT_2D.this.dhtColumns.inverse(a[i], scale);
                                ++i;
                            }
                        }
                    });
                    ++l;
                }
                ConcurrencyUtils.waitForCompletion(futures);
                p = this.columns / nthreads;
                l = 0;
                while (l < nthreads) {
                    final int firstColumn = l * p;
                    final int lastColumn = l == nthreads - 1 ? this.columns : firstColumn + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            double[] temp = new double[DoubleDHT_2D.this.rows];
                            int c = firstColumn;
                            while (c < lastColumn) {
                                int r = 0;
                                while (r < DoubleDHT_2D.this.rows) {
                                    temp[r] = a[r][c];
                                    ++r;
                                }
                                DoubleDHT_2D.this.dhtRows.inverse(temp, scale);
                                r = 0;
                                while (r < DoubleDHT_2D.this.rows) {
                                    a[r][c] = temp[r];
                                    ++r;
                                }
                                ++c;
                            }
                        }
                    });
                    ++l;
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int i = 0;
                while (i < this.rows) {
                    this.dhtColumns.inverse(a[i], scale);
                    ++i;
                }
                double[] temp = new double[this.rows];
                int c = 0;
                while (c < this.columns) {
                    int r = 0;
                    while (r < this.rows) {
                        temp[r] = a[r][c];
                        ++r;
                    }
                    this.dhtRows.inverse(temp, scale);
                    r = 0;
                    while (r < this.rows) {
                        a[r][c] = temp[r];
                        ++r;
                    }
                    ++c;
                }
            }
            this.y_transform(a);
        }
    }

    private void ddxt2d_subth(final int isgn, final double[] a, final boolean scale) {
        int nthread = ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2 * nthread) {
            nt >>= 1;
        } else if (this.columns < 2 * nthread) {
            nthread = this.columns;
            nt >>= 2;
        }
        final int nthreads = nthread;
        Future[] futures = new Future[nthreads];
        int i = 0;
        while (i < nthreads) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    block17: {
                        block18: {
                            int idx2;
                            int idx1;
                            block16: {
                                if (DoubleDHT_2D.this.columns <= 2 * nthreads) break block16;
                                if (isgn == -1) {
                                    int c = 4 * n0;
                                    while (c < DoubleDHT_2D.this.columns) {
                                        int idx22;
                                        int idx12;
                                        int r = 0;
                                        while (r < DoubleDHT_2D.this.rows) {
                                            idx12 = r * DoubleDHT_2D.this.columns + c;
                                            idx22 = startt + DoubleDHT_2D.this.rows + r;
                                            ((DoubleDHT_2D)DoubleDHT_2D.this).t[startt + r] = a[idx12];
                                            ((DoubleDHT_2D)DoubleDHT_2D.this).t[idx22] = a[idx12 + 1];
                                            ((DoubleDHT_2D)DoubleDHT_2D.this).t[idx22 + ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = a[idx12 + 2];
                                            ((DoubleDHT_2D)DoubleDHT_2D.this).t[idx22 + 2 * ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = a[idx12 + 3];
                                            ++r;
                                        }
                                        DoubleDHT_2D.this.dhtRows.forward(DoubleDHT_2D.this.t, startt);
                                        DoubleDHT_2D.this.dhtRows.forward(DoubleDHT_2D.this.t, startt + DoubleDHT_2D.this.rows);
                                        DoubleDHT_2D.this.dhtRows.forward(DoubleDHT_2D.this.t, startt + 2 * DoubleDHT_2D.this.rows);
                                        DoubleDHT_2D.this.dhtRows.forward(DoubleDHT_2D.this.t, startt + 3 * DoubleDHT_2D.this.rows);
                                        r = 0;
                                        while (r < DoubleDHT_2D.this.rows) {
                                            idx12 = r * DoubleDHT_2D.this.columns + c;
                                            idx22 = startt + DoubleDHT_2D.this.rows + r;
                                            a[idx12] = DoubleDHT_2D.this.t[startt + r];
                                            a[idx12 + 1] = DoubleDHT_2D.this.t[idx22];
                                            a[idx12 + 2] = DoubleDHT_2D.this.t[idx22 + DoubleDHT_2D.this.rows];
                                            a[idx12 + 3] = DoubleDHT_2D.this.t[idx22 + 2 * DoubleDHT_2D.this.rows];
                                            ++r;
                                        }
                                        c += 4 * nthreads;
                                    }
                                } else {
                                    int c = 4 * n0;
                                    while (c < DoubleDHT_2D.this.columns) {
                                        int idx23;
                                        int idx13;
                                        int r = 0;
                                        while (r < DoubleDHT_2D.this.rows) {
                                            idx13 = r * DoubleDHT_2D.this.columns + c;
                                            idx23 = startt + DoubleDHT_2D.this.rows + r;
                                            ((DoubleDHT_2D)DoubleDHT_2D.this).t[startt + r] = a[idx13];
                                            ((DoubleDHT_2D)DoubleDHT_2D.this).t[idx23] = a[idx13 + 1];
                                            ((DoubleDHT_2D)DoubleDHT_2D.this).t[idx23 + ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = a[idx13 + 2];
                                            ((DoubleDHT_2D)DoubleDHT_2D.this).t[idx23 + 2 * ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = a[idx13 + 3];
                                            ++r;
                                        }
                                        DoubleDHT_2D.this.dhtRows.inverse(DoubleDHT_2D.this.t, startt, scale);
                                        DoubleDHT_2D.this.dhtRows.inverse(DoubleDHT_2D.this.t, startt + DoubleDHT_2D.this.rows, scale);
                                        DoubleDHT_2D.this.dhtRows.inverse(DoubleDHT_2D.this.t, startt + 2 * DoubleDHT_2D.this.rows, scale);
                                        DoubleDHT_2D.this.dhtRows.inverse(DoubleDHT_2D.this.t, startt + 3 * DoubleDHT_2D.this.rows, scale);
                                        r = 0;
                                        while (r < DoubleDHT_2D.this.rows) {
                                            idx13 = r * DoubleDHT_2D.this.columns + c;
                                            idx23 = startt + DoubleDHT_2D.this.rows + r;
                                            a[idx13] = DoubleDHT_2D.this.t[startt + r];
                                            a[idx13 + 1] = DoubleDHT_2D.this.t[idx23];
                                            a[idx13 + 2] = DoubleDHT_2D.this.t[idx23 + DoubleDHT_2D.this.rows];
                                            a[idx13 + 3] = DoubleDHT_2D.this.t[idx23 + 2 * DoubleDHT_2D.this.rows];
                                            ++r;
                                        }
                                        c += 4 * nthreads;
                                    }
                                }
                                break block17;
                            }
                            if (DoubleDHT_2D.this.columns != 2 * nthreads) break block18;
                            int r = 0;
                            while (r < DoubleDHT_2D.this.rows) {
                                idx1 = r * DoubleDHT_2D.this.columns + 2 * n0;
                                idx2 = startt + r;
                                ((DoubleDHT_2D)DoubleDHT_2D.this).t[idx2] = a[idx1];
                                ((DoubleDHT_2D)DoubleDHT_2D.this).t[idx2 + ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = a[idx1 + 1];
                                ++r;
                            }
                            if (isgn == -1) {
                                DoubleDHT_2D.this.dhtRows.forward(DoubleDHT_2D.this.t, startt);
                                DoubleDHT_2D.this.dhtRows.forward(DoubleDHT_2D.this.t, startt + DoubleDHT_2D.this.rows);
                            } else {
                                DoubleDHT_2D.this.dhtRows.inverse(DoubleDHT_2D.this.t, startt, scale);
                                DoubleDHT_2D.this.dhtRows.inverse(DoubleDHT_2D.this.t, startt + DoubleDHT_2D.this.rows, scale);
                            }
                            r = 0;
                            while (r < DoubleDHT_2D.this.rows) {
                                idx1 = r * DoubleDHT_2D.this.columns + 2 * n0;
                                idx2 = startt + r;
                                a[idx1] = DoubleDHT_2D.this.t[idx2];
                                a[idx1 + 1] = DoubleDHT_2D.this.t[idx2 + DoubleDHT_2D.this.rows];
                                ++r;
                            }
                            break block17;
                        }
                        if (DoubleDHT_2D.this.columns != nthreads) break block17;
                        int r = 0;
                        while (r < DoubleDHT_2D.this.rows) {
                            ((DoubleDHT_2D)DoubleDHT_2D.this).t[startt + r] = a[r * DoubleDHT_2D.this.columns + n0];
                            ++r;
                        }
                        if (isgn == -1) {
                            DoubleDHT_2D.this.dhtRows.forward(DoubleDHT_2D.this.t, startt);
                        } else {
                            DoubleDHT_2D.this.dhtRows.inverse(DoubleDHT_2D.this.t, startt, scale);
                        }
                        r = 0;
                        while (r < DoubleDHT_2D.this.rows) {
                            a[r * ((DoubleDHT_2D)DoubleDHT_2D.this).columns + n0] = DoubleDHT_2D.this.t[startt + r];
                            ++r;
                        }
                    }
                }
            });
            ++i;
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt2d_subth(final int isgn, final double[][] a, final boolean scale) {
        int nthread = ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2 * nthread) {
            nt >>= 1;
        } else if (this.columns < 2 * nthread) {
            nthread = this.columns;
            nt >>= 2;
        }
        final int nthreads = nthread;
        Future[] futures = new Future[nthreads];
        int i = 0;
        while (i < nthreads) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    block17: {
                        block18: {
                            int idx2;
                            block16: {
                                if (DoubleDHT_2D.this.columns <= 2 * nthreads) break block16;
                                if (isgn == -1) {
                                    int c = 4 * n0;
                                    while (c < DoubleDHT_2D.this.columns) {
                                        int idx22;
                                        int r = 0;
                                        while (r < DoubleDHT_2D.this.rows) {
                                            idx22 = startt + DoubleDHT_2D.this.rows + r;
                                            ((DoubleDHT_2D)DoubleDHT_2D.this).t[startt + r] = a[r][c];
                                            ((DoubleDHT_2D)DoubleDHT_2D.this).t[idx22] = a[r][c + 1];
                                            ((DoubleDHT_2D)DoubleDHT_2D.this).t[idx22 + ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = a[r][c + 2];
                                            ((DoubleDHT_2D)DoubleDHT_2D.this).t[idx22 + 2 * ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = a[r][c + 3];
                                            ++r;
                                        }
                                        DoubleDHT_2D.this.dhtRows.forward(DoubleDHT_2D.this.t, startt);
                                        DoubleDHT_2D.this.dhtRows.forward(DoubleDHT_2D.this.t, startt + DoubleDHT_2D.this.rows);
                                        DoubleDHT_2D.this.dhtRows.forward(DoubleDHT_2D.this.t, startt + 2 * DoubleDHT_2D.this.rows);
                                        DoubleDHT_2D.this.dhtRows.forward(DoubleDHT_2D.this.t, startt + 3 * DoubleDHT_2D.this.rows);
                                        r = 0;
                                        while (r < DoubleDHT_2D.this.rows) {
                                            idx22 = startt + DoubleDHT_2D.this.rows + r;
                                            a[r][c] = DoubleDHT_2D.this.t[startt + r];
                                            a[r][c + 1] = DoubleDHT_2D.this.t[idx22];
                                            a[r][c + 2] = DoubleDHT_2D.this.t[idx22 + DoubleDHT_2D.this.rows];
                                            a[r][c + 3] = DoubleDHT_2D.this.t[idx22 + 2 * DoubleDHT_2D.this.rows];
                                            ++r;
                                        }
                                        c += 4 * nthreads;
                                    }
                                } else {
                                    int c = 4 * n0;
                                    while (c < DoubleDHT_2D.this.columns) {
                                        int idx23;
                                        int r = 0;
                                        while (r < DoubleDHT_2D.this.rows) {
                                            idx23 = startt + DoubleDHT_2D.this.rows + r;
                                            ((DoubleDHT_2D)DoubleDHT_2D.this).t[startt + r] = a[r][c];
                                            ((DoubleDHT_2D)DoubleDHT_2D.this).t[idx23] = a[r][c + 1];
                                            ((DoubleDHT_2D)DoubleDHT_2D.this).t[idx23 + ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = a[r][c + 2];
                                            ((DoubleDHT_2D)DoubleDHT_2D.this).t[idx23 + 2 * ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = a[r][c + 3];
                                            ++r;
                                        }
                                        DoubleDHT_2D.this.dhtRows.inverse(DoubleDHT_2D.this.t, startt, scale);
                                        DoubleDHT_2D.this.dhtRows.inverse(DoubleDHT_2D.this.t, startt + DoubleDHT_2D.this.rows, scale);
                                        DoubleDHT_2D.this.dhtRows.inverse(DoubleDHT_2D.this.t, startt + 2 * DoubleDHT_2D.this.rows, scale);
                                        DoubleDHT_2D.this.dhtRows.inverse(DoubleDHT_2D.this.t, startt + 3 * DoubleDHT_2D.this.rows, scale);
                                        r = 0;
                                        while (r < DoubleDHT_2D.this.rows) {
                                            idx23 = startt + DoubleDHT_2D.this.rows + r;
                                            a[r][c] = DoubleDHT_2D.this.t[startt + r];
                                            a[r][c + 1] = DoubleDHT_2D.this.t[idx23];
                                            a[r][c + 2] = DoubleDHT_2D.this.t[idx23 + DoubleDHT_2D.this.rows];
                                            a[r][c + 3] = DoubleDHT_2D.this.t[idx23 + 2 * DoubleDHT_2D.this.rows];
                                            ++r;
                                        }
                                        c += 4 * nthreads;
                                    }
                                }
                                break block17;
                            }
                            if (DoubleDHT_2D.this.columns != 2 * nthreads) break block18;
                            int r = 0;
                            while (r < DoubleDHT_2D.this.rows) {
                                idx2 = startt + r;
                                ((DoubleDHT_2D)DoubleDHT_2D.this).t[idx2] = a[r][2 * n0];
                                ((DoubleDHT_2D)DoubleDHT_2D.this).t[idx2 + ((DoubleDHT_2D)DoubleDHT_2D.this).rows] = a[r][2 * n0 + 1];
                                ++r;
                            }
                            if (isgn == -1) {
                                DoubleDHT_2D.this.dhtRows.forward(DoubleDHT_2D.this.t, startt);
                                DoubleDHT_2D.this.dhtRows.forward(DoubleDHT_2D.this.t, startt + DoubleDHT_2D.this.rows);
                            } else {
                                DoubleDHT_2D.this.dhtRows.inverse(DoubleDHT_2D.this.t, startt, scale);
                                DoubleDHT_2D.this.dhtRows.inverse(DoubleDHT_2D.this.t, startt + DoubleDHT_2D.this.rows, scale);
                            }
                            r = 0;
                            while (r < DoubleDHT_2D.this.rows) {
                                idx2 = startt + r;
                                a[r][2 * n0] = DoubleDHT_2D.this.t[idx2];
                                a[r][2 * n0 + 1] = DoubleDHT_2D.this.t[idx2 + DoubleDHT_2D.this.rows];
                                ++r;
                            }
                            break block17;
                        }
                        if (DoubleDHT_2D.this.columns != nthreads) break block17;
                        int r = 0;
                        while (r < DoubleDHT_2D.this.rows) {
                            ((DoubleDHT_2D)DoubleDHT_2D.this).t[startt + r] = a[r][n0];
                            ++r;
                        }
                        if (isgn == -1) {
                            DoubleDHT_2D.this.dhtRows.forward(DoubleDHT_2D.this.t, startt);
                        } else {
                            DoubleDHT_2D.this.dhtRows.inverse(DoubleDHT_2D.this.t, startt, scale);
                        }
                        r = 0;
                        while (r < DoubleDHT_2D.this.rows) {
                            a[r][n0] = DoubleDHT_2D.this.t[startt + r];
                            ++r;
                        }
                    }
                }
            });
            ++i;
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt2d0_subth(final int isgn, final double[] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        int i = 0;
        while (i < nthreads) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    if (isgn == -1) {
                        int r = n0;
                        while (r < DoubleDHT_2D.this.rows) {
                            DoubleDHT_2D.this.dhtColumns.forward(a, r * DoubleDHT_2D.this.columns);
                            r += nthreads;
                        }
                    } else {
                        int r = n0;
                        while (r < DoubleDHT_2D.this.rows) {
                            DoubleDHT_2D.this.dhtColumns.inverse(a, r * DoubleDHT_2D.this.columns, scale);
                            r += nthreads;
                        }
                    }
                }
            });
            ++i;
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt2d0_subth(final int isgn, final double[][] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        int i = 0;
        while (i < nthreads) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    if (isgn == -1) {
                        int r = n0;
                        while (r < DoubleDHT_2D.this.rows) {
                            DoubleDHT_2D.this.dhtColumns.forward(a[r]);
                            r += nthreads;
                        }
                    } else {
                        int r = n0;
                        while (r < DoubleDHT_2D.this.rows) {
                            DoubleDHT_2D.this.dhtColumns.inverse(a[r], scale);
                            r += nthreads;
                        }
                    }
                }
            });
            ++i;
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt2d_sub(int isgn, double[] a, boolean scale) {
        block13: {
            int idx1;
            block12: {
                if (this.columns <= 2) break block12;
                if (isgn == -1) {
                    int c = 0;
                    while (c < this.columns) {
                        int idx2;
                        int idx12;
                        int r = 0;
                        while (r < this.rows) {
                            idx12 = r * this.columns + c;
                            idx2 = this.rows + r;
                            this.t[r] = a[idx12];
                            this.t[idx2] = a[idx12 + 1];
                            this.t[idx2 + this.rows] = a[idx12 + 2];
                            this.t[idx2 + 2 * this.rows] = a[idx12 + 3];
                            ++r;
                        }
                        this.dhtRows.forward(this.t, 0);
                        this.dhtRows.forward(this.t, this.rows);
                        this.dhtRows.forward(this.t, 2 * this.rows);
                        this.dhtRows.forward(this.t, 3 * this.rows);
                        r = 0;
                        while (r < this.rows) {
                            idx12 = r * this.columns + c;
                            idx2 = this.rows + r;
                            a[idx12] = this.t[r];
                            a[idx12 + 1] = this.t[idx2];
                            a[idx12 + 2] = this.t[idx2 + this.rows];
                            a[idx12 + 3] = this.t[idx2 + 2 * this.rows];
                            ++r;
                        }
                        c += 4;
                    }
                } else {
                    int c = 0;
                    while (c < this.columns) {
                        int idx2;
                        int idx13;
                        int r = 0;
                        while (r < this.rows) {
                            idx13 = r * this.columns + c;
                            idx2 = this.rows + r;
                            this.t[r] = a[idx13];
                            this.t[idx2] = a[idx13 + 1];
                            this.t[idx2 + this.rows] = a[idx13 + 2];
                            this.t[idx2 + 2 * this.rows] = a[idx13 + 3];
                            ++r;
                        }
                        this.dhtRows.inverse(this.t, 0, scale);
                        this.dhtRows.inverse(this.t, this.rows, scale);
                        this.dhtRows.inverse(this.t, 2 * this.rows, scale);
                        this.dhtRows.inverse(this.t, 3 * this.rows, scale);
                        r = 0;
                        while (r < this.rows) {
                            idx13 = r * this.columns + c;
                            idx2 = this.rows + r;
                            a[idx13] = this.t[r];
                            a[idx13 + 1] = this.t[idx2];
                            a[idx13 + 2] = this.t[idx2 + this.rows];
                            a[idx13 + 3] = this.t[idx2 + 2 * this.rows];
                            ++r;
                        }
                        c += 4;
                    }
                }
                break block13;
            }
            if (this.columns != 2) break block13;
            int r = 0;
            while (r < this.rows) {
                idx1 = r * this.columns;
                this.t[r] = a[idx1];
                this.t[this.rows + r] = a[idx1 + 1];
                ++r;
            }
            if (isgn == -1) {
                this.dhtRows.forward(this.t, 0);
                this.dhtRows.forward(this.t, this.rows);
            } else {
                this.dhtRows.inverse(this.t, 0, scale);
                this.dhtRows.inverse(this.t, this.rows, scale);
            }
            r = 0;
            while (r < this.rows) {
                idx1 = r * this.columns;
                a[idx1] = this.t[r];
                a[idx1 + 1] = this.t[this.rows + r];
                ++r;
            }
        }
    }

    private void ddxt2d_sub(int isgn, double[][] a, boolean scale) {
        block13: {
            block12: {
                if (this.columns <= 2) break block12;
                if (isgn == -1) {
                    int c = 0;
                    while (c < this.columns) {
                        int idx2;
                        int r = 0;
                        while (r < this.rows) {
                            idx2 = this.rows + r;
                            this.t[r] = a[r][c];
                            this.t[idx2] = a[r][c + 1];
                            this.t[idx2 + this.rows] = a[r][c + 2];
                            this.t[idx2 + 2 * this.rows] = a[r][c + 3];
                            ++r;
                        }
                        this.dhtRows.forward(this.t, 0);
                        this.dhtRows.forward(this.t, this.rows);
                        this.dhtRows.forward(this.t, 2 * this.rows);
                        this.dhtRows.forward(this.t, 3 * this.rows);
                        r = 0;
                        while (r < this.rows) {
                            idx2 = this.rows + r;
                            a[r][c] = this.t[r];
                            a[r][c + 1] = this.t[idx2];
                            a[r][c + 2] = this.t[idx2 + this.rows];
                            a[r][c + 3] = this.t[idx2 + 2 * this.rows];
                            ++r;
                        }
                        c += 4;
                    }
                } else {
                    int c = 0;
                    while (c < this.columns) {
                        int idx2;
                        int r = 0;
                        while (r < this.rows) {
                            idx2 = this.rows + r;
                            this.t[r] = a[r][c];
                            this.t[idx2] = a[r][c + 1];
                            this.t[idx2 + this.rows] = a[r][c + 2];
                            this.t[idx2 + 2 * this.rows] = a[r][c + 3];
                            ++r;
                        }
                        this.dhtRows.inverse(this.t, 0, scale);
                        this.dhtRows.inverse(this.t, this.rows, scale);
                        this.dhtRows.inverse(this.t, 2 * this.rows, scale);
                        this.dhtRows.inverse(this.t, 3 * this.rows, scale);
                        r = 0;
                        while (r < this.rows) {
                            idx2 = this.rows + r;
                            a[r][c] = this.t[r];
                            a[r][c + 1] = this.t[idx2];
                            a[r][c + 2] = this.t[idx2 + this.rows];
                            a[r][c + 3] = this.t[idx2 + 2 * this.rows];
                            ++r;
                        }
                        c += 4;
                    }
                }
                break block13;
            }
            if (this.columns != 2) break block13;
            int r = 0;
            while (r < this.rows) {
                this.t[r] = a[r][0];
                this.t[this.rows + r] = a[r][1];
                ++r;
            }
            if (isgn == -1) {
                this.dhtRows.forward(this.t, 0);
                this.dhtRows.forward(this.t, this.rows);
            } else {
                this.dhtRows.inverse(this.t, 0, scale);
                this.dhtRows.inverse(this.t, this.rows, scale);
            }
            r = 0;
            while (r < this.rows) {
                a[r][0] = this.t[r];
                a[r][1] = this.t[this.rows + r];
                ++r;
            }
        }
    }

    private void yTransform(double[] a) {
        int r = 0;
        while (r <= this.rows / 2) {
            int mRow = (this.rows - r) % this.rows;
            int idx1 = r * this.columns;
            int idx2 = mRow * this.columns;
            int c = 0;
            while (c <= this.columns / 2) {
                int mCol = (this.columns - c) % this.columns;
                double A = a[idx1 + c];
                double B = a[idx2 + c];
                double C = a[idx1 + mCol];
                double D = a[idx2 + mCol];
                double E = (A + D - (B + C)) / 2.0;
                a[idx1 + c] = A - E;
                a[idx2 + c] = B + E;
                a[idx1 + mCol] = C + E;
                a[idx2 + mCol] = D - E;
                ++c;
            }
            ++r;
        }
    }

    private void y_transform(double[][] a) {
        int r = 0;
        while (r <= this.rows / 2) {
            int mRow = (this.rows - r) % this.rows;
            int c = 0;
            while (c <= this.columns / 2) {
                int mCol = (this.columns - c) % this.columns;
                double A = a[r][c];
                double B = a[mRow][c];
                double C = a[r][mCol];
                double D = a[mRow][mCol];
                double E = (A + D - (B + C)) / 2.0;
                a[r][c] = A - E;
                a[mRow][c] = B + E;
                a[r][mCol] = C + E;
                a[mRow][mCol] = D - E;
                ++c;
            }
            ++r;
        }
    }
}

