/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming.clickstream;

import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Random;
import org.apache.spark.examples.streaming.clickstream.PageView;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;

public final class PageViewGenerator$ {
    public static final PageViewGenerator$ MODULE$;
    private final Map<String, Object> pages;
    private final Map<Object, Object> httpStatus;
    private final Map<Object, Object> userZipCode;
    private final Map<Object, Object> userID;

    static {
        new PageViewGenerator$();
    }

    public Map<String, Object> pages() {
        return this.pages;
    }

    public Map<Object, Object> httpStatus() {
        return this.httpStatus;
    }

    public Map<Object, Object> userZipCode() {
        return this.userZipCode;
    }

    public Map<Object, Object> userID() {
        return this.userID;
    }

    public <T> T pickFromDistribution(Map<T, Object> inputMap) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Object object;
            Object object2 = new Object();
            try {
                double rand = new Random().nextDouble();
                DoubleRef total = DoubleRef.create((double)0.0);
                inputMap.withFilter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<T, Object> check$ifrefutable$1) {
                        Tuple2<T, Object> tuple2 = check$ifrefutable$1;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(rand, total, object2){
                    public static final long serialVersionUID = 0L;
                    private final double rand$1;
                    private final DoubleRef total$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(Tuple2<T, Object> x$2) {
                        Tuple2<T, Object> tuple2 = x$2;
                        if (tuple2 != null) {
                            Object item = tuple2._1();
                            double prob = tuple2._2$mcD$sp();
                            this.total$1.elem += prob;
                            if (this.total$1.elem > this.rand$1) {
                                throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, item);
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.rand$1 = rand$1;
                        this.total$1 = total$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                object = ((Tuple2)((IterableLike)inputMap.take(1)).head())._1();
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object2) break block2;
                object = nonLocalReturnControl2.value();
            }
            return (T)object;
        }
        throw nonLocalReturnControl2;
    }

    public String getNextClickEvent() {
        int id = BoxesRunTime.unboxToInt((Object)this.pickFromDistribution(this.userID()));
        String page = this.pickFromDistribution(this.pages());
        int status = BoxesRunTime.unboxToInt((Object)this.pickFromDistribution(this.httpStatus()));
        int zipCode = BoxesRunTime.unboxToInt((Object)this.pickFromDistribution(this.userZipCode()));
        return new PageView(page, status, zipCode, id).toString();
    }

    public void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: PageViewGenerator <port> <viewsPerSecond>");
            System.exit(1);
        }
        int port = new StringOps(Predef$.MODULE$.augmentString(args[0])).toInt();
        float viewsPerSecond = new StringOps(Predef$.MODULE$.augmentString(args[1])).toFloat();
        int sleepDelayMs = (int)(1000.0 / (double)viewsPerSecond);
        ServerSocket listener = new ServerSocket(port);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listening on port: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)port)})));
        while (true) {
            Socket socket = listener.accept();
            new Thread(sleepDelayMs, socket){
                private final int sleepDelayMs$1;
                private final Socket socket$1;

                public void run() {
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got client connected from: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.socket$1.getInetAddress()})));
                    PrintWriter out = new PrintWriter(this.socket$1.getOutputStream(), true);
                    while (true) {
                        Thread.sleep(this.sleepDelayMs$1);
                        out.write(PageViewGenerator$.MODULE$.getNextClickEvent());
                        out.flush();
                    }
                }
                {
                    this.sleepDelayMs$1 = sleepDelayMs$1;
                    this.socket$1 = socket$1;
                }
            }.start();
        }
    }

    private PageViewGenerator$() {
        MODULE$ = this;
        this.pages = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"http://foo.com/"), (Object)BoxesRunTime.boxToDouble((double)0.7)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"http://foo.com/news"), (Object)BoxesRunTime.boxToDouble((double)0.2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"http://foo.com/contact"), (Object)BoxesRunTime.boxToDouble((double)0.1))}));
        this.httpStatus = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)200)), (Object)BoxesRunTime.boxToDouble((double)0.95)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)404)), (Object)BoxesRunTime.boxToDouble((double)0.05))}));
        this.userZipCode = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)94709)), (Object)BoxesRunTime.boxToDouble((double)0.5)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)94117)), (Object)BoxesRunTime.boxToDouble((double)0.5))}));
        this.userID = (Map)Predef$.MODULE$.Map().apply((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(int x$1) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)x$1)), (Object)BoxesRunTime.boxToDouble((double)0.01));
            }
        }, IndexedSeq$.MODULE$.canBuildFrom()));
    }
}

