/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql.streaming;

import java.sql.Timestamp;
import org.apache.spark.examples.sql.streaming.Event;
import org.apache.spark.examples.sql.streaming.SessionInfo;
import org.apache.spark.examples.sql.streaming.SessionUpdate;
import org.apache.spark.examples.sql.streaming.StructuredSessionization$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.streaming.GroupState;
import org.apache.spark.sql.streaming.GroupStateTimeout;
import org.apache.spark.sql.streaming.StreamingQuery;
import scala.Array$;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

public final class StructuredSessionization$ {
    public static final StructuredSessionization$ MODULE$;

    static {
        new StructuredSessionization$();
    }

    public void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: StructuredSessionization <hostname> <port>");
            System.exit(1);
        }
        String host = args[0];
        int port = new StringOps(Predef$.MODULE$.augmentString(args[1])).toInt();
        SparkSession spark = SparkSession$.MODULE$.builder().appName("StructuredSessionization").getOrCreate();
        Dataset lines = spark.readStream().format("socket").option("host", host).option("port", (long)port).option("includeTimestamp", true).load();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_sql_streaming_StructuredSessionization$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $m.staticClass("java.sql.Timestamp").asType().toTypeConstructor()})));
            }

            public Org_apache_spark_examples_sql_streaming_StructuredSessionization$$typecreator4$1() {
            }
        }
        public final class Org_apache_spark_examples_sql_streaming_StructuredSessionization$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.examples.sql.streaming.Event").asType().toTypeConstructor();
            }

            public Org_apache_spark_examples_sql_streaming_StructuredSessionization$$typecreator5$1() {
            }
        }
        Dataset events = lines.as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_examples_sql_streaming_StructuredSessionization$$typecreator4$1()))).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<Event> apply(Tuple2<String, Timestamp> x0$1) {
                Tuple2<String, Timestamp> tuple2 = x0$1;
                if (tuple2 != null) {
                    String line = (String)tuple2._1();
                    Timestamp timestamp = (Timestamp)tuple2._2();
                    ArrayOps arrayOps = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])line.split(" ")).map((Function1)new Serializable(this, timestamp){
                        public static final long serialVersionUID = 0L;
                        private final Timestamp timestamp$1;

                        public final Event apply(String word) {
                            return new Event(word, this.timestamp$1);
                        }
                        {
                            this.timestamp$1 = timestamp$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Event.class))));
                    return arrayOps;
                }
                throw new MatchError(tuple2);
            }
        }, spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_examples_sql_streaming_StructuredSessionization$$typecreator5$1())));
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_examples_sql_streaming_StructuredSessionization$$typecreator13$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.examples.sql.streaming.SessionInfo").asType().toTypeConstructor();
            }

            public Org_apache_spark_examples_sql_streaming_StructuredSessionization$$typecreator13$1() {
            }
        }
        public final class Org_apache_spark_examples_sql_streaming_StructuredSessionization$$typecreator17$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.examples.sql.streaming.SessionUpdate").asType().toTypeConstructor();
            }

            public Org_apache_spark_examples_sql_streaming_StructuredSessionization$$typecreator17$1() {
            }
        }
        Dataset sessionUpdates = events.groupByKey((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Event event) {
                return event.sessionId();
            }
        }, spark.implicits().newStringEncoder()).mapGroupsWithState(GroupStateTimeout.ProcessingTimeTimeout(), (Function3)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SessionUpdate apply(String x0$2, Iterator<Event> x1$1, GroupState<SessionInfo> x2$1) {
                Tuple3 tuple3 = new Tuple3((Object)x0$2, x1$1, x2$1);
                if (tuple3 != null) {
                    String sessionId = (String)tuple3._1();
                    Iterator events = (Iterator)tuple3._2();
                    GroupState state = (GroupState)tuple3._3();
                    if (sessionId != null) {
                        String string = sessionId;
                        if (events != null) {
                            Iterator iterator = events;
                            if (state != null) {
                                SessionUpdate sessionUpdate;
                                GroupState groupState = state;
                                if (groupState.hasTimedOut()) {
                                    SessionUpdate finalUpdate = new SessionUpdate(string, ((SessionInfo)groupState.get()).durationMs(), ((SessionInfo)groupState.get()).numEvents(), true);
                                    groupState.remove();
                                    sessionUpdate = finalUpdate;
                                } else {
                                    SessionInfo sessionInfo;
                                    Seq timestamps = iterator.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final long apply(Event x$1) {
                                            return x$1.timestamp().getTime();
                                        }
                                    }).toSeq();
                                    if (groupState.exists()) {
                                        SessionInfo oldSession = (SessionInfo)groupState.get();
                                        sessionInfo = new SessionInfo(oldSession.numEvents() + timestamps.size(), oldSession.startTimestampMs(), scala.math.package$.MODULE$.max(oldSession.endTimestampMs(), BoxesRunTime.unboxToLong((Object)timestamps.max((Ordering)Ordering.Long$.MODULE$))));
                                    } else {
                                        sessionInfo = new SessionInfo(timestamps.size(), BoxesRunTime.unboxToLong((Object)timestamps.min((Ordering)Ordering.Long$.MODULE$)), BoxesRunTime.unboxToLong((Object)timestamps.max((Ordering)Ordering.Long$.MODULE$)));
                                    }
                                    SessionInfo updatedSession = sessionInfo;
                                    groupState.update((Object)updatedSession);
                                    groupState.setTimeoutDuration("10 seconds");
                                    sessionUpdate = new SessionUpdate(string, ((SessionInfo)groupState.get()).durationMs(), ((SessionInfo)groupState.get()).numEvents(), false);
                                }
                                SessionUpdate sessionUpdate2 = sessionUpdate;
                                return sessionUpdate2;
                            }
                        }
                    }
                }
                throw new MatchError((Object)tuple3);
            }
        }, spark.implicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_examples_sql_streaming_StructuredSessionization$$typecreator13$1())), spark.implicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_examples_sql_streaming_StructuredSessionization$$typecreator17$1())));
        StreamingQuery query = sessionUpdates.writeStream().outputMode("update").format("console").start();
        query.awaitTermination();
    }

    private StructuredSessionization$() {
        MODULE$ = this;
    }
}

