/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql.streaming;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.MapGroupsWithStateFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.streaming.GroupState;
import org.apache.spark.sql.streaming.GroupStateTimeout;
import org.apache.spark.sql.streaming.StreamingQuery;

public final class JavaStructuredSessionization {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: JavaStructuredSessionization <hostname> <port>");
            System.exit(1);
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        SparkSession spark = SparkSession.builder().appName("JavaStructuredSessionization").getOrCreate();
        Dataset lines = spark.readStream().format("socket").option("host", host).option("port", (long)port).option("includeTimestamp", true).load();
        FlatMapFunction<LineWithTimestamp, Event> linesToEvents = new FlatMapFunction<LineWithTimestamp, Event>(){

            public Iterator<Event> call(LineWithTimestamp lineWithTimestamp) {
                ArrayList<Event> eventList = new ArrayList<Event>();
                for (String word : lineWithTimestamp.getLine().split(" ")) {
                    eventList.add(new Event(word, lineWithTimestamp.getTimestamp()));
                }
                return eventList.iterator();
            }
        };
        Dataset events = lines.withColumnRenamed("value", "line").as(Encoders.bean(LineWithTimestamp.class)).flatMap((FlatMapFunction)linesToEvents, Encoders.bean(Event.class));
        MapGroupsWithStateFunction<String, Event, SessionInfo, SessionUpdate> stateUpdateFunc = new MapGroupsWithStateFunction<String, Event, SessionInfo, SessionUpdate>(){

            public SessionUpdate call(String sessionId, Iterator<Event> events, GroupState<SessionInfo> state) {
                if (state.hasTimedOut()) {
                    SessionUpdate finalUpdate = new SessionUpdate(sessionId, ((SessionInfo)state.get()).calculateDuration(), ((SessionInfo)state.get()).getNumEvents(), true);
                    state.remove();
                    return finalUpdate;
                }
                long maxTimestampMs = Long.MIN_VALUE;
                long minTimestampMs = Long.MAX_VALUE;
                int numNewEvents = 0;
                while (events.hasNext()) {
                    Event e = events.next();
                    long timestampMs = e.getTimestamp().getTime();
                    maxTimestampMs = Math.max(timestampMs, maxTimestampMs);
                    minTimestampMs = Math.min(timestampMs, minTimestampMs);
                    ++numNewEvents;
                }
                SessionInfo updatedSession = new SessionInfo();
                if (state.exists()) {
                    SessionInfo oldSession = (SessionInfo)state.get();
                    updatedSession.setNumEvents(oldSession.numEvents + numNewEvents);
                    updatedSession.setStartTimestampMs(oldSession.startTimestampMs);
                    updatedSession.setEndTimestampMs(Math.max(oldSession.endTimestampMs, maxTimestampMs));
                } else {
                    updatedSession.setNumEvents(numNewEvents);
                    updatedSession.setStartTimestampMs(minTimestampMs);
                    updatedSession.setEndTimestampMs(maxTimestampMs);
                }
                state.update((Object)updatedSession);
                state.setTimeoutDuration("10 seconds");
                return new SessionUpdate(sessionId, ((SessionInfo)state.get()).calculateDuration(), ((SessionInfo)state.get()).getNumEvents(), false);
            }
        };
        Dataset sessionUpdates = events.groupByKey((MapFunction)new MapFunction<Event, String>(){

            public String call(Event event) {
                return event.getSessionId();
            }
        }, Encoders.STRING()).mapGroupsWithState((MapGroupsWithStateFunction)stateUpdateFunc, Encoders.bean(SessionInfo.class), Encoders.bean(SessionUpdate.class), GroupStateTimeout.ProcessingTimeTimeout());
        StreamingQuery query = sessionUpdates.writeStream().outputMode("update").format("console").start();
        query.awaitTermination();
    }

    public static class SessionUpdate
    implements Serializable {
        private String id;
        private long durationMs;
        private int numEvents;
        private boolean expired;

        public SessionUpdate() {
        }

        public SessionUpdate(String id, long durationMs, int numEvents, boolean expired) {
            this.id = id;
            this.durationMs = durationMs;
            this.numEvents = numEvents;
            this.expired = expired;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public long getDurationMs() {
            return this.durationMs;
        }

        public void setDurationMs(long durationMs) {
            this.durationMs = durationMs;
        }

        public int getNumEvents() {
            return this.numEvents;
        }

        public void setNumEvents(int numEvents) {
            this.numEvents = numEvents;
        }

        public boolean isExpired() {
            return this.expired;
        }

        public void setExpired(boolean expired) {
            this.expired = expired;
        }
    }

    public static class SessionInfo
    implements Serializable {
        private int numEvents = 0;
        private long startTimestampMs = -1L;
        private long endTimestampMs = -1L;

        public int getNumEvents() {
            return this.numEvents;
        }

        public void setNumEvents(int numEvents) {
            this.numEvents = numEvents;
        }

        public long getStartTimestampMs() {
            return this.startTimestampMs;
        }

        public void setStartTimestampMs(long startTimestampMs) {
            this.startTimestampMs = startTimestampMs;
        }

        public long getEndTimestampMs() {
            return this.endTimestampMs;
        }

        public void setEndTimestampMs(long endTimestampMs) {
            this.endTimestampMs = endTimestampMs;
        }

        public long calculateDuration() {
            return this.endTimestampMs - this.startTimestampMs;
        }

        public String toString() {
            return "SessionInfo(numEvents = " + this.numEvents + ", timestamps = " + this.startTimestampMs + " to " + this.endTimestampMs + ")";
        }
    }

    public static class Event
    implements Serializable {
        private String sessionId;
        private Timestamp timestamp;

        public Event() {
        }

        public Event(String sessionId, Timestamp timestamp) {
            this.sessionId = sessionId;
            this.timestamp = timestamp;
        }

        public Timestamp getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Timestamp timestamp) {
            this.timestamp = timestamp;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }
    }

    public static class LineWithTimestamp
    implements Serializable {
        private String line;
        private Timestamp timestamp;

        public Timestamp getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Timestamp timestamp) {
            this.timestamp = timestamp;
        }

        public String getLine() {
            return this.line;
        }

        public void setLine(String sessionId) {
            this.line = sessionId;
        }
    }
}

