/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.classification.SVMModel;
import org.apache.spark.mllib.classification.SVMModel$;
import org.apache.spark.mllib.classification.SVMWithSGD$;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class SVMWithSGDExample$ {
    public static final SVMWithSGDExample$ MODULE$;

    static {
        new SVMWithSGDExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("SVMWithSGDExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = MLUtils$.MODULE$.loadLibSVMFile(sc, "data/mllib/sample_libsvm_data.txt");
        RDD[] splits = data.randomSplit(new double[]{0.6, 0.4}, 11L);
        RDD training = splits[0].cache();
        RDD test = splits[1];
        int numIterations = 100;
        SVMModel model = SVMWithSGD$.MODULE$.train(training, numIterations);
        model.clearThreshold();
        RDD scoreAndLabels = test.map((Function1)new Serializable(model){
            public static final long serialVersionUID = 0L;
            private final SVMModel model$1;

            public final Tuple2<Object, Object> apply(LabeledPoint point) {
                double score = this.model$1.predict(point.features());
                return new Tuple2.mcDD.sp(score, point.label());
            }
            {
                this.model$1 = model$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(scoreAndLabels);
        double auROC = metrics.areaUnderROC();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Area under ROC = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)auROC)})));
        model.save(sc, "target/tmp/scalaSVMWithSGDModel");
        SVMModel sameModel = SVMModel$.MODULE$.load(sc, "target/tmp/scalaSVMWithSGDModel");
        sc.stop();
    }

    private SVMWithSGDExample$() {
        MODULE$ = this;
    }
}

