/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.examples.mllib.LatentDirichletAllocationExample$;
import org.apache.spark.mllib.clustering.DistributedLDAModel;
import org.apache.spark.mllib.clustering.DistributedLDAModel$;
import org.apache.spark.mllib.clustering.LDA;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class LatentDirichletAllocationExample$ {
    public static final LatentDirichletAllocationExample$ MODULE$;

    static {
        new LatentDirichletAllocationExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("LatentDirichletAllocationExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = sc.textFile("data/mllib/sample_lda_data.txt", sc.textFile$default$2());
        RDD parsedData = data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Vector apply(String s) {
                return Vectors$.MODULE$.dense((double[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(s.trim())).split(' ')).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(String x$1) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toDouble();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            }
        }, ClassTag$.MODULE$.apply(Vector.class));
        RDD corpus = parsedData.zipWithIndex().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Vector> apply(Tuple2<Vector, Object> x$2) {
                return x$2.swap();
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).cache();
        LDAModel ldaModel = new LDA().setK(3).run(corpus);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Learned topics (as distributions over vocab of ", " words):"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)ldaModel.vocabSize())})));
        Matrix topics = ldaModel.topicsMatrix();
        package$.MODULE$.Range().apply(0, 3).foreach$mVc$sp((Function1)new Serializable(ldaModel, topics){
            public static final long serialVersionUID = 0L;
            private final LDAModel ldaModel$1;
            public final Matrix topics$1;

            public final void apply(int topic) {
                this.apply$mcVI$sp(topic);
            }

            public void apply$mcVI$sp(int topic) {
                Predef$.MODULE$.print((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic ", " :"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)topic)})));
                package$.MODULE$.Range().apply(0, this.ldaModel$1.vocabSize()).foreach$mVc$sp((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.main.1 $outer;
                    private final int topic$1;

                    public final void apply(int word) {
                        this.apply$mcVI$sp(word);
                    }

                    public void apply$mcVI$sp(int word) {
                        Predef$.MODULE$.print((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.topics$1.apply(word, this.topic$1))})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.topic$1 = topic$1;
                    }
                });
                Predef$.MODULE$.println();
            }
            {
                this.ldaModel$1 = ldaModel$1;
                this.topics$1 = topics$1;
            }
        });
        ldaModel.save(sc, "target/org/apache/spark/LatentDirichletAllocationExample/LDAModel");
        DistributedLDAModel sameModel = DistributedLDAModel$.MODULE$.load(sc, "target/org/apache/spark/LatentDirichletAllocationExample/LDAModel");
        sc.stop();
    }

    private LatentDirichletAllocationExample$() {
        MODULE$ = this;
    }
}

