/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.GradientBoostedTrees$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy$;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class GradientBoostingRegressionExample$ {
    public static final GradientBoostingRegressionExample$ MODULE$;

    static {
        new GradientBoostingRegressionExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("GradientBoostedTreesRegressionExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = MLUtils$.MODULE$.loadLibSVMFile(sc, "data/mllib/sample_libsvm_data.txt");
        RDD[] splits = data.randomSplit(new double[]{0.7, 0.3}, data.randomSplit$default$2());
        Tuple2 tuple2 = new Tuple2((Object)splits[0], (Object)splits[1]);
        if (tuple2 != null) {
            Tuple2 tuple22;
            RDD trainingData = (RDD)tuple2._1();
            RDD testData = (RDD)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)trainingData, (Object)testData);
            RDD trainingData2 = (RDD)tuple23._1();
            RDD testData2 = (RDD)tuple23._2();
            BoostingStrategy boostingStrategy = BoostingStrategy$.MODULE$.defaultParams("Regression");
            boostingStrategy.numIterations_$eq(3);
            boostingStrategy.treeStrategy().maxDepth_$eq(5);
            boostingStrategy.treeStrategy().categoricalFeaturesInfo_$eq((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
            GradientBoostedTreesModel model = GradientBoostedTrees$.MODULE$.train(trainingData2, boostingStrategy);
            RDD labelsAndPredictions = testData2.map((Function1)new Serializable(model){
                public static final long serialVersionUID = 0L;
                private final GradientBoostedTreesModel model$1;

                public final Tuple2<Object, Object> apply(LabeledPoint point) {
                    double prediction = this.model$1.predict(point.features());
                    return new Tuple2.mcDD.sp(point.label(), prediction);
                }
                {
                    this.model$1 = model$1;
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            double testMSE = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(labelsAndPredictions.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<Object, Object> x0$1) {
                    Tuple2<Object, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        double v = tuple2._1$mcD$sp();
                        double p = tuple2._2$mcD$sp();
                        double d = package$.MODULE$.pow(v - p, 2.0);
                        return d;
                    }
                    throw new MatchError(tuple2);
                }
            }, ClassTag$.MODULE$.Double())).mean();
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Test Mean Squared Error = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)testMSE)})));
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Learned regression GBT model:\\n ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{model.toDebugString()})));
            model.save(sc, "target/tmp/myGradientBoostingRegressionModel");
            GradientBoostedTreesModel sameModel = GradientBoostedTreesModel$.MODULE$.load(sc, "target/tmp/myGradientBoostingRegressionModel");
            sc.stop();
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private GradientBoostingRegressionExample$() {
        MODULE$ = this;
    }
}

