/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummary;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class MulticlassLogisticRegressionWithElasticNetExample$ {
    public static final MulticlassLogisticRegressionWithElasticNetExample$ MODULE$;

    static {
        new MulticlassLogisticRegressionWithElasticNetExample$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("MulticlassLogisticRegressionWithElasticNetExample").getOrCreate();
        Dataset training = spark.read().format("libsvm").load("data/mllib/sample_multiclass_classification_data.txt");
        LogisticRegression lr = new LogisticRegression().setMaxIter(10).setRegParam(0.3).setElasticNetParam(0.8);
        LogisticRegressionModel lrModel = (LogisticRegressionModel)lr.fit(training);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Coefficients: \\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{lrModel.coefficientMatrix()})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Intercepts: \\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{lrModel.interceptVector()})));
        LogisticRegressionTrainingSummary trainingSummary = lrModel.summary();
        double[] objectiveHistory = trainingSummary.objectiveHistory();
        Predef$.MODULE$.println((Object)"objectiveHistory:");
        Predef$.MODULE$.doubleArrayOps(objectiveHistory).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Object x) {
                Predef$.MODULE$.println(x);
            }
        });
        Predef$.MODULE$.println((Object)"False positive rate by label:");
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(trainingSummary.falsePositiveRateByLabel()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    double rate = tuple2._1$mcD$sp();
                    int label = tuple2._2$mcI$sp();
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)label), BoxesRunTime.boxToDouble((double)rate)})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        Predef$.MODULE$.println((Object)"True positive rate by label:");
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(trainingSummary.truePositiveRateByLabel()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Object, Object> x0$2) {
                Tuple2<Object, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    double rate = tuple2._1$mcD$sp();
                    int label = tuple2._2$mcI$sp();
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)label), BoxesRunTime.boxToDouble((double)rate)})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        Predef$.MODULE$.println((Object)"Precision by label:");
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(trainingSummary.precisionByLabel()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Object, Object> x0$3) {
                Tuple2<Object, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    double prec = tuple2._1$mcD$sp();
                    int label = tuple2._2$mcI$sp();
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)label), BoxesRunTime.boxToDouble((double)prec)})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        Predef$.MODULE$.println((Object)"Recall by label:");
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(trainingSummary.recallByLabel()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Object, Object> x0$4) {
                Tuple2<Object, Object> tuple2 = x0$4;
                if (tuple2 != null) {
                    double rec = tuple2._1$mcD$sp();
                    int label = tuple2._2$mcI$sp();
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)label), BoxesRunTime.boxToDouble((double)rec)})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        Predef$.MODULE$.println((Object)"F-measure by label:");
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(trainingSummary.fMeasureByLabel()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Object, Object> x0$5) {
                Tuple2<Object, Object> tuple2 = x0$5;
                if (tuple2 != null) {
                    double f = tuple2._1$mcD$sp();
                    int label = tuple2._2$mcI$sp();
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)label), BoxesRunTime.boxToDouble((double)f)})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        double accuracy = trainingSummary.accuracy();
        double falsePositiveRate = trainingSummary.weightedFalsePositiveRate();
        double truePositiveRate = trainingSummary.weightedTruePositiveRate();
        double fMeasure = trainingSummary.weightedFMeasure();
        double precision = trainingSummary.weightedPrecision();
        double recall = trainingSummary.weightedRecall();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Accuracy: ", "\\nFPR: ", "\\nTPR: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)accuracy), BoxesRunTime.boxToDouble((double)falsePositiveRate), BoxesRunTime.boxToDouble((double)truePositiveRate)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"F-measure: ", "\\nPrecision: ", "\\nRecall: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)fMeasure), BoxesRunTime.boxToDouble((double)precision), BoxesRunTime.boxToDouble((double)recall)}))).toString());
        spark.stop();
    }

    private MulticlassLogisticRegressionWithElasticNetExample$() {
        MODULE$ = this;
    }
}

