/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import breeze.generic.UFunc;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import breeze.linalg.squaredDistance$;
import java.util.Random;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

public final class LocalKMeans$ {
    public static final LocalKMeans$ MODULE$;
    private final int N;
    private final int R;
    private final int D;
    private final int K;
    private final double convergeDist;
    private final Random rand;

    static {
        new LocalKMeans$();
    }

    public int N() {
        return this.N;
    }

    public int R() {
        return this.R;
    }

    public int D() {
        return this.D;
    }

    public int K() {
        return this.K;
    }

    public double convergeDist() {
        return this.convergeDist;
    }

    public Random rand() {
        return this.rand;
    }

    public DenseVector<Object>[] generateData() {
        return (DenseVector[])Array$.MODULE$.tabulate(this.N(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DenseVector<Object> apply(int i) {
                return LocalKMeans$.MODULE$.org$apache$spark$examples$LocalKMeans$$generatePoint$1(i);
            }
        }, ClassTag$.MODULE$.apply(DenseVector.class));
    }

    public int closestPoint(Vector<Object> p, HashMap<Object, Vector<Object>> centers) {
        IntRef bestIndex = IntRef.create((int)0);
        DoubleRef closest = DoubleRef.create((double)Double.POSITIVE_INFINITY);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), centers.size()).foreach$mVc$sp((Function1)new Serializable(p, centers, bestIndex, closest){
            public static final long serialVersionUID = 0L;
            private final Vector p$1;
            private final HashMap centers$1;
            private final IntRef bestIndex$1;
            private final DoubleRef closest$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Vector vCurr = (Vector)this.centers$1.apply((Object)BoxesRunTime.boxToInteger((int)i));
                double tempDist = BoxesRunTime.unboxToDouble((Object)squaredDistance$.MODULE$.apply((Object)this.p$1, (Object)vCurr, squaredDistance$.MODULE$.squaredDistanceFromZippedValues((UFunc.UImpl2)Vector$.MODULE$.zipValuesImpl_V_V_Double())));
                if (tempDist < this.closest$1.elem) {
                    this.closest$1.elem = tempDist;
                    this.bestIndex$1.elem = i;
                }
            }
            {
                this.p$1 = p$1;
                this.centers$1 = centers$1;
                this.bestIndex$1 = bestIndex$1;
                this.closest$1 = closest$1;
            }
        });
        return bestIndex.elem;
    }

    public void showWarning() {
        System.err.println(new StringOps(Predef$.MODULE$.augmentString("WARN: This is a naive implementation of KMeans Clustering and is given as an example!\n        |Please use org.apache.spark.ml.clustering.KMeans\n        |for more conventional use.\n      ")).stripMargin());
    }

    public void main(String[] args) {
        this.showWarning();
        DenseVector<Object>[] data = this.generateData();
        HashSet points = new HashSet();
        HashMap kPoints = new HashMap();
        DoubleRef tempDist = DoubleRef.create((double)1.0);
        while (points.size() < this.K()) {
            points.add(data[this.rand().nextInt(this.N())]);
        }
        Iterator iter = points.iterator();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), points.size()).foreach((Function1)new Serializable(kPoints, iter){
            public static final long serialVersionUID = 0L;
            private final HashMap kPoints$1;
            private final Iterator iter$1;

            public final Option<Vector<Object>> apply(int i) {
                return this.kPoints$1.put((Object)BoxesRunTime.boxToInteger((int)i), this.iter$1.next());
            }
            {
                this.kPoints$1 = kPoints$1;
                this.iter$1 = iter$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initial centers: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{kPoints})));
        while (tempDist.elem > this.convergeDist()) {
            Tuple2[] closest = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])data).map((Function1)new Serializable(kPoints){
                public static final long serialVersionUID = 0L;
                private final HashMap kPoints$1;

                public final Tuple2<Object, Tuple2<DenseVector<Object>, Object>> apply(DenseVector<Object> p) {
                    return new Tuple2((Object)BoxesRunTime.boxToInteger((int)LocalKMeans$.MODULE$.closestPoint((Vector<Object>)p, (HashMap<Object, Vector<Object>>)this.kPoints$1)), (Object)new Tuple2(p, (Object)BoxesRunTime.boxToInteger((int)1)));
                }
                {
                    this.kPoints$1 = kPoints$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            Map mappings = Predef$.MODULE$.refArrayOps((Object[])closest).groupBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<Object, Tuple2<DenseVector<Object>, Object>> x) {
                    return x._1$mcI$sp();
                }
            });
            Map pointStats = (Map)mappings.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Tuple2<Vector<Object>, Object>> apply(Tuple2<Object, Tuple2<Object, Tuple2<DenseVector<Object>, Object>>[]> pair) {
                    return (Tuple2)Predef$.MODULE$.refArrayOps((Object[])pair._2()).reduceLeft((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, Tuple2<Vector<Object>, Object>> apply(Tuple2<Object, Tuple2<Vector<Object>, Object>> x0$1, Tuple2<Object, Tuple2<DenseVector<Object>, Object>> x1$1) {
                            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                            if (tuple2 != null) {
                                Tuple2 tuple22 = (Tuple2)tuple2._1();
                                Tuple2 tuple23 = (Tuple2)tuple2._2();
                                if (tuple22 != null) {
                                    int id1 = tuple22._1$mcI$sp();
                                    Tuple2 tuple24 = (Tuple2)tuple22._2();
                                    if (tuple24 != null) {
                                        Tuple2 tuple25;
                                        Vector p1 = (Vector)tuple24._1();
                                        int c1 = tuple24._2$mcI$sp();
                                        if (tuple23 != null && (tuple25 = (Tuple2)tuple23._2()) != null) {
                                            DenseVector p2 = (DenseVector)tuple25._1();
                                            int c2 = tuple25._2$mcI$sp();
                                            Tuple2 tuple26 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)id1), (Object)new Tuple2(p1.$plus((Object)p2, Vector$.MODULE$.castOps(Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpAdd())), (Object)BoxesRunTime.boxToInteger((int)(c1 + c2))));
                                            return tuple26;
                                        }
                                    }
                                }
                            }
                            throw new MatchError((Object)tuple2);
                        }
                    });
                }
            }, Map$.MODULE$.canBuildFrom());
            Map newPoints = (Map)pointStats.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Vector<Object>> apply(Tuple2<Object, Tuple2<Vector<Object>, Object>> mapping) {
                    return new Tuple2((Object)BoxesRunTime.boxToInteger((int)mapping._1$mcI$sp()), ((ImmutableNumericOps)((Tuple2)mapping._2())._1()).$times((Object)BoxesRunTime.boxToDouble((double)(1.0 / (double)((Tuple2)mapping._2())._2$mcI$sp())), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpMulMatrix()));
                }
            }, Map$.MODULE$.canBuildFrom());
            tempDist.elem = 0.0;
            newPoints.foreach((Function1)new Serializable(kPoints, tempDist){
                public static final long serialVersionUID = 0L;
                private final HashMap kPoints$1;
                private final DoubleRef tempDist$1;

                public final void apply(Tuple2<Object, Vector<Object>> mapping) {
                    this.tempDist$1.elem += BoxesRunTime.unboxToDouble((Object)squaredDistance$.MODULE$.apply(this.kPoints$1.apply((Object)BoxesRunTime.boxToInteger((int)mapping._1$mcI$sp())), mapping._2(), squaredDistance$.MODULE$.squaredDistanceFromZippedValues((UFunc.UImpl2)Vector$.MODULE$.zipValuesImpl_V_V_Double())));
                }
                {
                    this.kPoints$1 = kPoints$1;
                    this.tempDist$1 = tempDist$1;
                }
            });
            newPoints.foreach((Function1)new Serializable(kPoints){
                public static final long serialVersionUID = 0L;
                private final HashMap kPoints$1;

                public final Option<Vector<Object>> apply(Tuple2<Object, Vector<Object>> newP) {
                    return this.kPoints$1.put((Object)BoxesRunTime.boxToInteger((int)newP._1$mcI$sp()), newP._2());
                }
                {
                    this.kPoints$1 = kPoints$1;
                }
            });
        }
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Final centers: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{kPoints})));
    }

    public final DenseVector org$apache$spark$examples$LocalKMeans$$generatePoint$1(int i) {
        return (DenseVector)DenseVector$.MODULE$.fill(this.D(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return LocalKMeans$.MODULE$.rand().nextDouble() * (double)LocalKMeans$.MODULE$.R();
            }
        }, ClassTag$.MODULE$.Double());
    }

    private LocalKMeans$() {
        MODULE$ = this;
        this.N = 1000;
        this.R = 1000;
        this.D = 10;
        this.K = 10;
        this.convergeDist = 0.001;
        this.rand = new Random(42L);
    }
}

