/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Subtract$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns `expr1`-`expr2`.", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 1;\n       1\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\u0001\u0003\u0001>\u0011\u0001bU;ciJ\f7\r\u001e\u0006\u0003\u0007\u0011\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QAB\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\u000b\u001b!\t\t\"#D\u0001\u0003\u0013\t\u0019\"A\u0001\tCS:\f'/_!sSRDW.\u001a;jGB\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t9\u0001K]8ek\u000e$\bCA\u000b\u001c\u0013\tabC\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u001f\u0001\tU\r\u0011\"\u0001 \u0003\u0011aWM\u001a;\u0016\u0003\u0001\u0002\"!E\u0011\n\u0005\t\u0012!AC#yaJ,7o]5p]\"AA\u0005\u0001B\tB\u0003%\u0001%A\u0003mK\u001a$\b\u0005\u0003\u0005'\u0001\tU\r\u0011\"\u0001 \u0003\u0015\u0011\u0018n\u001a5u\u0011!A\u0003A!E!\u0002\u0013\u0001\u0013A\u0002:jO\"$\b\u0005C\u0003+\u0001\u0011\u00051&\u0001\u0004=S:LGO\u0010\u000b\u0004Y5r\u0003CA\t\u0001\u0011\u0015q\u0012\u00061\u0001!\u0011\u00151\u0013\u00061\u0001!\u0011\u0015\u0001\u0004\u0001\"\u00112\u0003%Ig\u000e];u)f\u0004X-F\u00013!\t\u0019d'D\u00015\u0015\t)d!A\u0003usB,7/\u0003\u00028i\t\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/\u001a\u0005\u0006s\u0001!\tEO\u0001\u0007gfl'm\u001c7\u0016\u0003m\u0002\"\u0001P \u000f\u0005Ui\u0014B\u0001 \u0017\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001)\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005y2\u0002\"B\"\u0001\t\u0003R\u0014!\u00043fG&l\u0017\r\\'fi\"|G\rC\u0003F\u0001\u0011\u0005#(\u0001\fdC2,g\u000eZ1s\u0013:$XM\u001d<bY6+G\u000f[8e\u0011!9\u0005\u0001#b\u0001\n\u0013A\u0015a\u00028v[\u0016\u0014\u0018nY\u000b\u0002\u0013B\u0019!JU+\u000f\u0005-\u0003fB\u0001'P\u001b\u0005i%B\u0001(\u000f\u0003\u0019a$o\\8u}%\tq#\u0003\u0002R-\u00059\u0001/Y2lC\u001e,\u0017BA*U\u0005\u001dqU/\\3sS\u000eT!!\u0015\f\u0011\u0005U1\u0016BA,\u0017\u0005\r\te.\u001f\u0005\t3\u0002A\t\u0011)Q\u0005\u0013\u0006Aa.^7fe&\u001c\u0007\u0005C\u0003\\\u0001\u0011EC,\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002V;~CQA\u0018.A\u0002U\u000ba!\u001b8qkR\f\u0004\"\u00021[\u0001\u0004)\u0016AB5oaV$(\u0007C\u0004c\u0001\u0005\u0005I\u0011A2\u0002\t\r|\u0007/\u001f\u000b\u0004Y\u0011,\u0007b\u0002\u0010b!\u0003\u0005\r\u0001\t\u0005\bM\u0005\u0004\n\u00111\u0001!\u0011\u001d9\u0007!%A\u0005\u0002!\fabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001jU\t\u0001#nK\u0001l!\ta\u0017/D\u0001n\u0015\tqw.A\u0005v]\u000eDWmY6fI*\u0011\u0001OF\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001:n\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\bi\u0002\t\n\u0011\"\u0001i\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIBqA\u001e\u0001\u0002\u0002\u0013\u0005s/A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002qB\u0011\u0011P`\u0007\u0002u*\u00111\u0010`\u0001\u0005Y\u0006twMC\u0001~\u0003\u0011Q\u0017M^1\n\u0005\u0001S\b\"CA\u0001\u0001\u0005\u0005I\u0011AA\u0002\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t)\u0001E\u0002\u0016\u0003\u000fI1!!\u0003\u0017\u0005\rIe\u000e\u001e\u0005\n\u0003\u001b\u0001\u0011\u0011!C\u0001\u0003\u001f\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002V\u0003#A!\"a\u0005\u0002\f\u0005\u0005\t\u0019AA\u0003\u0003\rAH%\r\u0005\n\u0003/\u0001\u0011\u0011!C!\u00033\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u00037\u0001R!!\b\u0002$Uk!!a\b\u000b\u0007\u0005\u0005b#\u0001\u0006d_2dWm\u0019;j_:LA!!\n\u0002 \tA\u0011\n^3sCR|'\u000fC\u0005\u0002*\u0001\t\t\u0011\"\u0001\u0002,\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002.\u0005M\u0002cA\u000b\u00020%\u0019\u0011\u0011\u0007\f\u0003\u000f\t{w\u000e\\3b]\"I\u00111CA\u0014\u0003\u0003\u0005\r!\u0016\u0005\n\u0003o\u0001\u0011\u0011!C!\u0003s\ta!Z9vC2\u001cH\u0003BA\u0017\u0003wA\u0011\"a\u0005\u00026\u0005\u0005\t\u0019A+)\u0017\u0001\ty$!\u0012\u0002H\u0005-\u0013Q\n\t\u0004#\u0005\u0005\u0013bAA\"\u0005\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA%\u00035*\u0007\u0010\u001d:2A}3UKT\"`A\u0015D\bO\u001d\u001a![\u0001\u0012V\r^;s]N\u0004\u0003-\u001a=qeF\u0002W\u0006Y3yaJ\u0014\u0004ML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qJ\u00016\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\u0012\u0004e\u0018$V\u001d\u000e{\u0006%M\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!c)\u0001\u0003eB\u0005\u0002T\t\t\t\u0011#\u0001\u0002V\u0005A1+\u001e2ue\u0006\u001cG\u000fE\u0002\u0012\u0003/2\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011\u0011L\n\u0006\u0003/\nYF\u0007\t\b\u0003;\n\u0019\u0007\t\u0011-\u001b\t\tyFC\u0002\u0002bY\tqA];oi&lW-\u0003\u0003\u0002f\u0005}#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oe!9!&a\u0016\u0005\u0002\u0005%DCAA+\u0011)\ti'a\u0016\u0002\u0002\u0013\u0015\u0013qN\u0001\ti>\u001cFO]5oOR\t\u0001\u0010\u0003\u0006\u0002t\u0005]\u0013\u0011!CA\u0003k\nQ!\u00199qYf$R\u0001LA<\u0003sBaAHA9\u0001\u0004\u0001\u0003B\u0002\u0014\u0002r\u0001\u0007\u0001\u0005\u0003\u0006\u0002~\u0005]\u0013\u0011!CA\u0003\u007f\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u0002\u00065\u0005#B\u000b\u0002\u0004\u0006\u001d\u0015bAAC-\t1q\n\u001d;j_:\u0004R!FAEA\u0001J1!a#\u0017\u0005\u0019!V\u000f\u001d7fe!I\u0011qRA>\u0003\u0003\u0005\r\u0001L\u0001\u0004q\u0012\u0002\u0004BCAJ\u0003/\n\t\u0011\"\u0003\u0002\u0016\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t9\nE\u0002z\u00033K1!a'{\u0005\u0019y%M[3di\u0002")
public class Subtract
extends BinaryArithmetic
implements Serializable {
    private final Expression left;
    private final Expression right;
    private Numeric<Object> numeric;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(Subtract subtract) {
        return Subtract$.MODULE$.unapply(subtract);
    }

    public static Function1<Tuple2<Expression, Expression>, Subtract> tupled() {
        return Subtract$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Subtract>> curried() {
        return Subtract$.MODULE$.curried();
    }

    private Numeric numeric$lzycompute() {
        Subtract subtract = this;
        synchronized (subtract) {
            if (!this.bitmap$0) {
                this.numeric = TypeUtils$.MODULE$.getNumeric(this.dataType());
                this.bitmap$0 = true;
            }
            return this.numeric;
        }
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public AbstractDataType inputType() {
        return TypeCollection$.MODULE$.NumericAndInterval();
    }

    @Override
    public String symbol() {
        return "-";
    }

    @Override
    public String decimalMethod() {
        return "$minus";
    }

    @Override
    public String calendarIntervalMethod() {
        return "subtract";
    }

    private Numeric<Object> numeric() {
        return this.bitmap$0 ? this.numeric : this.numeric$lzycompute();
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return this.dataType() instanceof CalendarIntervalType ? ((CalendarInterval)input1).subtract((CalendarInterval)input2) : this.numeric().minus(input1, input2);
    }

    public Subtract copy(Expression left, Expression right) {
        return new Subtract(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Subtract";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Subtract;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Subtract)) return false;
        boolean bl = true;
        if (!bl) return false;
        Subtract subtract = (Subtract)x$1;
        Expression expression = this.left();
        Expression expression2 = subtract.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = subtract.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!subtract.canEqual(this)) return false;
        return true;
    }

    public Subtract(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

