/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FromUnixTime$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression$class;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ExpressionDescription(usage="_FUNC_(unix_time, format) - Returns `unix_time` in the specified `format`.", arguments="\n    Arguments:\n      * unix_time - UNIX Timestamp to be converted to the provided format.\n      * format - Date/time format pattern to follow. See `java.text.SimpleDateFormat`\n                 for valid date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(0, 'yyyy-MM-dd HH:mm:ss');\n       1970-01-01 00:00:00\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\t%c\u0001B\u0001\u0003\u0001>\u0011AB\u0012:p[Vs\u0017\u000e\u001f+j[\u0016T!a\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000b\u0019\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0007\u0001A!rC\u0007\u0011\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t\tR#\u0003\u0002\u0017\u0005\t9B+[7f5>tW-Q<be\u0016,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003#aI!!\u0007\u0002\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u001cC%\u0011!\u0005\b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tI\u0001\u0011)\u001a!C\u0001K\u0005\u00191/Z2\u0016\u0003\u0019\u0002\"!E\u0014\n\u0005!\u0012!AC#yaJ,7o]5p]\"A!\u0006\u0001B\tB\u0003%a%\u0001\u0003tK\u000e\u0004\u0003\u0002\u0003\u0017\u0001\u0005+\u0007I\u0011A\u0013\u0002\r\u0019|'/\\1u\u0011!q\u0003A!E!\u0002\u00131\u0013a\u00024pe6\fG\u000f\t\u0005\ta\u0001\u0011)\u001a!C\u0001c\u0005QA/[7f5>tW-\u00133\u0016\u0003I\u00022aG\u001a6\u0013\t!DD\u0001\u0004PaRLwN\u001c\t\u0003mer!aG\u001c\n\u0005ab\u0012A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001\u000f\u000f\t\u0011u\u0002!\u0011#Q\u0001\nI\n1\u0002^5nKj{g.Z%eA!)q\b\u0001C\u0001\u0001\u00061A(\u001b8jiz\"B!\u0011\"D\tB\u0011\u0011\u0003\u0001\u0005\u0006Iy\u0002\rA\n\u0005\u0006Yy\u0002\rA\n\u0005\bay\u0002\n\u00111\u00013\u0011\u0015y\u0004\u0001\"\u0001G)\r\tu\t\u0013\u0005\u0006I\u0015\u0003\rA\n\u0005\u0006Y\u0015\u0003\rA\n\u0005\u0006\u0015\u0002!\t%J\u0001\u0005Y\u00164G\u000fC\u0003M\u0001\u0011\u0005S%A\u0003sS\u001eDG\u000fC\u0003O\u0001\u0011\u0005s*\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012!\u000e\u0005\u0006\u007f\u0001!\t!\u0015\u000b\u0003\u0003JCQa\u0015)A\u0002\u0019\nA!\u001e8jq\")Q\u000b\u0001C!-\u0006AA-\u0019;b)f\u0004X-F\u0001X!\tA6,D\u0001Z\u0015\tQf!A\u0003usB,7/\u0003\u0002]3\nAA)\u0019;b)f\u0004X\rC\u0003_\u0001\u0011\u0005s,\u0001\u0005ok2d\u0017M\u00197f+\u0005\u0001\u0007CA\u000eb\u0013\t\u0011GDA\u0004C_>dW-\u00198\t\u000b\u0011\u0004A\u0011I3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001g!\r9wN\u001d\b\u0003Q6t!!\u001b7\u000e\u0003)T!a\u001b\b\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0012B\u00018\u001d\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001]9\u0003\u0007M+\u0017O\u0003\u0002o9A\u0011\u0001l]\u0005\u0003if\u0013\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\t\u000bY\u0004A\u0011I<\u0002\u0019]LG\u000f\u001b+j[\u0016TvN\\3\u0015\u0005QA\b\"\u0002\u0019v\u0001\u0004)\u0004\u0002\u0003>\u0001\u0011\u000b\u0007I\u0011B>\u0002\u0017\r|gn\u001d;G_Jl\u0017\r^\u000b\u0002yB\u0019Q0a\u0001\u000e\u0003yT!AW@\u000b\u0007\u0005\u0005\u0001\"\u0001\u0004v]N\fg-Z\u0005\u0004\u0003\u000bq(AC+U\rb\u001aFO]5oO\"I\u0011\u0011\u0002\u0001\t\u0002\u0003\u0006K\u0001`\u0001\rG>t7\u000f\u001e$pe6\fG\u000f\t\u0005\u000b\u0003\u001b\u0001\u0001R1A\u0005\n\u0005=\u0011!\u00034pe6\fG\u000f^3s+\t\t\t\u0002\u0005\u0003\u0002\u0014\u0005uQBAA\u000b\u0015\u0011\t9\"!\u0007\u0002\tQ,\u0007\u0010\u001e\u0006\u0003\u00037\tAA[1wC&!\u0011qDA\u000b\u0005)!\u0015\r^3G_Jl\u0017\r\u001e\u0005\u000b\u0003G\u0001\u0001\u0012!Q!\n\u0005E\u0011A\u00034pe6\fG\u000f^3sA!9\u0011q\u0005\u0001\u0005B\u0005%\u0012\u0001B3wC2$B!a\u000b\u00022A\u00191$!\f\n\u0007\u0005=BDA\u0002B]fD!\"a\r\u0002&A\u0005\t\u0019AA\u001b\u0003\u0015Ig\u000e];u!\u0011\t9$!\u000f\u000e\u0003\u0011I1!a\u000f\u0005\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000f\u0005}\u0002\u0001\"\u0011\u0002B\u0005IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003\u0007\ny%!\u0017\u0011\t\u0005\u0015\u00131J\u0007\u0003\u0003\u000fR1!!\u0013\u0003\u0003\u001d\u0019w\u000eZ3hK:LA!!\u0014\u0002H\tAQ\t\u001f9s\u0007>$W\r\u0003\u0005\u0002R\u0005u\u0002\u0019AA*\u0003\r\u0019G\u000f\u001f\t\u0005\u0003\u000b\n)&\u0003\u0003\u0002X\u0005\u001d#AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\t\u00037\ni\u00041\u0001\u0002D\u0005\u0011QM\u001e\u0005\n\u0003?\u0002\u0011\u0011!C\u0001\u0003C\nAaY8qsR9\u0011)a\u0019\u0002f\u0005\u001d\u0004\u0002\u0003\u0013\u0002^A\u0005\t\u0019\u0001\u0014\t\u00111\ni\u0006%AA\u0002\u0019B\u0001\u0002MA/!\u0003\u0005\rA\r\u0005\n\u0003W\u0002\u0011\u0013!C\u0001\u0003[\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002p)\u001aa%!\u001d,\u0005\u0005M\u0004\u0003BA;\u0003\u007fj!!a\u001e\u000b\t\u0005e\u00141P\u0001\nk:\u001c\u0007.Z2lK\u0012T1!! \u001d\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0003\u000b9HA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"!\"\u0001#\u0003%\t!!\u001c\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!I\u0011\u0011\u0012\u0001\u0012\u0002\u0013\u0005\u00111R\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tiIK\u00023\u0003cB\u0011\"!%\u0001\u0003\u0003%\t%a%\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\n\u0005\u0003\u0002\u0018\u0006uUBAAM\u0015\u0011\tY*!\u0007\u0002\t1\fgnZ\u0005\u0004u\u0005e\u0005\"CAQ\u0001\u0005\u0005I\u0011AAR\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t)\u000bE\u0002\u001c\u0003OK1!!+\u001d\u0005\rIe\u000e\u001e\u0005\n\u0003[\u0003\u0011\u0011!C\u0001\u0003_\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002,\u0005E\u0006BCAZ\u0003W\u000b\t\u00111\u0001\u0002&\u0006\u0019\u0001\u0010J\u0019\t\u0013\u0005]\u0006!!A\u0005B\u0005e\u0016a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005m\u0006CBA_\u0003\u0007\fY#\u0004\u0002\u0002@*\u0019\u0011\u0011\u0019\u000f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002F\u0006}&\u0001C%uKJ\fGo\u001c:\t\u0013\u0005%\u0007!!A\u0005\u0002\u0005-\u0017\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007\u0001\fi\r\u0003\u0006\u00024\u0006\u001d\u0017\u0011!a\u0001\u0003WA\u0011\"!5\u0001\u0003\u0003%\t%a5\u0002\r\u0015\fX/\u00197t)\r\u0001\u0017Q\u001b\u0005\u000b\u0003g\u000by-!AA\u0002\u0005-\u0002f\u0005\u0001\u0002Z\u0006}\u0017\u0011]As\u0003O\fY/!<\u0002r\u0006M\bcA\t\u0002\\&\u0019\u0011Q\u001c\u0002\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111]\u0001K?\u001a+fjQ0)k:L\u0007p\u0018;j[\u0016d\u0003EZ8s[\u0006$\u0018\u0006I\u0017!%\u0016$XO\u001d8tA\u0001,h.\u001b=`i&lW\r\u0019\u0011j]\u0002\"\b.\u001a\u0011ta\u0016\u001c\u0017NZ5fI\u0002\u0002gm\u001c:nCR\u0004g&A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u0011\u0011^\u0001\u0002\\*\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003%\u001e8jq~#\u0018.\\3![\u0001*f*\u0013-!)&lWm\u001d;b[B\u0004Co\u001c\u0011cK\u0002\u001awN\u001c<feR,G\r\t;pAQDW\r\t9s_ZLG-\u001a3!M>\u0014X.\u0019;/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u00012wN]7bi\u0002j\u0003\u0005R1uK>\"\u0018.\\3!M>\u0014X.\u0019;!a\u0006$H/\u001a:oAQ|\u0007EZ8mY><h\u0006I*fK\u0002\u0002'.\u0019<b]Q,\u0007\u0010\u001e\u0018TS6\u0004H.\u001a#bi\u00164uN]7bi\u0002T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011g_J\u0004c/\u00197jI\u0002\"\u0017\r^3!C:$\u0007\u0005^5nK\u00022wN]7bi\u0002\u0002\u0018\r\u001e;fe:\u001chF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAx\u0003uS\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006\r\u0017!OeL\u00180_\u0017N\u001b6\"G\r\t%Iu5l'h]:(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013'O\u001c1[A\nT\u0006M\u0019!aAR\u0004\u0007\r\u001e1a)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002v\u0006)\u0011GL\u001b/a\u001dI\u0011\u0011 \u0002\u0002\u0002#\u0005\u00111`\u0001\r\rJ|W.\u00168jqRKW.\u001a\t\u0004#\u0005uh\u0001C\u0001\u0003\u0003\u0003E\t!a@\u0014\u000b\u0005u(\u0011\u0001\u0011\u0011\u0011\t\r!\u0011\u0002\u0014'e\u0005k!A!\u0002\u000b\u0007\t\u001dA$A\u0004sk:$\u0018.\\3\n\t\t-!Q\u0001\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004bB \u0002~\u0012\u0005!q\u0002\u000b\u0003\u0003wD!Ba\u0005\u0002~\u0006\u0005IQ\tB\u000b\u0003!!xn\u0015;sS:<GCAAK\u0011)\u0011I\"!@\u0002\u0002\u0013\u0005%1D\u0001\u0006CB\u0004H.\u001f\u000b\b\u0003\nu!q\u0004B\u0011\u0011\u0019!#q\u0003a\u0001M!1AFa\u0006A\u0002\u0019B\u0001\u0002\rB\f!\u0003\u0005\rA\r\u0005\u000b\u0005K\ti0!A\u0005\u0002\n\u001d\u0012aB;oCB\u0004H.\u001f\u000b\u0005\u0005S\u0011\t\u0004\u0005\u0003\u001cg\t-\u0002CB\u000e\u0003.\u00192#'C\u0002\u00030q\u0011a\u0001V;qY\u0016\u001c\u0004\"\u0003B\u001a\u0005G\t\t\u00111\u0001B\u0003\rAH\u0005\r\u0005\u000b\u0005o\ti0%A\u0005\u0002\u0005-\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3\u0007\u0003\u0006\u0003<\u0005u\u0018\u0013!C\u0001\u0003\u0017\u000bq\"\u00199qYf$C-\u001a4bk2$He\r\u0005\u000b\u0005\u007f\ti0!A\u0005\n\t\u0005\u0013a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u0011\u0011\t\u0005]%QI\u0005\u0005\u0005\u000f\nIJ\u0001\u0004PE*,7\r\u001e")
public class FromUnixTime
extends BinaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
Serializable {
    private final Expression sec;
    private final Expression format;
    private final Option<String> timeZoneId;
    private UTF8String constFormat;
    private DateFormat formatter;
    private final boolean resolved;
    private final transient TimeZone timeZone;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<String> apply$default$3() {
        return FromUnixTime$.MODULE$.apply$default$3();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return FromUnixTime$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(FromUnixTime fromUnixTime) {
        return FromUnixTime$.MODULE$.unapply(fromUnixTime);
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, FromUnixTime> tupled() {
        return FromUnixTime$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, FromUnixTime>>> curried() {
        return FromUnixTime$.MODULE$.curried();
    }

    private UTF8String constFormat$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Expression qual$2 = this.right();
                InternalRow x$24 = qual$2.eval$default$1();
                this.constFormat = (UTF8String)qual$2.eval(x$24);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.constFormat;
        }
    }

    private DateFormat formatter$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.formatter = this.liftedTree2$1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.formatter;
        }
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    private boolean resolved$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.resolved = TimeZoneAwareExpression$class.resolved(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.resolved;
        }
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    private TimeZone timeZone$lzycompute() {
        FromUnixTime fromUnixTime = this;
        synchronized (fromUnixTime) {
            if (!this.bitmap$trans$0) {
                this.timeZone = TimeZoneAwareExpression$class.timeZone(this);
                this.bitmap$trans$0 = true;
            }
            return this.timeZone;
        }
    }

    @Override
    public TimeZone timeZone() {
        return this.bitmap$trans$0 ? this.timeZone : this.timeZone$lzycompute();
    }

    public Expression sec() {
        return this.sec;
    }

    public Expression format() {
        return this.format;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression left() {
        return this.sec();
    }

    @Override
    public Expression right() {
        return this.format();
    }

    @Override
    public String prettyName() {
        return "from_unixtime";
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{LongType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$21 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$22 = this.copy$default$1();
        Expression x$23 = this.copy$default$2();
        return this.copy(x$22, x$23, (Option<String>)x$21);
    }

    private UTF8String constFormat() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.constFormat$lzycompute() : this.constFormat;
    }

    private DateFormat formatter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.formatter$lzycompute() : this.formatter;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object eval(InternalRow input) {
        UTF8String uTF8String;
        Object time = this.left().eval(input);
        if (time == null) {
            return null;
        }
        if (this.format().foldable()) {
            if (this.constFormat() == null) return null;
            if (this.formatter() == null) {
                return null;
            }
            uTF8String = UTF8String.fromString((String)this.formatter().format(new Date(BoxesRunTime.unboxToLong((Object)time) * 1000L)));
            return uTF8String;
        }
        Object f = this.format().eval(input);
        if (f == null) {
            return null;
        }
        try {
            uTF8String = UTF8String.fromString((String)DateTimeUtils$.MODULE$.newDateFormat(f.toString(), this.timeZone()).format(new Date(BoxesRunTime.unboxToLong((Object)time) * 1000L)));
            return uTF8String;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) return null;
            throw throwable;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable3);
            if (!option.isEmpty()) return null;
            throw throwable;
        }
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String df = DateFormat.class.getName();
        if (this.format().foldable()) {
            if (this.formatter() == null) {
                exprCode = ExprCode$.MODULE$.forNullValue(StringType$.MODULE$);
            } else {
                String formatterName = ctx.addReferenceObj("formatter", this.formatter(), df);
                ExprCode t = this.left().genCode(ctx);
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            try {\n              ", " = UTF8String.fromString(", ".format(\n                new java.util.Date(", " * 1000L)));\n            } catch (java.lang.IllegalArgumentException e) {\n              ", " = true;\n            }\n          }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.code(), ev.isNull(), t.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), formatterName, t.value(), ev.isNull()})), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            String tz = ctx.addReferenceObj("timeZone", this.timeZone(), ctx.addReferenceObj$default$3());
            String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, ev, tz, dtu){
                public static final long serialVersionUID = 0L;
                private final ExprCode ev$7;
                private final String tz$6;
                private final String dtu$14;

                public final String apply(String seconds, String f) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        try {\n          ", " = UTF8String.fromString(", ".newDateFormat(", ".toString(), ", ").format(\n            new java.util.Date(", " * 1000L)));\n        } catch (java.lang.IllegalArgumentException e) {\n          ", " = true;\n        }"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ev$7.value(), this.dtu$14, f, this.tz$6, seconds, this.ev$7.isNull()}));
                }
                {
                    this.ev$7 = ev$7;
                    this.tz$6 = tz$6;
                    this.dtu$14 = dtu$14;
                }
            });
        }
        return exprCode;
    }

    public FromUnixTime copy(Expression sec, Expression format2, Option<String> timeZoneId) {
        return new FromUnixTime(sec, format2, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.sec();
    }

    public Expression copy$default$2() {
        return this.format();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "FromUnixTime";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            case 1: {
                object = this.format();
                break;
            }
            case 0: {
                object = this.sec();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FromUnixTime;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FromUnixTime)) return false;
        boolean bl = true;
        if (!bl) return false;
        FromUnixTime fromUnixTime = (FromUnixTime)x$1;
        Expression expression = this.sec();
        Expression expression2 = fromUnixTime.sec();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.format();
        Expression expression4 = fromUnixTime.format();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = fromUnixTime.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!fromUnixTime.canEqual(this)) return false;
        return true;
    }

    private final DateFormat liftedTree2$1() {
        DateFormat dateFormat;
        try {
            dateFormat = DateTimeUtils$.MODULE$.newDateFormat(this.constFormat().toString(), this.timeZone());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Object var4_4 = null;
            dateFormat = var4_4;
        }
        return dateFormat;
    }

    public FromUnixTime(Expression sec, Expression format2, Option<String> timeZoneId) {
        this.sec = sec;
        this.format = format2;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression$class.$init$(this);
        ExpectsInputTypes$class.$init$(this);
    }

    public FromUnixTime(Expression sec, Expression format2) {
        this(sec, format2, (Option<String>)None$.MODULE$);
    }

    public FromUnixTime(Expression unix) {
        this(unix, Literal$.MODULE$.apply("yyyy-MM-dd HH:mm:ss"));
    }
}

