/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.EqualTo$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` equals `expr2`, or false otherwise.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be used in equality comparison. Map type is not supported.\n          For complex types such array/struct, the data types of fields must be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 2;\n       true\n      > SELECT 1 _FUNC_ '1';\n       true\n      > SELECT true _FUNC_ NULL;\n       NULL\n      > SELECT NULL _FUNC_ NULL;\n       NULL\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005Ee\u0001B\u0001\u0003\u0001>\u0011q!R9vC2$vN\u0003\u0002\u0004\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)a!\u0001\u0005dCR\fG._:u\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0015\u0001\u0001\u0003F\u000e\"!\t\t\"#D\u0001\u0003\u0013\t\u0019\"A\u0001\tCS:\f'/_\"p[B\f'/[:p]B\u0011Q\u0003\u0007\b\u0003#YI!a\u0006\u0002\u0002\u000fA\f7m[1hK&\u0011\u0011D\u0007\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\t9\"\u0001\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SDA\u0004Qe>$Wo\u0019;\u0011\u0005q\u0011\u0013BA\u0012\u001e\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!)\u0003A!f\u0001\n\u00031\u0013\u0001\u00027fMR,\u0012a\n\t\u0003#!J!!\u000b\u0002\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0003\u0005,\u0001\tE\t\u0015!\u0003(\u0003\u0015aWM\u001a;!\u0011!i\u0003A!f\u0001\n\u00031\u0013!\u0002:jO\"$\b\u0002C\u0018\u0001\u0005#\u0005\u000b\u0011B\u0014\u0002\rILw\r\u001b;!\u0011\u0015\t\u0004\u0001\"\u00013\u0003\u0019a\u0014N\\5u}Q\u00191\u0007N\u001b\u0011\u0005E\u0001\u0001\"B\u00131\u0001\u00049\u0003\"B\u00171\u0001\u00049\u0003\"B\u001c\u0001\t\u0003B\u0014AB:z[\n|G.F\u0001:!\tQTH\u0004\u0002\u001dw%\u0011A(H\u0001\u0007!J,G-\u001a4\n\u0005yz$AB*ue&twM\u0003\u0002=;!)\u0011\t\u0001C)\u0005\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u00191IR$\u0011\u0005q!\u0015BA#\u001e\u0005\r\te.\u001f\u0005\u0006K\u0001\u0003\ra\u0011\u0005\u0006[\u0001\u0003\ra\u0011\u0005\u0006\u0013\u0002!\tES\u0001\nI><UM\\\"pI\u0016$2aS)W!\tau*D\u0001N\u0015\tq%!A\u0004d_\u0012,w-\u001a8\n\u0005Ak%\u0001C#yaJ\u001cu\u000eZ3\t\u000bIC\u0005\u0019A*\u0002\u0007\r$\b\u0010\u0005\u0002M)&\u0011Q+\u0014\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u00159\u0006\n1\u0001L\u0003\t)g\u000fC\u0004Z\u0001\u0005\u0005I\u0011\u0001.\u0002\t\r|\u0007/\u001f\u000b\u0004gmc\u0006bB\u0013Y!\u0003\u0005\ra\n\u0005\b[a\u0003\n\u00111\u0001(\u0011\u001dq\u0006!%A\u0005\u0002}\u000babY8qs\u0012\"WMZ1vYR$\u0013'F\u0001aU\t9\u0013mK\u0001c!\t\u0019\u0007.D\u0001e\u0015\t)g-A\u0005v]\u000eDWmY6fI*\u0011q-H\u0001\u000bC:tw\u000e^1uS>t\u0017BA5e\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\bW\u0002\t\n\u0011\"\u0001`\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIBq!\u001c\u0001\u0002\u0002\u0013\u0005c.A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002_B\u0011\u0001/^\u0007\u0002c*\u0011!o]\u0001\u0005Y\u0006twMC\u0001u\u0003\u0011Q\u0017M^1\n\u0005y\n\bbB<\u0001\u0003\u0003%\t\u0001_\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002sB\u0011AD_\u0005\u0003wv\u00111!\u00138u\u0011\u001di\b!!A\u0005\u0002y\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0002D\u007f\"A\u0011\u0011\u0001?\u0002\u0002\u0003\u0007\u00110A\u0002yIEB\u0011\"!\u0002\u0001\u0003\u0003%\t%a\u0002\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u0003\u0011\u000b\u0005-\u0011\u0011C\"\u000e\u0005\u00055!bAA\b;\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005M\u0011Q\u0002\u0002\t\u0013R,'/\u0019;pe\"I\u0011q\u0003\u0001\u0002\u0002\u0013\u0005\u0011\u0011D\u0001\tG\u0006tW)];bYR!\u00111DA\u0011!\ra\u0012QD\u0005\u0004\u0003?i\"a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u0003\t)\"!AA\u0002\rC\u0011\"!\n\u0001\u0003\u0003%\t%a\n\u0002\r\u0015\fX/\u00197t)\u0011\tY\"!\u000b\t\u0013\u0005\u0005\u00111EA\u0001\u0002\u0004\u0019\u0005f\u0004\u0001\u0002.\u0005M\u0012QGA\u001d\u0003w\ty$!\u0011\u0011\u0007E\ty#C\u0002\u00022\t\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u00028\u0005\u0001V\r\u001f9sc\u0001zf)\u0016(D?\u0002*\u0007\u0010\u001d:3A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e:vK\u0002Jg\r\t1fqB\u0014\u0018\u0007\u0019\u0011fcV\fGn\u001d\u0011aKb\u0004(O\r1-A=\u0014\bEZ1mg\u0016\u0004s\u000e\u001e5fe^L7/\u001a\u0018\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAA\u001f\u0003\tu#\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011fqB\u0014\u0018\u0007\f\u0011fqB\u0014(\u0007I\u0017!i\",\u0007\u0005^<pA\u0015D\bO]3tg&|gn\u001d\u0011nkN$\bEY3!g\u0006lW\r\t;za\u0016\u0004sN\u001d\u0011dC:\u0004#-\u001a\u0011dCN$X\r\u001a\u0011u_\u0002\n\u0007eY8n[>t\u0007\u0005^=qK2R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011b]\u0012\u0004S.^:uA\t,\u0007%\u0019\u0011usB,\u0007\u0005\u001e5bi\u0002\u001a\u0017M\u001c\u0011cK\u0002*8/\u001a3!S:\u0004S-];bY&$\u0018\u0010I2p[B\f'/[:p]:\u0002S*\u00199!if\u0004X\rI5tA9|G\u000fI:vaB|'\u000f^3e])\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t$pe\u0002\u001aw.\u001c9mKb\u0004C/\u001f9fg\u0002\u001aXo\u00195!CJ\u0014\u0018-_\u0018tiJ,8\r\u001e\u0017!i\",\u0007\u0005Z1uC\u0002\"\u0018\u0010]3tA=4\u0007EZ5fY\u0012\u001c\b%\\;ti\u0002\u0012W\rI8sI\u0016\u0014\u0018M\u00197f])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t\u0019%AA<\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\u0012\u0004e\u0018$V\u001d\u000e{\u0006EM\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!iJ,XM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u00112A}3UKT\"`A\u001d\nte\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t;sk\u0016\u0004sLR+O\u0007~\u0003c*\u0016'Mw)\u0001\u0003\u0005\t\u0011!A\u0001rU\u000b\u0014'\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA9+F\n\u0014\u0011`\rVs5i\u0018\u0011O+2c5H\u0003\u0011!A\u0001\u0002\u0003\u0005\t(V\u00192S\u0001\u0005I\u0004\n\u0003\u000f\u0012\u0011\u0011!E\u0001\u0003\u0013\nq!R9vC2$v\u000eE\u0002\u0012\u0003\u00172\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011QJ\n\u0006\u0003\u0017\ny%\t\t\b\u0003#\n9fJ\u00144\u001b\t\t\u0019FC\u0002\u0002Vu\tqA];oi&lW-\u0003\u0003\u0002Z\u0005M#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oe!9\u0011'a\u0013\u0005\u0002\u0005uCCAA%\u0011)\t\t'a\u0013\u0002\u0002\u0013\u0015\u00131M\u0001\ti>\u001cFO]5oOR\tq\u000e\u0003\u0006\u0002h\u0005-\u0013\u0011!CA\u0003S\nQ!\u00199qYf$RaMA6\u0003[Ba!JA3\u0001\u00049\u0003BB\u0017\u0002f\u0001\u0007q\u0005\u0003\u0006\u0002r\u0005-\u0013\u0011!CA\u0003g\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002v\u0005\u0005\u0005#\u0002\u000f\u0002x\u0005m\u0014bAA=;\t1q\n\u001d;j_:\u0004R\u0001HA?O\u001dJ1!a \u001e\u0005\u0019!V\u000f\u001d7fe!I\u00111QA8\u0003\u0003\u0005\raM\u0001\u0004q\u0012\u0002\u0004BCAD\u0003\u0017\n\t\u0011\"\u0003\u0002\n\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tY\tE\u0002q\u0003\u001bK1!a$r\u0005\u0019y%M[3di\u0002")
public class EqualTo
extends BinaryComparison
implements package.NullIntolerant,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(EqualTo equalTo) {
        return EqualTo$.MODULE$.unapply(equalTo);
    }

    public static Function1<Tuple2<Expression, Expression>, EqualTo> tupled() {
        return EqualTo$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, EqualTo>> curried() {
        return EqualTo$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return "=";
    }

    @Override
    public Object nullSafeEval(Object left, Object right) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().equiv(left, right));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, ctx){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EqualTo $outer;
            private final CodegenContext ctx$4;

            public final String apply(String c1, String c2) {
                return this.ctx$4.genEqual(this.$outer.left().dataType(), c1, c2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ctx$4 = ctx$4;
            }
        });
    }

    public EqualTo copy(Expression left, Expression right) {
        return new EqualTo(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "EqualTo";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                expression = this.right();
                break;
            }
            case 0: {
                expression = this.left();
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof EqualTo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof EqualTo)) return false;
        boolean bl = true;
        if (!bl) return false;
        EqualTo equalTo = (EqualTo)x$1;
        Expression expression = this.left();
        Expression expression2 = equalTo.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = equalTo.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!equalTo.canEqual(this)) return false;
        return true;
    }

    public EqualTo(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

