/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.DateFormatClass$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression$class;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(timestamp, fmt) - Converts `timestamp` to a value of string in the format specified by the date format `fmt`.", arguments="\n    Arguments:\n      * timestamp - A date/timestamp or string to be converted to the given format.\n      * fmt - Date/time format pattern to follow. See `java.text.SimpleDateFormat` for valid date\n              and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-04-08', 'y');\n       2016\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\t\u0005a\u0001B\u0001\u0003\u0001>\u0011q\u0002R1uK\u001a{'/\\1u\u00072\f7o\u001d\u0006\u0003\u0007\u0011\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011QAB\u0001\tG\u0006$\u0018\r\\=ti*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M1\u0001\u0001\u0005\u000b\u00185\u0001\u0002\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\t\u0016\u0013\t1\"AA\fUS6,'l\u001c8f\u0003^\f'/Z#yaJ,7o]5p]B\u0011\u0011\u0003G\u0005\u00033\t\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\b!J|G-^2u!\tY\u0012%\u0003\u0002#9\ta1+\u001a:jC2L'0\u00192mK\"AA\u0005\u0001BK\u0002\u0013\u0005Q%\u0001\u0003mK\u001a$X#\u0001\u0014\u0011\u0005E9\u0013B\u0001\u0015\u0003\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\tU\u0001\u0011\t\u0012)A\u0005M\u0005)A.\u001a4uA!AA\u0006\u0001BK\u0002\u0013\u0005Q%A\u0003sS\u001eDG\u000f\u0003\u0005/\u0001\tE\t\u0015!\u0003'\u0003\u0019\u0011\u0018n\u001a5uA!A\u0001\u0007\u0001BK\u0002\u0013\u0005\u0011'\u0001\u0006uS6,'l\u001c8f\u0013\u0012,\u0012A\r\t\u00047M*\u0014B\u0001\u001b\u001d\u0005\u0019y\u0005\u000f^5p]B\u0011a'\u000f\b\u00037]J!\u0001\u000f\u000f\u0002\rA\u0013X\rZ3g\u0013\tQ4H\u0001\u0004TiJLgn\u001a\u0006\u0003qqA\u0001\"\u0010\u0001\u0003\u0012\u0003\u0006IAM\u0001\fi&lWMW8oK&#\u0007\u0005C\u0003@\u0001\u0011\u0005\u0001)\u0001\u0004=S:LGO\u0010\u000b\u0005\u0003\n\u001bE\t\u0005\u0002\u0012\u0001!)AE\u0010a\u0001M!)AF\u0010a\u0001M!9\u0001G\u0010I\u0001\u0002\u0004\u0011\u0004\"B \u0001\t\u00031EcA!H\u0011\")A%\u0012a\u0001M!)A&\u0012a\u0001M!)!\n\u0001C!\u0017\u0006AA-\u0019;b)f\u0004X-F\u0001M!\ti\u0005+D\u0001O\u0015\tye!A\u0003usB,7/\u0003\u0002R\u001d\nAA)\u0019;b)f\u0004X\rC\u0003T\u0001\u0011\u0005C+\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u0016\t\u0004-z\u000bgBA,]\u001d\tA6,D\u0001Z\u0015\tQf\"\u0001\u0004=e>|GOP\u0005\u0002;%\u0011Q\fH\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0006MA\u0002TKFT!!\u0018\u000f\u0011\u00055\u0013\u0017BA2O\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X\rC\u0003f\u0001\u0011\u0005c-\u0001\u0007xSRDG+[7f5>tW\r\u0006\u0002\u0015O\")\u0001\u0007\u001aa\u0001k!)\u0011\u000e\u0001C)U\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u00191N\u001c9\u0011\u0005ma\u0017BA7\u001d\u0005\r\te.\u001f\u0005\u0006_\"\u0004\ra[\u0001\ni&lWm\u001d;b[BDQ!\u001d5A\u0002-\faAZ8s[\u0006$\b\"B:\u0001\t\u0003\"\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0011)80!\u0001\u0011\u0005YLX\"A<\u000b\u0005a\u0014\u0011aB2pI\u0016<WM\\\u0005\u0003u^\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006yJ\u0004\r!`\u0001\u0004GRD\bC\u0001<\u007f\u0013\tyxO\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\r\u0005\r!\u000f1\u0001v\u0003\t)g\u000fC\u0004\u0002\b\u0001!\t%!\u0003\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u00016\u0011%\ti\u0001AA\u0001\n\u0003\ty!\u0001\u0003d_BLHcB!\u0002\u0012\u0005M\u0011Q\u0003\u0005\tI\u0005-\u0001\u0013!a\u0001M!AA&a\u0003\u0011\u0002\u0003\u0007a\u0005\u0003\u00051\u0003\u0017\u0001\n\u00111\u00013\u0011%\tI\u0002AI\u0001\n\u0003\tY\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005u!f\u0001\u0014\u0002 -\u0012\u0011\u0011\u0005\t\u0005\u0003G\ti#\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003%)hn\u00195fG.,GMC\u0002\u0002,q\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty#!\n\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u00024\u0001\t\n\u0011\"\u0001\u0002\u001c\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004\"CA\u001c\u0001E\u0005I\u0011AA\u001d\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a\u000f+\u0007I\ny\u0002C\u0005\u0002@\u0001\t\t\u0011\"\u0011\u0002B\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0011\u0011\t\u0005\u0015\u0013qJ\u0007\u0003\u0003\u000fRA!!\u0013\u0002L\u0005!A.\u00198h\u0015\t\ti%\u0001\u0003kCZ\f\u0017b\u0001\u001e\u0002H!I\u00111\u000b\u0001\u0002\u0002\u0013\u0005\u0011QK\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003/\u00022aGA-\u0013\r\tY\u0006\b\u0002\u0004\u0013:$\b\"CA0\u0001\u0005\u0005I\u0011AA1\u00039\u0001(o\u001c3vGR,E.Z7f]R$2a[A2\u0011)\t)'!\u0018\u0002\u0002\u0003\u0007\u0011qK\u0001\u0004q\u0012\n\u0004\"CA5\u0001\u0005\u0005I\u0011IA6\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA7!\u0015\ty'!\u001el\u001b\t\t\tHC\u0002\u0002tq\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9(!\u001d\u0003\u0011%#XM]1u_JD\u0011\"a\u001f\u0001\u0003\u0003%\t!! \u0002\u0011\r\fg.R9vC2$B!a \u0002\u0006B\u00191$!!\n\u0007\u0005\rEDA\u0004C_>dW-\u00198\t\u0013\u0005\u0015\u0014\u0011PA\u0001\u0002\u0004Y\u0007\"CAE\u0001\u0005\u0005I\u0011IAF\u0003\u0019)\u0017/^1mgR!\u0011qPAG\u0011%\t)'a\"\u0002\u0002\u0003\u00071\u000eK\n\u0001\u0003#\u000b9*!'\u0002\u001e\u0006}\u00151UAS\u0003S\u000bY\u000bE\u0002\u0012\u0003'K1!!&\u0003\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a'\u0002i~3UKT\"`QQLW.Z:uC6\u0004H\u0006\t4ni&\u0002S\u0006I\"p]Z,'\u000f^:!ARLW.Z:uC6\u0004\b\r\t;pA\u0005\u0004c/\u00197vK\u0002zg\rI:ue&tw\rI5oAQDW\r\t4pe6\fG\u000fI:qK\u000eLg-[3eA\tL\b\u0005\u001e5fA\u0011\fG/\u001a\u0011g_Jl\u0017\r\u001e\u0011aM6$\bML\u0001\nCJ<W/\\3oiN\f#!!)\u0002\u0003CT\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006\t;j[\u0016\u001cH/Y7qA5\u0002\u0013\t\t3bi\u0016|C/[7fgR\fW\u000e\u001d\u0011pe\u0002\u001aHO]5oO\u0002\"x\u000e\t2fA\r|gN^3si\u0016$\u0007\u0005^8!i\",\u0007eZ5wK:\u0004cm\u001c:nCRt#\u0002\t\u0011!A\u0001\u0002#\u0006\t4ni\u0002j\u0003\u0005R1uK>\"\u0018.\\3!M>\u0014X.\u0019;!a\u0006$H/\u001a:oAQ|\u0007EZ8mY><h\u0006I*fK\u0002\u0002'.\u0019<b]Q,\u0007\u0010\u001e\u0018TS6\u0004H.\u001a#bi\u00164uN]7bi\u0002\u0004cm\u001c:!m\u0006d\u0017\u000e\u001a\u0011eCR,'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\u00198eAQLW.\u001a\u0011g_Jl\u0017\r\u001e\u0011qCR$XM\u001d8t])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t9+A$\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u0012\u0004'\r\u001c.aQj\u0003\u0007O\u0014-A\u001dJx%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\ndG\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\ti+A\u00032]Ur\u0003gB\u0005\u00022\n\t\t\u0011#\u0001\u00024\u0006yA)\u0019;f\r>\u0014X.\u0019;DY\u0006\u001c8\u000fE\u0002\u0012\u0003k3\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011qW\n\u0006\u0003k\u000bI\f\t\t\t\u0003w\u000b\tM\n\u00143\u00036\u0011\u0011Q\u0018\u0006\u0004\u0003\u007fc\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003\u0007\fiLA\tBEN$(/Y2u\rVt7\r^5p]NBqaPA[\t\u0003\t9\r\u0006\u0002\u00024\"Q\u00111ZA[\u0003\u0003%)%!4\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0011\t\u0015\u0005E\u0017QWA\u0001\n\u0003\u000b\u0019.A\u0003baBd\u0017\u0010F\u0004B\u0003+\f9.!7\t\r\u0011\ny\r1\u0001'\u0011\u0019a\u0013q\u001aa\u0001M!A\u0001'a4\u0011\u0002\u0003\u0007!\u0007\u0003\u0006\u0002^\u0006U\u0016\u0011!CA\u0003?\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002b\u0006%\b\u0003B\u000e4\u0003G\u0004baGAsM\u0019\u0012\u0014bAAt9\t1A+\u001e9mKNB\u0011\"a;\u0002\\\u0006\u0005\t\u0019A!\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002p\u0006U\u0016\u0013!C\u0001\u0003s\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0004BCAz\u0003k\u000b\n\u0011\"\u0001\u0002:\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3\u0007\u0003\u0006\u0002x\u0006U\u0016\u0011!C\u0005\u0003s\f1B]3bIJ+7o\u001c7wKR\u0011\u00111 \t\u0005\u0003\u000b\ni0\u0003\u0003\u0002\u0000\u0006\u001d#AB(cU\u0016\u001cG\u000f")
public class DateFormatClass
extends BinaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
Serializable {
    private final Expression left;
    private final Expression right;
    private final Option<String> timeZoneId;
    private final boolean resolved;
    private final transient TimeZone timeZone;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<String> apply$default$3() {
        return DateFormatClass$.MODULE$.apply$default$3();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return DateFormatClass$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(DateFormatClass dateFormatClass) {
        return DateFormatClass$.MODULE$.unapply(dateFormatClass);
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, DateFormatClass> tupled() {
        return DateFormatClass$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, DateFormatClass>>> curried() {
        return DateFormatClass$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    private boolean resolved$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression$class.resolved(this);
                this.bitmap$0 = true;
            }
            return this.resolved;
        }
    }

    @Override
    public boolean resolved() {
        return this.bitmap$0 ? this.resolved : this.resolved$lzycompute();
    }

    private TimeZone timeZone$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if (!this.bitmap$trans$0) {
                this.timeZone = TimeZoneAwareExpression$class.timeZone(this);
                this.bitmap$trans$0 = true;
            }
            return this.timeZone;
        }
    }

    @Override
    public TimeZone timeZone() {
        return this.bitmap$trans$0 ? this.timeZone : this.timeZone$lzycompute();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{TimestampType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$11 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$12 = this.copy$default$1();
        Expression x$13 = this.copy$default$2();
        return this.copy(x$12, x$13, (Option<String>)x$11);
    }

    @Override
    public Object nullSafeEval(Object timestamp, Object format2) {
        DateFormat df = DateTimeUtils$.MODULE$.newDateFormat(format2.toString(), this.timeZone());
        return UTF8String.fromString((String)df.format(new Date(BoxesRunTime.unboxToLong((Object)timestamp) / 1000L)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        String tz = ctx.addReferenceObj("timeZone", this.timeZone(), ctx.addReferenceObj$default$3());
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)new Serializable(this, dtu, tz){
            public static final long serialVersionUID = 0L;
            private final String dtu$12;
            private final String tz$4;

            public final String apply(String timestamp, String format2) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UTF8String.fromString(", ".newDateFormat(", ".toString(), ", ")\n          .format(new java.util.Date(", " / 1000)))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dtu$12, format2, this.tz$4, timestamp}));
            }
            {
                this.dtu$12 = dtu$12;
                this.tz$4 = tz$4;
            }
        });
    }

    @Override
    public String prettyName() {
        return "date_format";
    }

    public DateFormatClass copy(Expression left, Expression right, Option<String> timeZoneId) {
        return new DateFormatClass(left, right, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "DateFormatClass";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            case 0: {
                object = this.left();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DateFormatClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DateFormatClass)) return false;
        boolean bl = true;
        if (!bl) return false;
        DateFormatClass dateFormatClass = (DateFormatClass)x$1;
        Expression expression = this.left();
        Expression expression2 = dateFormatClass.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = dateFormatClass.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = dateFormatClass.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!dateFormatClass.canEqual(this)) return false;
        return true;
    }

    public DateFormatClass(Expression left, Expression right, Option<String> timeZoneId) {
        this.left = left;
        this.right = right;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression$class.$init$(this);
        ExpectsInputTypes$class.$init$(this);
    }

    public DateFormatClass(Expression left, Expression right) {
        this(left, right, (Option<String>)None$.MODULE$);
    }
}

