/*
 * Decompiled with CFR 0.152.
 */
package breeze.stats.regression;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$mcD$sp;
import breeze.stats.regression.LeastSquaresRegressionResult;
import com.github.fommil.netlib.LAPACK;
import java.util.Arrays;
import org.netlib.util.intW;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.math.package$;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;

public final class leastSquaresImplementation$ {
    public static final leastSquaresImplementation$ MODULE$;

    static {
        new leastSquaresImplementation$();
    }

    public LeastSquaresRegressionResult doLeastSquares(DenseMatrix<Object> data, DenseVector<Object> outputs, double[] workArray) {
        Predef$.MODULE$.require(data.rows() == outputs.size());
        Predef$.MODULE$.require(data.rows() > data.cols() + 1);
        Predef$.MODULE$.require(workArray.length >= 2 * data.rows() * data.cols());
        intW info = new intW(0);
        LAPACK.getInstance().dgels("N", data.rows(), data.cols(), 1, data.data$mcD$sp(), data.rows(), outputs.data$mcD$sp(), data.rows(), workArray, workArray.length, info);
        if (info.val < 0) {
            throw new ArithmeticException("Least squares did not converge.");
        }
        DenseVector$mcD$sp coefficients2 = new DenseVector$mcD$sp(Arrays.copyOf(outputs.data$mcD$sp(), data.cols()));
        DoubleRef r2 = DoubleRef.create((double)0.0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), data.rows() - data.cols()).foreach$mVc$sp((Function1)new Serializable(data, outputs, r2){
            public static final long serialVersionUID = 0L;
            private final DenseMatrix data$1;
            private final DenseVector outputs$1;
            private final DoubleRef r2$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.r2$1.elem += package$.MODULE$.pow(this.outputs$1.data$mcD$sp()[this.data$1.cols() + i], 2.0);
            }
            {
                this.data$1 = data$1;
                this.outputs$1 = outputs$1;
                this.r2$1 = r2$1;
            }
        });
        return new LeastSquaresRegressionResult(coefficients2, r2.elem);
    }

    private leastSquaresImplementation$() {
        MODULE$ = this;
    }
}

