/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop.metadata;

import java.util.Set;
import parquet.column.Encoding;
import parquet.column.statistics.Statistics;
import parquet.hadoop.metadata.ColumnChunkMetaData;
import parquet.hadoop.metadata.ColumnChunkProperties;
import parquet.hadoop.metadata.ColumnPath;
import parquet.hadoop.metadata.CompressionCodecName;
import parquet.schema.PrimitiveType;

class LongColumnChunkMetaData
extends ColumnChunkMetaData {
    private final long firstDataPageOffset;
    private final long dictionaryPageOffset;
    private final long valueCount;
    private final long totalSize;
    private final long totalUncompressedSize;
    private final Statistics statistics;

    LongColumnChunkMetaData(ColumnPath path, PrimitiveType.PrimitiveTypeName type, CompressionCodecName codec, Set<Encoding> encodings, Statistics statistics, long firstDataPageOffset, long dictionaryPageOffset, long valueCount, long totalSize, long totalUncompressedSize) {
        super(ColumnChunkProperties.get(path, type, codec, encodings));
        this.firstDataPageOffset = firstDataPageOffset;
        this.dictionaryPageOffset = dictionaryPageOffset;
        this.valueCount = valueCount;
        this.totalSize = totalSize;
        this.totalUncompressedSize = totalUncompressedSize;
        this.statistics = statistics;
    }

    @Override
    public long getFirstDataPageOffset() {
        return this.firstDataPageOffset;
    }

    @Override
    public long getDictionaryPageOffset() {
        return this.dictionaryPageOffset;
    }

    @Override
    public long getValueCount() {
        return this.valueCount;
    }

    @Override
    public long getTotalUncompressedSize() {
        return this.totalUncompressedSize;
    }

    @Override
    public long getTotalSize() {
        return this.totalSize;
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }
}

