/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.storage.Zero;
import com.github.fommil.netlib.ARPACK;
import java.util.Arrays;
import org.netlib.util.doubleW;
import org.netlib.util.intW;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class EigenValueDecomposition$ {
    public static final EigenValueDecomposition$ MODULE$;

    static {
        new EigenValueDecomposition$();
    }

    public Tuple2<DenseVector<Object>, DenseMatrix<Object>> symmetricEigs(Function1<DenseVector<Object>, DenseVector<Object>> mul, int n, int k, double tol, int maxIterations) {
        Predef$.MODULE$.require(n > k, (Function0)new Serializable(n, k){
            public static final long serialVersionUID = 0L;
            private final int n$1;
            private final int k$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of required eigenvalues ", " must be smaller than matrix dimension ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$1), BoxesRunTime.boxToInteger((int)this.n$1)}));
            }
            {
                this.n$1 = n$1;
                this.k$1 = k$1;
            }
        });
        ARPACK arpack = ARPACK.getInstance();
        doubleW tolW = new doubleW(tol);
        intW nev = new intW(k);
        int ncv = package$.MODULE$.min(2 * k, n);
        String bmat = "I";
        String which = "LM";
        int[] iparam = new int[11];
        iparam[0] = 1;
        iparam[2] = maxIterations;
        iparam[6] = 1;
        Predef$.MODULE$.require((long)n * (long)ncv <= Integer.MAX_VALUE && (long)ncv * ((long)ncv + 8L) <= Integer.MAX_VALUE, (Function0)new Serializable(n, k){
            public static final long serialVersionUID = 0L;
            private final int n$1;
            private final int k$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k = ", " and/or n = ", " are too large to compute an eigendecomposition"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$1), BoxesRunTime.boxToInteger((int)this.n$1)}));
            }
            {
                this.n$1 = n$1;
                this.k$1 = k$1;
            }
        });
        intW ido = new intW(0);
        intW info = new intW(0);
        double[] resid = new double[n];
        double[] v = new double[n * ncv];
        double[] workd = new double[n * 3];
        double[] workl = new double[ncv * (ncv + 8)];
        int[] ipntr = new int[11];
        arpack.dsaupd(ido, bmat, n, which, nev.val, tolW, resid, ncv, v, n, iparam, ipntr, workd, workl, workl.length, info);
        DenseVector w2 = DenseVector$.MODULE$.apply$mDc$sp(workd);
        while (ido.val != 99) {
            if (ido.val != -1 && ido.val != 1) {
                throw new IllegalStateException(new StringBuilder().append((Object)"ARPACK returns ido = ").append((Object)BoxesRunTime.boxToInteger((int)ido.val)).append((Object)" This flag is not compatible with Mode 1: A*x = lambda*x, A symmetric.").toString());
            }
            int inputOffset = ipntr[0] - 1;
            int outputOffset = ipntr[1] - 1;
            DenseVector x = w2.slice$mcD$sp(inputOffset, inputOffset + n, w2.slice$default$3());
            DenseVector y = w2.slice$mcD$sp(outputOffset, outputOffset + n, w2.slice$default$3());
            y.$colon$eq(mul.apply((Object)x), DenseVector$.MODULE$.dv_dv_UpdateOp_Double_OpSet());
            arpack.dsaupd(ido, bmat, n, which, nev.val, tolW, resid, ncv, v, n, iparam, ipntr, workd, workl, workl.length, info);
        }
        if (info.val != 0) {
            int n2 = info.val;
            switch (n2) {
                default: {
                    throw new IllegalStateException(new StringBuilder().append((Object)"ARPACK returns non-zero info = ").append((Object)BoxesRunTime.boxToInteger((int)info.val)).append((Object)" Please refer ARPACK user guide for error message.").toString());
                }
                case 3: {
                    throw new IllegalStateException(new StringBuilder().append((Object)"ARPACK returns non-zero info = ").append((Object)BoxesRunTime.boxToInteger((int)info.val)).append((Object)" No shifts could be applied. Try to increase NCV. ").append((Object)"(Refer ARPACK user guide for details)").toString());
                }
                case 1: 
            }
            throw new IllegalStateException(new StringBuilder().append((Object)"ARPACK returns non-zero info = ").append((Object)BoxesRunTime.boxToInteger((int)info.val)).append((Object)" Maximum number of iterations taken. (Refer ARPACK user guide for details)").toString());
        }
        double[] d = new double[nev.val];
        boolean[] select = new boolean[ncv];
        double[] z = Arrays.copyOfRange(v, 0, nev.val * n);
        arpack.dseupd(true, "A", select, d, z, n, 0.0, bmat, n, which, nev, tol, resid, ncv, v, n, iparam, ipntr, workd, workl, workl.length, info);
        int computed = iparam[4];
        Tuple2[] eigenPairs = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(Arrays.copyOfRange(d, 0, computed)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(n, z){
            public static final long serialVersionUID = 0L;
            private final int n$1;
            private final double[] z$1;

            public final Tuple2<Object, double[]> apply(Tuple2<Object, Object> r) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)r._1$mcD$sp()), (Object)Arrays.copyOfRange(this.z$1, r._2$mcI$sp() * this.n$1, r._2$mcI$sp() * this.n$1 + this.n$1));
            }
            {
                this.n$1 = n$1;
                this.z$1 = z$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        Tuple2[] sortedEigenPairs = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])eigenPairs).sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, double[]> x$1) {
                return -x$1._1$mcD$sp();
            }
        }, (Ordering)Ordering.Double$.MODULE$);
        DenseMatrix sortedU = DenseMatrix$.MODULE$.zeros$mDc$sp(n, computed, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])sortedEigenPairs).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(n, sortedU){
            public static final long serialVersionUID = 0L;
            private final int n$1;
            private final DenseMatrix sortedU$1;

            public final void apply(Tuple2<Tuple2<Object, double[]>, Object> r) {
                int b = r._2$mcI$sp() * this.n$1;
                for (int i = 0; i < this.n$1; ++i) {
                    this.sortedU$1.data$mcD$sp()[b + i] = ((double[])((Tuple2)r._1())._2())[i];
                }
            }
            {
                this.n$1 = n$1;
                this.sortedU$1 = sortedU$1;
            }
        });
        return new Tuple2((Object)DenseVector$.MODULE$.apply(Predef$.MODULE$.refArrayOps((Object[])sortedEigenPairs).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, double[]> x$2) {
                return x$2._1$mcD$sp();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), (Object)sortedU);
    }

    private EigenValueDecomposition$() {
        MODULE$ = this;
    }
}

