/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import com.github.fommil.netlib.LAPACK;
import org.apache.spark.ml.optim.SingularMatrixException;
import org.netlib.util.intW;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class CholeskyDecomposition$ {
    public static final CholeskyDecomposition$ MODULE$;

    static {
        new CholeskyDecomposition$();
    }

    public double[] solve(double[] A, double[] bx) {
        int k = bx.length;
        intW info = new intW(0);
        LAPACK.getInstance().dppsv("U", k, 1, A, bx, k, info);
        this.checkReturnValue(info, "dppsv");
        return bx;
    }

    public double[] inverse(double[] UAi, int k) {
        intW info = new intW(0);
        LAPACK.getInstance().dpptri("U", k, UAi, info);
        this.checkReturnValue(info, "dpptri");
        return UAi;
    }

    private void checkReturnValue(intW info, String method) {
        int n = info.val;
        switch (n) {
            default: 
        }
        if (n < 0) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LAPACK.", " returned ", "; arg ", " is illegal"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{method, BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)(-n))})));
        }
        if (n > 0) {
            throw new SingularMatrixException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LAPACK.", " returned ", " because A is not positive definite. Is A derived from "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{method, BoxesRunTime.boxToInteger((int)n)}))).append((Object)"a singular matrix (e.g. collinear column values)?").toString());
        }
    }

    private CholeskyDecomposition$() {
        MODULE$ = this;
    }
}

