/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MultiMap<V>
extends HashMap<String, List<V>> {
    public MultiMap() {
    }

    public MultiMap(Map<String, List<V>> map2) {
        super(map2);
    }

    public MultiMap(MultiMap<V> map2) {
        super(map2);
    }

    public List<V> getValues(String name2) {
        List vals = (List)super.get(name2);
        if (vals == null || vals.isEmpty()) {
            return null;
        }
        return vals;
    }

    public V getValue(String name2, int i) {
        List<V> vals = this.getValues(name2);
        if (vals == null) {
            return null;
        }
        if (i == 0 && vals.isEmpty()) {
            return null;
        }
        return vals.get(i);
    }

    public String getString(String name2) {
        List vals = (List)this.get(name2);
        if (vals == null || vals.isEmpty()) {
            return null;
        }
        if (vals.size() == 1) {
            return vals.get(0).toString();
        }
        StringBuilder values2 = new StringBuilder(128);
        for (Object e : vals) {
            if (e == null) continue;
            if (values2.length() > 0) {
                values2.append(',');
            }
            values2.append(e.toString());
        }
        return values2.toString();
    }

    @Override
    public List<V> put(String name2, V value2) {
        if (value2 == null) {
            return super.put(name2, null);
        }
        ArrayList<V> vals = new ArrayList<V>();
        vals.add(value2);
        return this.put(name2, vals);
    }

    public void putAllValues(Map<String, V> input) {
        for (Map.Entry<String, V> entry : input.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public List<V> putValues(String name2, List<V> values2) {
        return super.put(name2, values2);
    }

    @SafeVarargs
    public final List<V> putValues(String name2, V ... values2) {
        ArrayList<V> list = new ArrayList<V>();
        list.addAll(Arrays.asList(values2));
        return super.put(name2, list);
    }

    public void add(String name2, V value2) {
        ArrayList<V> lo = (ArrayList<V>)this.get(name2);
        if (lo == null) {
            lo = new ArrayList<V>();
        }
        lo.add(value2);
        super.put(name2, lo);
    }

    public void addValues(String name2, List<V> values2) {
        ArrayList<V> lo = (ArrayList<V>)this.get(name2);
        if (lo == null) {
            lo = new ArrayList<V>();
        }
        lo.addAll(values2);
        this.put(name2, lo);
    }

    public void addValues(String name2, V[] values2) {
        ArrayList<V> lo = (ArrayList<V>)this.get(name2);
        if (lo == null) {
            lo = new ArrayList<V>();
        }
        lo.addAll(Arrays.asList(values2));
        this.put(name2, lo);
    }

    public boolean addAllValues(MultiMap<V> map2) {
        boolean merged = false;
        if (map2 == null || map2.isEmpty()) {
            return merged;
        }
        for (Map.Entry entry : map2.entrySet()) {
            String name2 = (String)entry.getKey();
            List values2 = (List)entry.getValue();
            if (this.containsKey(name2)) {
                merged = true;
            }
            this.addValues(name2, values2);
        }
        return merged;
    }

    public boolean removeValue(String name2, V value2) {
        List lo = (List)this.get(name2);
        if (lo == null || lo.isEmpty()) {
            return false;
        }
        boolean ret = lo.remove(value2);
        if (lo.isEmpty()) {
            this.remove(name2);
        } else {
            this.put(name2, lo);
        }
        return ret;
    }

    public boolean containsSimpleValue(V value2) {
        for (List vals : this.values()) {
            if (vals.size() != 1 || !vals.contains(value2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        Iterator iter = this.entrySet().iterator();
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean delim = false;
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            if (delim) {
                sb.append(", ");
            }
            String key = (String)e.getKey();
            List vals = (List)e.getValue();
            sb.append(key);
            sb.append('=');
            if (vals.size() == 1) {
                sb.append(vals.get(0));
            } else {
                sb.append(vals);
            }
            delim = true;
        }
        sb.append('}');
        return sb.toString();
    }

    public Map<String, String[]> toStringArrayMap() {
        HashMap<String, String[]> map2 = new HashMap<String, String[]>(this.size() * 3 / 2){

            @Override
            public String toString() {
                StringBuilder b = new StringBuilder();
                b.append('{');
                for (String k : super.keySet()) {
                    if (b.length() > 1) {
                        b.append(',');
                    }
                    b.append(k);
                    b.append('=');
                    b.append(Arrays.asList((String[])super.get(k)));
                }
                b.append('}');
                return b.toString();
            }
        };
        for (Map.Entry entry : this.entrySet()) {
            String[] a = null;
            if (entry.getValue() != null) {
                a = new String[((List)entry.getValue()).size()];
                a = ((List)entry.getValue()).toArray(a);
            }
            map2.put((String)entry.getKey(), a);
        }
        return map2;
    }
}

