/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.mapping.MappingHelper;
import org.datanucleus.store.rdbms.mapping.StatementClassMapping;
import org.datanucleus.store.rdbms.mapping.StatementMappingIndex;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.query.StatementParameterMapping;
import org.datanucleus.store.rdbms.scostore.AbstractSetStore;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.sql.AbstractStatementGenerator;
import org.datanucleus.store.rdbms.sql.DiscriminatorStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.UnionStatementGenerator;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.DatastoreClass;
import org.datanucleus.store.rdbms.table.MapTable;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.util.ClassUtils;

class MapValueSetStore
extends AbstractSetStore {
    protected final MapStore mapStore;
    protected final JavaTypeMapping keyMapping;
    private String findKeyStmt;
    private String iteratorStmtLocked = null;
    private String iteratorStmtUnlocked = null;
    private StatementClassMapping iteratorMappingDef = null;
    private StatementParameterMapping iteratorMappingParams = null;

    MapValueSetStore(MapTable mapTable, MapStore mapStore, ClassLoaderResolver clr) {
        super(mapTable.getStoreManager(), clr);
        this.containerTable = mapTable;
        this.mapStore = mapStore;
        this.ownerMapping = mapTable.getOwnerMapping();
        this.keyMapping = mapTable.getKeyMapping();
        this.elementMapping = mapTable.getValueMapping();
        this.elementType = this.elementMapping.getType();
        this.ownerMemberMetaData = mapTable.getOwnerMemberMetaData();
        this.initialize(clr);
        this.findKeyStmt = this.keyMapping != null ? this.getFindKeyStmt() : null;
    }

    MapValueSetStore(DatastoreClass mapTable, MapStore mapStore, ClassLoaderResolver clr, JavaTypeMapping ownerMapping, JavaTypeMapping valueMapping, AbstractMemberMetaData ownerMmd) {
        super(mapTable.getStoreManager(), clr);
        this.containerTable = mapTable;
        this.mapStore = mapStore;
        this.ownerMapping = ownerMapping;
        this.keyMapping = null;
        this.elementMapping = valueMapping;
        this.ownerMemberMetaData = ownerMmd;
        this.initialize(clr);
        this.findKeyStmt = this.keyMapping != null ? this.getFindKeyStmt() : null;
    }

    private void initialize(ClassLoaderResolver clr) {
        this.elementType = this.elementMapping.getType();
        this.elementsAreEmbedded = this.isEmbeddedMapping(this.elementMapping);
        this.elementsAreSerialised = this.isEmbeddedMapping(this.elementMapping);
        Class valueCls = clr.classForName(this.elementType);
        this.emd = ClassUtils.isReferenceType((Class)valueCls) ? this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForImplementationOfReference(valueCls, null, clr) : this.storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(valueCls, clr);
        if (this.emd != null) {
            this.elementType = this.emd.getFullClassName();
            this.elementInfo = this.getElementInformationForClass();
        }
    }

    @Override
    public boolean add(ObjectProvider op, Object element, int size) {
        throw new UnsupportedOperationException("Cannot add to a map through its values collection");
    }

    @Override
    public boolean addAll(ObjectProvider op, Collection elements, int size) {
        throw new UnsupportedOperationException("Cannot add to a map through its values collection");
    }

    @Override
    public boolean remove(ObjectProvider op, Object element, int size, boolean allowDependentField) {
        if (!this.validateElementForReading(op, element)) {
            return false;
        }
        return this.remove(op, element);
    }

    @Override
    public boolean removeAll(ObjectProvider op, Collection elements, int size) {
        throw new NucleusUserException("Cannot remove values from a map through its values collection");
    }

    @Override
    public void clear(ObjectProvider op) {
        if (this.canClear()) {
            throw new NucleusUserException("Cannot clear a map through its values collection");
        }
        super.clear(op);
    }

    protected boolean canClear() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean remove(ObjectProvider op, Object element) {
        if (this.findKeyStmt == null) {
            throw new UnsupportedOperationException("Cannot remove from a map through its values collection");
        }
        Object key = null;
        boolean keyExists = false;
        ExecutionContext ec = op.getExecutionContext();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, this.findKeyStmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
                    BackingStoreHelper.populateElementInStatement(ec, ps, element, jdbcPosition, this.elementMapping);
                    ResultSet rs = sqlControl.executeStatementQuery(ec, mconn, this.findKeyStmt, ps);
                    try {
                        if (rs.next()) {
                            key = this.keyMapping.getObject(ec, rs, MappingHelper.getMappingIndices(1, this.keyMapping));
                            keyExists = true;
                        }
                        JDBCUtils.logWarnings(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException("Request failed to check if set contains an element: " + this.findKeyStmt, (Throwable)e);
        }
        if (keyExists) {
            this.mapStore.remove(op, key);
            return true;
        }
        return false;
    }

    private String getFindKeyStmt() {
        StringBuffer stmt = new StringBuffer("SELECT ");
        for (int i = 0; i < this.keyMapping.getNumberOfDatastoreMappings(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(this.keyMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
        }
        stmt.append(" FROM ");
        stmt.append(this.containerTable.toString());
        stmt.append(" WHERE ");
        BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, null, true);
        BackingStoreHelper.appendWhereClauseForMapping(stmt, this.elementMapping, null, false);
        return stmt.toString();
    }

    /*
     * Exception decompiling
     */
    @Override
    public Iterator iterator(ObjectProvider ownerOP) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected SQLStatement getSQLStatementForIterator(ObjectProvider ownerOP) {
        JavaTypeMapping valueIdMapping;
        AbstractStatementGenerator stmtGen;
        SQLStatement sqlStmt = null;
        ClassLoaderResolver clr = ownerOP.getExecutionContext().getClassLoaderResolver();
        Class valueCls = clr.classForName(this.elementType);
        SQLTable containerSqlTbl = null;
        MapMetaData.MapType mapType = this.getOwnerMemberMetaData().getMap().getMapType();
        if (this.emd != null && this.emd.getDiscriminatorStrategyForTable() != null && this.emd.getDiscriminatorStrategyForTable() != DiscriminatorStrategy.NONE) {
            JavaTypeMapping valueIdMapping2;
            if (ClassUtils.isReferenceType((Class)valueCls)) {
                String[] clsNames = this.storeMgr.getNucleusContext().getMetaDataManager().getClassesImplementingInterface(this.elementType, clr);
                Class[] cls = new Class[clsNames.length];
                for (int j = 0; j < clsNames.length; ++j) {
                    cls[j] = clr.classForName(clsNames[j]);
                }
                DiscriminatorStatementGenerator stmtGen2 = new DiscriminatorStatementGenerator(this.storeMgr, clr, cls, true, null, null);
                sqlStmt = stmtGen2.getStatement();
            } else {
                stmtGen = new DiscriminatorStatementGenerator(this.storeMgr, clr, valueCls, true, null, null);
                sqlStmt = stmtGen.getStatement();
            }
            this.iterateUsingDiscriminator = true;
            if (mapType == MapMetaData.MapType.MAP_TYPE_VALUE_IN_KEY) {
                valueIdMapping2 = sqlStmt.getPrimaryTable().getTable().getIdMapping();
                containerSqlTbl = sqlStmt.innerJoin(sqlStmt.getPrimaryTable(), valueIdMapping2, this.containerTable, null, this.elementMapping, null, null);
                this.iteratorMappingDef = new StatementClassMapping();
                SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(sqlStmt, this.iteratorMappingDef, ownerOP.getExecutionContext().getFetchPlan(), sqlStmt.getPrimaryTable(), this.emd, 0);
            } else if (mapType == MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE) {
                containerSqlTbl = sqlStmt.getPrimaryTable();
                this.iteratorMappingDef = new StatementClassMapping();
                SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(sqlStmt, this.iteratorMappingDef, ownerOP.getExecutionContext().getFetchPlan(), sqlStmt.getPrimaryTable(), this.emd, 0);
            } else {
                valueIdMapping2 = sqlStmt.getPrimaryTable().getTable().getIdMapping();
                containerSqlTbl = sqlStmt.innerJoin(sqlStmt.getPrimaryTable(), valueIdMapping2, this.containerTable, null, this.elementMapping, null, null);
                this.iteratorMappingDef = new StatementClassMapping();
                SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(sqlStmt, this.iteratorMappingDef, ownerOP.getExecutionContext().getFetchPlan(), sqlStmt.getPrimaryTable(), this.emd, 0);
            }
        } else if (mapType == MapMetaData.MapType.MAP_TYPE_VALUE_IN_KEY) {
            if (this.emd != null) {
                this.iteratorMappingDef = new StatementClassMapping();
                stmtGen = new UnionStatementGenerator(this.storeMgr, clr, valueCls, true, null, null);
                stmtGen.setOption("selectNucleusType");
                this.iteratorMappingDef.setNucleusTypeColumnName("NUCLEUS_TYPE");
                sqlStmt = ((UnionStatementGenerator)stmtGen).getStatement();
                valueIdMapping = sqlStmt.getPrimaryTable().getTable().getIdMapping();
                containerSqlTbl = sqlStmt.innerJoin(sqlStmt.getPrimaryTable(), valueIdMapping, this.containerTable, null, this.elementMapping, null, null);
                SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(sqlStmt, this.iteratorMappingDef, ownerOP.getExecutionContext().getFetchPlan(), sqlStmt.getPrimaryTable(), this.emd, 0);
            } else {
                sqlStmt = new SQLStatement(this.storeMgr, this.containerTable, null, null);
                sqlStmt.setClassLoaderResolver(clr);
                SQLTable elemSqlTblForValue = containerSqlTbl = sqlStmt.getPrimaryTable();
                if (this.elementMapping.getTable() != containerSqlTbl.getTable() && (elemSqlTblForValue = sqlStmt.getTableForDatastoreContainer(this.elementMapping.getTable())) == null) {
                    elemSqlTblForValue = sqlStmt.innerJoin(sqlStmt.getPrimaryTable(), sqlStmt.getPrimaryTable().getTable().getIdMapping(), this.elementMapping.getTable(), null, this.elementMapping.getTable().getIdMapping(), null, null);
                }
                sqlStmt.select(elemSqlTblForValue, this.elementMapping, null);
            }
        } else if (mapType == MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE) {
            this.iteratorMappingDef = new StatementClassMapping();
            stmtGen = new UnionStatementGenerator(this.storeMgr, clr, valueCls, true, null, null);
            stmtGen.setOption("selectNucleusType");
            this.iteratorMappingDef.setNucleusTypeColumnName("NUCLEUS_TYPE");
            sqlStmt = ((UnionStatementGenerator)stmtGen).getStatement();
            containerSqlTbl = sqlStmt.getPrimaryTable();
            SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(sqlStmt, this.iteratorMappingDef, ownerOP.getExecutionContext().getFetchPlan(), sqlStmt.getPrimaryTable(), this.emd, 0);
        } else if (this.emd != null) {
            this.iteratorMappingDef = new StatementClassMapping();
            stmtGen = new UnionStatementGenerator(this.storeMgr, clr, valueCls, true, null, null);
            stmtGen.setOption("selectNucleusType");
            this.iteratorMappingDef.setNucleusTypeColumnName("NUCLEUS_TYPE");
            sqlStmt = ((UnionStatementGenerator)stmtGen).getStatement();
            valueIdMapping = sqlStmt.getPrimaryTable().getTable().getIdMapping();
            containerSqlTbl = sqlStmt.innerJoin(sqlStmt.getPrimaryTable(), valueIdMapping, this.containerTable, null, this.elementMapping, null, null);
            SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(sqlStmt, this.iteratorMappingDef, ownerOP.getExecutionContext().getFetchPlan(), sqlStmt.getPrimaryTable(), this.emd, 0);
        } else {
            sqlStmt = new SQLStatement(this.storeMgr, this.containerTable, null, null);
            containerSqlTbl = sqlStmt.getPrimaryTable();
            sqlStmt.select(sqlStmt.getPrimaryTable(), this.elementMapping, null);
        }
        SQLExpressionFactory exprFactory = this.storeMgr.getSQLExpressionFactory();
        SQLTable ownerSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, containerSqlTbl, this.ownerMapping);
        SQLExpression ownerExpr = exprFactory.newExpression(sqlStmt, ownerSqlTbl, this.ownerMapping);
        SQLExpression ownerVal = exprFactory.newLiteralParameter(sqlStmt, this.ownerMapping, null, "OWNER");
        sqlStmt.whereAnd(ownerExpr.eq(ownerVal), true);
        int inputParamNum = 1;
        StatementMappingIndex ownerIdx = new StatementMappingIndex(this.ownerMapping);
        if (sqlStmt.getNumberOfUnions() > 0) {
            for (int j = 0; j < sqlStmt.getNumberOfUnions() + 1; ++j) {
                int[] paramPositions = new int[this.ownerMapping.getNumberOfDatastoreMappings()];
                for (int k = 0; k < this.ownerMapping.getNumberOfDatastoreMappings(); ++k) {
                    paramPositions[k] = inputParamNum++;
                }
                ownerIdx.addParameterOccurrence(paramPositions);
            }
        } else {
            int[] paramPositions = new int[this.ownerMapping.getNumberOfDatastoreMappings()];
            for (int k = 0; k < this.ownerMapping.getNumberOfDatastoreMappings(); ++k) {
                paramPositions[k] = inputParamNum++;
            }
            ownerIdx.addParameterOccurrence(paramPositions);
        }
        this.iteratorMappingParams = new StatementParameterMapping();
        this.iteratorMappingParams.addMappingForParameter("owner", ownerIdx);
        return sqlStmt;
    }
}

