/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;

public class MathExpr {
    public static double round(double d) {
        if (d > 0.0) {
            return (long)(d + 0.5);
        }
        return (long)(d - 0.5);
    }

    public static double log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    public static long abs(long v) {
        return v >= 0L ? v : -v;
    }

    public static double sign(double v) {
        if (v == 0.0) {
            return 0.0;
        }
        if (v > 0.0) {
            return 1.0;
        }
        return -1.0;
    }

    public static double sign(long v) {
        if (v == 0L) {
            return 0.0;
        }
        if (v > 0L) {
            return 1.0;
        }
        return -1.0;
    }

    public static long toBool(long v) {
        return v == 0L ? 0L : 1L;
    }

    public static long toBool(double v) {
        return v == 0.0 ? 0L : 1L;
    }

    public static long longToTimestamp(long v) {
        return v * 1000000000L;
    }

    public static long millisecondsLongToTimestamp(long v) {
        return v * 1000000L;
    }

    public static long doubleToTimestamp(double v) {
        return (long)(v * 1.0E9);
    }

    public static long fromTimestamp(long v) {
        return v / 1000000000L;
    }

    public static double fromTimestampToDouble(long v) {
        return (double)v / 1.0E9;
    }

    public static int writeLongToUTF8(byte[] result, long i) {
        if (i == 0L) {
            result[0] = 48;
            return 1;
        }
        int current = 0;
        if (i < 0L) {
            result[current++] = 45;
        } else {
            i = -i;
        }
        long start = 1000000000000000000L;
        while (i / start == 0L) {
            start /= 10L;
        }
        while (start > 0L) {
            result[current++] = (byte)(48L - i / start % 10L);
            start /= 10L;
        }
        return current;
    }

    public static void NaNToNull(DoubleColumnVector v, int[] sel, boolean selectedInUse, int n) {
        MathExpr.NaNToNull(v, sel, selectedInUse, n, false);
    }

    public static void NaNToNull(DoubleColumnVector v, int[] sel, boolean selectedInUse, int n, boolean convertInfinity) {
        if (v.isRepeating) {
            if (convertInfinity && Double.isInfinite(v.vector[0]) || Double.isNaN(v.vector[0])) {
                v.vector[0] = Double.NaN;
                v.isNull[0] = true;
                v.noNulls = false;
            }
            return;
        }
        if (v.noNulls) {
            if (selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (convertInfinity && Double.isInfinite(v.vector[i]) || Double.isNaN(v.vector[i])) {
                        v.vector[i] = Double.NaN;
                        v.isNull[i] = true;
                        v.noNulls = false;
                        continue;
                    }
                    v.isNull[i] = false;
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (convertInfinity && Double.isInfinite(v.vector[i]) || Double.isNaN(v.vector[i])) {
                        v.vector[i] = Double.NaN;
                        v.isNull[i] = true;
                        v.noNulls = false;
                        continue;
                    }
                    v.isNull[i] = false;
                }
            }
        } else if (selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if ((!convertInfinity || !Double.isInfinite(v.vector[i])) && !Double.isNaN(v.vector[i])) continue;
                v.vector[i] = Double.NaN;
                v.isNull[i] = true;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if ((!convertInfinity || !Double.isInfinite(v.vector[i])) && !Double.isNaN(v.vector[i])) continue;
                v.vector[i] = Double.NaN;
                v.isNull[i] = true;
            }
        }
    }
}

