/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Random;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class FuncRandNoSeed
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int outputCol;
    private Random random;

    public FuncRandNoSeed(int outputCol) {
        this.outputCol = outputCol;
        this.random = new Random();
    }

    public FuncRandNoSeed() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            this.evaluateChildren(batch);
        }
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[this.outputCol];
        int[] sel = batch.selected;
        int n = batch.size;
        double[] outputVector = outputColVector.vector;
        outputColVector.noNulls = true;
        outputColVector.isRepeating = false;
        if (n == 0) {
            return;
        }
        if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outputVector[i] = this.random.nextDouble();
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outputVector[i] = this.random.nextDouble();
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputCol;
    }

    public int getOutputCol() {
        return this.outputCol;
    }

    public void setOutputCol(int outputCol) {
        this.outputCol = outputCol;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    @Override
    public String getOutputType() {
        return "double";
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(0).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.NONE).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.NONE).build();
    }
}

