/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.util;

import java.util.Random;
import org.apache.spark.SparkContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseMatrix$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@DeveloperApi
public final class MFDataGenerator$ {
    public static final MFDataGenerator$ MODULE$;

    static {
        new MFDataGenerator$();
    }

    public void main(String[] args) {
        if (args.length < 2) {
            Predef$.MODULE$.println((Object)"Usage: MFDataGenerator <master> <outputDir> [m] [n] [rank] [trainSampFact] [noise] [sigma] [test] [testSampFact]");
            System.exit(1);
        }
        String sparkMaster = args[0];
        String outputPath = args[1];
        int m = args.length > 2 ? new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt() : 100;
        int n = args.length > 3 ? new StringOps(Predef$.MODULE$.augmentString(args[3])).toInt() : 100;
        int rank = args.length > 4 ? new StringOps(Predef$.MODULE$.augmentString(args[4])).toInt() : 10;
        double trainSampFact = args.length > 5 ? new StringOps(Predef$.MODULE$.augmentString(args[5])).toDouble() : 1.0;
        boolean noise = args.length > 6 ? new StringOps(Predef$.MODULE$.augmentString(args[6])).toBoolean() : false;
        double sigma2 = args.length > 7 ? new StringOps(Predef$.MODULE$.augmentString(args[7])).toDouble() : 0.1;
        boolean test2 = args.length > 8 ? new StringOps(Predef$.MODULE$.augmentString(args[8])).toBoolean() : false;
        double testSampFact = args.length > 9 ? new StringOps(Predef$.MODULE$.augmentString(args[9])).toDouble() : 0.1;
        SparkContext sc = new SparkContext(sparkMaster, "MFDataGenerator");
        Random random = new Random(42L);
        DenseMatrix A = DenseMatrix$.MODULE$.randn(m, rank, random);
        DenseMatrix B = DenseMatrix$.MODULE$.randn(rank, n, random);
        double z = 1.0 / package$.MODULE$.sqrt((double)rank);
        DenseMatrix fullData = DenseMatrix$.MODULE$.zeros(m, n);
        BLAS$.MODULE$.gemm(z, (Matrix)A, B, 1.0, fullData);
        int df = rank * (m + n - rank);
        int sampSize = (int)package$.MODULE$.min(package$.MODULE$.round(trainSampFact * (double)df), package$.MODULE$.round(0.99 * (double)m * (double)n));
        scala.util.Random rand2 = new scala.util.Random();
        int mn = m * n;
        List shuffled = (List)rand2.shuffle((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), mn).toList(), List$.MODULE$.canBuildFrom());
        List omega = shuffled.slice(0, sampSize);
        int[] ordered = (int[])((TraversableOnce)omega.sortWith((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int x$1, int x$2) {
                return this.apply$mcZII$sp(x$1, x$2);
            }

            public boolean apply$mcZII$sp(int x$1, int x$2) {
                return x$1 < x$2;
            }
        })).toArray(ClassTag$.MODULE$.Int());
        RDD trainData = sc.parallelize((Seq)Predef$.MODULE$.wrapIntArray(ordered), sc.parallelize$default$2(), ClassTag$.MODULE$.Int()).map((Function1)new Serializable(m, fullData){
            public static final long serialVersionUID = 0L;
            private final int m$1;
            private final DenseMatrix fullData$1;

            public final Tuple3<Object, Object, Object> apply(int x) {
                return new Tuple3((Object)BoxesRunTime.boxToInteger((int)(x % this.m$1)), (Object)BoxesRunTime.boxToInteger((int)(x / this.m$1)), (Object)BoxesRunTime.boxToDouble((double)this.fullData$1.values()[x]));
            }
            {
                this.m$1 = m$1;
                this.fullData$1 = fullData$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        Object object = noise ? trainData.map((Function1)new Serializable(sigma2, rand2){
            public static final long serialVersionUID = 0L;
            private final double sigma$1;
            private final scala.util.Random rand$1;

            public final Tuple3<Object, Object, Object> apply(Tuple3<Object, Object, Object> x) {
                return new Tuple3(x._1(), x._2(), (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)x._3()) + this.rand$1.nextGaussian() * this.sigma$1)));
            }
            {
                this.sigma$1 = sigma$1;
                this.rand$1 = rand$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class)) : BoxedUnit.UNIT;
        trainData.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple3<Object, Object, Object> x) {
                return new StringBuilder().append(BoxesRunTime.unboxToInt((Object)x._1())).append((Object)",").append(x._2()).append((Object)",").append(x._3()).toString();
            }
        }, ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(outputPath);
        if (test2) {
            int testSampSize = package$.MODULE$.min((int)package$.MODULE$.round((double)sampSize * testSampFact), mn - sampSize);
            List testOmega = shuffled.slice(sampSize, sampSize + testSampSize);
            int[] testOrdered = (int[])((TraversableOnce)testOmega.sortWith((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(int x$3, int x$4) {
                    return this.apply$mcZII$sp(x$3, x$4);
                }

                public boolean apply$mcZII$sp(int x$3, int x$4) {
                    return x$3 < x$4;
                }
            })).toArray(ClassTag$.MODULE$.Int());
            RDD testData = sc.parallelize((Seq)Predef$.MODULE$.wrapIntArray(testOrdered), sc.parallelize$default$2(), ClassTag$.MODULE$.Int()).map((Function1)new Serializable(m, fullData){
                public static final long serialVersionUID = 0L;
                private final int m$1;
                private final DenseMatrix fullData$1;

                public final Tuple3<Object, Object, Object> apply(int x) {
                    return new Tuple3((Object)BoxesRunTime.boxToInteger((int)(x % this.m$1)), (Object)BoxesRunTime.boxToInteger((int)(x / this.m$1)), (Object)BoxesRunTime.boxToDouble((double)this.fullData$1.values()[x]));
                }
                {
                    this.m$1 = m$1;
                    this.fullData$1 = fullData$1;
                }
            }, ClassTag$.MODULE$.apply(Tuple3.class));
            testData.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple3<Object, Object, Object> x) {
                    return new StringBuilder().append(BoxesRunTime.unboxToInt((Object)x._1())).append((Object)",").append(x._2()).append((Object)",").append(x._3()).toString();
                }
            }, ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(outputPath);
        }
        sc.stop();
    }

    private MFDataGenerator$() {
        MODULE$ = this;
    }
}

