/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.util.Random;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.mllib.clustering.BisectingKMeans$;
import org.apache.spark.mllib.clustering.BisectingKMeansModel;
import org.apache.spark.mllib.clustering.ClusteringTreeNode;
import org.apache.spark.mllib.clustering.DistanceMeasure;
import org.apache.spark.mllib.clustering.DistanceMeasure$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\ref\u0001B\u0001\u0003\u00015\u0011qBQ5tK\u000e$\u0018N\\4L\u001b\u0016\fgn\u001d\u0006\u0003\u0007\u0011\t!b\u00197vgR,'/\u001b8h\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011Q\u0003G\u0007\u0002-)\u0011qCB\u0001\tS:$XM\u001d8bY&\u0011\u0011D\u0006\u0002\b\u0019><w-\u001b8h\u0011!Y\u0002A!a\u0001\n\u0013a\u0012!A6\u0016\u0003u\u0001\"a\u0004\u0010\n\u0005}\u0001\"aA%oi\"A\u0011\u0005\u0001BA\u0002\u0013%!%A\u0003l?\u0012*\u0017\u000f\u0006\u0002$MA\u0011q\u0002J\u0005\u0003KA\u0011A!\u00168ji\"9q\u0005IA\u0001\u0002\u0004i\u0012a\u0001=%c!A\u0011\u0006\u0001B\u0001B\u0003&Q$\u0001\u0002lA!A1\u0006\u0001BA\u0002\u0013%A$A\u0007nCbLE/\u001a:bi&|gn\u001d\u0005\t[\u0001\u0011\t\u0019!C\u0005]\u0005\tR.\u0019=Ji\u0016\u0014\u0018\r^5p]N|F%Z9\u0015\u0005\rz\u0003bB\u0014-\u0003\u0003\u0005\r!\b\u0005\tc\u0001\u0011\t\u0011)Q\u0005;\u0005qQ.\u0019=Ji\u0016\u0014\u0018\r^5p]N\u0004\u0003\u0002C\u001a\u0001\u0005\u0003\u0007I\u0011\u0002\u001b\u0002/5Lg\u000eR5wSNL'\r\\3DYV\u001cH/\u001a:TSj,W#A\u001b\u0011\u0005=1\u0014BA\u001c\u0011\u0005\u0019!u.\u001e2mK\"A\u0011\b\u0001BA\u0002\u0013%!(A\u000enS:$\u0015N^5tS\ndWm\u00117vgR,'oU5{K~#S-\u001d\u000b\u0003GmBqa\n\u001d\u0002\u0002\u0003\u0007Q\u0007\u0003\u0005>\u0001\t\u0005\t\u0015)\u00036\u0003ai\u0017N\u001c#jm&\u001c\u0018N\u00197f\u00072,8\u000f^3s'&TX\r\t\u0005\t\u007f\u0001\u0011\t\u0019!C\u0005\u0001\u0006!1/Z3e+\u0005\t\u0005CA\bC\u0013\t\u0019\u0005C\u0001\u0003M_:<\u0007\u0002C#\u0001\u0005\u0003\u0007I\u0011\u0002$\u0002\u0011M,W\rZ0%KF$\"aI$\t\u000f\u001d\"\u0015\u0011!a\u0001\u0003\"A\u0011\n\u0001B\u0001B\u0003&\u0011)A\u0003tK\u0016$\u0007\u0005\u0003\u0005L\u0001\t\u0005\r\u0011\"\u0003M\u0003=!\u0017n\u001d;b]\u000e,W*Z1tkJ,W#A'\u0011\u00059\u000bfBA\bP\u0013\t\u0001\u0006#\u0001\u0004Qe\u0016$WMZ\u0005\u0003%N\u0013aa\u0015;sS:<'B\u0001)\u0011\u0011!)\u0006A!a\u0001\n\u00131\u0016a\u00053jgR\fgnY3NK\u0006\u001cXO]3`I\u0015\fHCA\u0012X\u0011\u001d9C+!AA\u00025C\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006K!T\u0001\u0011I&\u001cH/\u00198dK6+\u0017m];sK\u0002BQa\u0017\u0001\u0005\nq\u000ba\u0001P5oSRtDCB/`A\u0006\u00147\r\u0005\u0002_\u00015\t!\u0001C\u0003\u001c5\u0002\u0007Q\u0004C\u0003,5\u0002\u0007Q\u0004C\u000345\u0002\u0007Q\u0007C\u0003@5\u0002\u0007\u0011\tC\u0003L5\u0002\u0007Q\nC\u0003\\\u0001\u0011\u0005Q\rF\u0001^Q\r!w-\u001c\t\u0003Q.l\u0011!\u001b\u0006\u0003U\u001a\t!\"\u00198o_R\fG/[8o\u0013\ta\u0017NA\u0003TS:\u001cW-I\u0001o\u0003\u0015\tdF\u000e\u00181\u0011\u0015\u0001\b\u0001\"\u0001r\u0003\u0011\u0019X\r^&\u0015\u0005I\u001cX\"\u0001\u0001\t\u000bmy\u0007\u0019A\u000f)\u0007=<W\u000eC\u0003w\u0001\u0011\u0005A$\u0001\u0003hKR\\\u0005fA;h[\")\u0011\u0010\u0001C\u0001u\u0006\u00012/\u001a;NCbLE/\u001a:bi&|gn\u001d\u000b\u0003enDQa\u000b=A\u0002uA3\u0001_4n\u0011\u0015q\b\u0001\"\u0001\u001d\u0003A9W\r^'bq&#XM]1uS>t7\u000fK\u0002~O6Dq!a\u0001\u0001\t\u0003\t)!\u0001\u000etKRl\u0015N\u001c#jm&\u001c\u0018N\u00197f\u00072,8\u000f^3s'&TX\rF\u0002s\u0003\u000fAaaMA\u0001\u0001\u0004)\u0004\u0006BA\u0001O6Da!!\u0004\u0001\t\u0003!\u0014AG4fi6Kg\u000eR5wSNL'\r\\3DYV\u001cH/\u001a:TSj,\u0007\u0006BA\u0006O6Dq!a\u0005\u0001\t\u0003\t)\"A\u0004tKR\u001cV-\u001a3\u0015\u0007I\f9\u0002\u0003\u0004@\u0003#\u0001\r!\u0011\u0015\u0005\u0003#9W\u000e\u0003\u0004\u0002\u001e\u0001!\t\u0001Q\u0001\bO\u0016$8+Z3eQ\u0011\tYbZ7\t\r\u0005\r\u0002\u0001\"\u0001M\u0003I9W\r\u001e#jgR\fgnY3NK\u0006\u001cXO]3)\u000b\u0005\u0005r-a\n\"\u0005\u0005%\u0012!\u0002\u001a/i9\u0002\u0004bBA\u0017\u0001\u0011\u0005\u0011qF\u0001\u0013g\u0016$H)[:uC:\u001cW-T3bgV\u0014X\rF\u0002s\u0003cAaaSA\u0016\u0001\u0004i\u0005&BA\u0016O\u0006\u001d\u0002\u0002CA\u001c\u0001\u0011\u0005a!!\u000f\u0002\u0007I,h\u000e\u0006\u0004\u0002<\u0005\u0005\u0013Q\f\t\u0004=\u0006u\u0012bAA \u0005\t!\")[:fGRLgnZ&NK\u0006t7/T8eK2D\u0001\"a\u0011\u00026\u0001\u0007\u0011QI\u0001\u0006S:\u0004X\u000f\u001e\t\u0007\u0003\u000f\ni%!\u0015\u000e\u0005\u0005%#bAA&\r\u0005\u0019!\u000f\u001a3\n\t\u0005=\u0013\u0011\n\u0002\u0004%\u0012#\u0005\u0003BA*\u00033j!!!\u0016\u000b\u0007\u0005]C!\u0001\u0004mS:\fGnZ\u0005\u0005\u00037\n)F\u0001\u0004WK\u000e$xN\u001d\u0005\t\u0003?\n)\u00041\u0001\u0002b\u0005)\u0011N\\:ueB)q\"a\u0019\u0002h%\u0019\u0011Q\r\t\u0003\r=\u0003H/[8o!\u0011\tI'a\u001d\u000e\u0005\u0005-$\u0002BA7\u0003_\nA!\u001e;jY*\u0019\u0011\u0011\u000f\u0004\u0002\u00055d\u0017\u0002BA;\u0003W\u0012q\"\u00138tiJ,X.\u001a8uCRLwN\u001c\u0005\b\u0003o\u0001A\u0011AA=)\u0011\tY$a\u001f\t\u0011\u0005\r\u0013q\u000fa\u0001\u0003\u000bBC!a\u001eh[\"9\u0011q\u0007\u0001\u0005\u0002\u0005\u0005E\u0003BA\u001e\u0003\u0007C\u0001\"!\"\u0002\u0000\u0001\u0007\u0011qQ\u0001\u0005I\u0006$\u0018\r\u0005\u0004\u0002\n\u0006M\u0015\u0011K\u0007\u0003\u0003\u0017SA!!$\u0002\u0010\u0006!!.\u0019<b\u0015\r\t\tJB\u0001\u0004CBL\u0017\u0002BAK\u0003\u0017\u0013qAS1wCJ#E\tK\u0002\u0001O6<q!a'\u0003\u0011\u0013\ti*A\bCSN,7\r^5oO.kU-\u00198t!\rq\u0016q\u0014\u0004\u0007\u0003\tAI!!)\u0014\u000b\u0005}e\"a)\u0011\u0007=\t)+C\u0002\u0002(B\u0011AbU3sS\u0006d\u0017N_1cY\u0016DqaWAP\t\u0003\tY\u000b\u0006\u0002\u0002\u001e\"I\u0011qVAP\u0005\u0004%I\u0001Q\u0001\u000b%>{EkX%O\t\u0016C\u0006\u0002CAZ\u0003?\u0003\u000b\u0011B!\u0002\u0017I{u\nV0J\u001d\u0012+\u0005\f\t\u0005\n\u0003o\u000byJ1A\u0005\n\u0001\u000b1$T!Y?\u0012Ke+S*J\u00052+ul\u0011'V'R+%kX%O\t\u0016C\u0006\u0002CA^\u0003?\u0003\u000b\u0011B!\u000295\u000b\u0005l\u0018#J-&\u001b\u0016J\u0011'F?\u000ecUk\u0015+F%~Ke\nR#YA!I\u0011qXAP\u0005\u0004%I\u0001N\u0001\f\u0019\u00163V\tT0M\u00136KE\u000b\u0003\u0005\u0002D\u0006}\u0005\u0015!\u00036\u00031aUIV#M?2KU*\u0013+!\u0011!\t9-a(\u0005\n\u0005%\u0017A\u00047fMR\u001c\u0005.\u001b7e\u0013:$W\r\u001f\u000b\u0004\u0003\u0006-\u0007bBAg\u0003\u000b\u0004\r!Q\u0001\u0006S:$W\r\u001f\u0005\t\u0003#\fy\n\"\u0003\u0002T\u0006y!/[4ii\u000eC\u0017\u000e\u001c3J]\u0012,\u0007\u0010F\u0002B\u0003+Dq!!4\u0002P\u0002\u0007\u0011\t\u0003\u0005\u0002Z\u0006}E\u0011BAn\u0003-\u0001\u0018M]3oi&sG-\u001a=\u0015\u0007\u0005\u000bi\u000eC\u0004\u0002N\u0006]\u0007\u0019A!\t\u0011\u0005\u0005\u0018q\u0014C\u0005\u0003G\f\u0011b];n[\u0006\u0014\u0018N_3\u0015\u0011\u0005\u0015(\u0011\u0017B[\u0005\u0003\u0004bATAt\u0003\u0006-\u0018bAAu'\n\u0019Q*\u00199\u0011\t\u00055\u0018q^\u0007\u0003\u0003?3q!!=\u0002 \u0012\u000b\u0019P\u0001\bDYV\u001cH/\u001a:Tk6l\u0017M]=\u0014\u000f\u0005=h\"!>\u0002$B\u0019q\"a>\n\u0007\u0005e\bCA\u0004Qe>$Wo\u0019;\t\u0015\u0005u\u0018q\u001eBK\u0002\u0013\u0005\u0001)\u0001\u0003tSj,\u0007B\u0003B\u0001\u0003_\u0014\t\u0012)A\u0005\u0003\u0006)1/\u001b>fA!Y!QAAx\u0005+\u0007I\u0011\u0001B\u0004\u0003\u0019\u0019WM\u001c;feV\u0011!\u0011\u0002\t\u0004=\n-\u0011b\u0001B\u0007\u0005\tqa+Z2u_J<\u0016\u000e\u001e5O_Jl\u0007b\u0003B\t\u0003_\u0014\t\u0012)A\u0005\u0005\u0013\tqaY3oi\u0016\u0014\b\u0005\u0003\u0006\u0003\u0016\u0005=(Q3A\u0005\u0002Q\nAaY8ti\"Q!\u0011DAx\u0005#\u0005\u000b\u0011B\u001b\u0002\u000b\r|7\u000f\u001e\u0011\t\u000fm\u000by\u000f\"\u0001\u0003\u001eQA\u00111\u001eB\u0010\u0005C\u0011\u0019\u0003C\u0004\u0002~\nm\u0001\u0019A!\t\u0011\t\u0015!1\u0004a\u0001\u0005\u0013AqA!\u0006\u0003\u001c\u0001\u0007Q\u0007\u0003\u0006\u0003(\u0005=\u0018\u0011!C\u0001\u0005S\tAaY8qsRA\u00111\u001eB\u0016\u0005[\u0011y\u0003C\u0005\u0002~\n\u0015\u0002\u0013!a\u0001\u0003\"Q!Q\u0001B\u0013!\u0003\u0005\rA!\u0003\t\u0013\tU!Q\u0005I\u0001\u0002\u0004)\u0004B\u0003B\u001a\u0003_\f\n\u0011\"\u0001\u00036\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B\u001cU\r\t%\u0011H\u0016\u0003\u0005w\u0001BA!\u0010\u0003F5\u0011!q\b\u0006\u0005\u0005\u0003\u0012\u0019%A\u0005v]\u000eDWmY6fI*\u0011!\u000eE\u0005\u0005\u0005\u000f\u0012yDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!Ba\u0013\u0002pF\u0005I\u0011\u0001B'\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"Aa\u0014+\t\t%!\u0011\b\u0005\u000b\u0005'\ny/%A\u0005\u0002\tU\u0013AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0005/R3!\u000eB\u001d\u0011)\u0011Y&a<\u0002\u0002\u0013\u0005#QL\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t}\u0003\u0003\u0002B1\u0005Sj!Aa\u0019\u000b\t\t\u0015$qM\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u000e&\u0019!Ka\u0019\t\u0013\t5\u0014q^A\u0001\n\u0003a\u0012\u0001\u00049s_\u0012,8\r^!sSRL\bB\u0003B9\u0003_\f\t\u0011\"\u0001\u0003t\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B;\u0005w\u00022a\u0004B<\u0013\r\u0011I\b\u0005\u0002\u0004\u0003:L\b\u0002C\u0014\u0003p\u0005\u0005\t\u0019A\u000f\t\u0015\t}\u0014q^A\u0001\n\u0003\u0012\t)A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011\u0019\t\u0005\u0004\u0003\u0006\n-%QO\u0007\u0003\u0005\u000fS1A!#\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u001b\u00139I\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011)\u0011\t*a<\u0002\u0002\u0013\u0005!1S\u0001\tG\u0006tW)];bYR!!Q\u0013BN!\ry!qS\u0005\u0004\u00053\u0003\"a\u0002\"p_2,\u0017M\u001c\u0005\nO\t=\u0015\u0011!a\u0001\u0005kB!Ba(\u0002p\u0006\u0005I\u0011\tBQ\u0003!A\u0017m\u001d5D_\u0012,G#A\u000f\t\u0015\t\u0015\u0016q^A\u0001\n\u0003\u00129+\u0001\u0005u_N#(/\u001b8h)\t\u0011y\u0006\u0003\u0006\u0003,\u0006=\u0018\u0011!C!\u0005[\u000ba!Z9vC2\u001cH\u0003\u0002BK\u0005_C\u0011b\nBU\u0003\u0003\u0005\rA!\u001e\t\u000f\tM\u0016q\u001ca\u0001;\u0005\tA\r\u0003\u0005\u00038\u0006}\u0007\u0019\u0001B]\u0003-\t7o]5h]6,g\u000e^:\u0011\r\u0005\u001d\u0013Q\nB^!\u0019y!QX!\u0003\n%\u0019!q\u0018\t\u0003\rQ+\b\u000f\\33\u0011\u001dY\u0015q\u001ca\u0001\u0005\u0007\u00042A\u0018Bc\u0013\r\u00119M\u0001\u0002\u0010\t&\u001cH/\u00198dK6+\u0017m];sK\u001a9!1ZAP\t\t5'\u0001G\"mkN$XM]*v[6\f'/_!hOJ,w-\u0019;peN)!\u0011\u001a\b\u0002$\"Q!1\u0017Be\u0005\u000b\u0007I\u0011\u0001\u000f\t\u0015\tM'\u0011\u001aB\u0001B\u0003%Q$\u0001\u0002eA!Q1J!3\u0003\u0006\u0004%\tAa6\u0016\u0005\t\r\u0007BC-\u0003J\n\u0005\t\u0015!\u0003\u0003D\"91L!3\u0005\u0002\tuGC\u0002Bp\u0005C\u0014\u0019\u000f\u0005\u0003\u0002n\n%\u0007b\u0002BZ\u00057\u0004\r!\b\u0005\b\u0017\nm\u0007\u0019\u0001Bb\u0011%\u00119O!3A\u0002\u0013%\u0001)A\u0001o\u0011)\u0011YO!3A\u0002\u0013%!Q^\u0001\u0006]~#S-\u001d\u000b\u0004G\t=\b\u0002C\u0014\u0003j\u0006\u0005\t\u0019A!\t\u0011\tM(\u0011\u001aQ!\n\u0005\u000b!A\u001c\u0011\t\u0015\t](\u0011\u001ab\u0001\n\u0013\u0011I0A\u0002tk6,\"!!\u0015\t\u0013\tu(\u0011\u001aQ\u0001\n\u0005E\u0013\u0001B:v[\u0002B\u0011b!\u0001\u0003J\u0002\u0007I\u0011\u0002\u001b\u0002\u000bM,XnU9\t\u0015\r\u0015!\u0011\u001aa\u0001\n\u0013\u00199!A\u0005tk6\u001c\u0016o\u0018\u0013fcR\u00191e!\u0003\t\u0011\u001d\u001a\u0019!!AA\u0002UB\u0001b!\u0004\u0003J\u0002\u0006K!N\u0001\u0007gVl7+\u001d\u0011\t\u0011\rE!\u0011\u001aC\u0001\u0007'\t1!\u00193e)\u0011\u0019)ba\u0006\u000e\u0005\t%\u0007\u0002CB\r\u0007\u001f\u0001\rA!\u0003\u0002\u0003YD\u0001b!\b\u0003J\u0012\u00051qD\u0001\u0006[\u0016\u0014x-\u001a\u000b\u0005\u0007+\u0019\t\u0003\u0003\u0005\u0004$\rm\u0001\u0019\u0001Bp\u0003\u0015yG\u000f[3s\u0011!\u00199C!3\u0005\u0002\r%\u0012aB:v[6\f'/_\u000b\u0003\u0003WD\u0001b!\f\u0002 \u0012%1qF\u0001\fgBd\u0017\u000e^\"f]R,'\u000f\u0006\u0005\u00042\rM2QGB\"!\u001dy!Q\u0018B\u0005\u0005\u0013A\u0001B!\u0002\u0004,\u0001\u0007!\u0011\u0002\u0005\t\u0007o\u0019Y\u00031\u0001\u0004:\u00051!/\u00198e_6\u0004Baa\u000f\u0004@5\u00111Q\b\u0006\u0005\u0003[\u00129'\u0003\u0003\u0004B\ru\"A\u0002*b]\u0012|W\u000eC\u0004L\u0007W\u0001\rAa1\t\u0011\r\u001d\u0013q\u0014C\u0005\u0007\u0013\n\u0011#\u001e9eCR,\u0017i]:jO:lWM\u001c;t))\u0011Ila\u0013\u0004N\r]3Q\f\u0005\t\u0005o\u001b)\u00051\u0001\u0003:\"A1qJB#\u0001\u0004\u0019\t&\u0001\teSZL7/\u001b2mK&sG-[2fgB!aja\u0015B\u0013\r\u0019)f\u0015\u0002\u0004'\u0016$\b\u0002CB-\u0007\u000b\u0002\raa\u0017\u0002#9,wo\u00117vgR,'oQ3oi\u0016\u00148\u000f\u0005\u0004O\u0003O\f%\u0011\u0002\u0005\b\u0017\u000e\u0015\u0003\u0019\u0001Bb\u0011!\u0019\t'a(\u0005\n\r\r\u0014!\u00032vS2$GK]3f)\u0019\u0019)ga\u001b\u0004pA\u0019ala\u001a\n\u0007\r%$A\u0001\nDYV\u001cH/\u001a:j]\u001e$&/Z3O_\u0012,\u0007\u0002CB7\u0007?\u0002\r!!:\u0002\u0011\rdWo\u001d;feNDqaSB0\u0001\u0004\u0011\u0019m\u0002\u0006\u0004t\u0005}\u0015\u0011!E\u0005\u0007k\nab\u00117vgR,'oU;n[\u0006\u0014\u0018\u0010\u0005\u0003\u0002n\u000e]dACAy\u0003?\u000b\t\u0011#\u0003\u0004zM11qOB>\u0003G\u0003\"b! \u0004\u0004\u0006\u0013I!NAv\u001b\t\u0019yHC\u0002\u0004\u0002B\tqA];oi&lW-\u0003\u0003\u0004\u0006\u000e}$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8og!91la\u001e\u0005\u0002\r%ECAB;\u0011)\u0011)ka\u001e\u0002\u0002\u0013\u0015#q\u0015\u0005\u000b\u0007\u001f\u001b9(!A\u0005\u0002\u000eE\u0015!B1qa2LH\u0003CAv\u0007'\u001b)ja&\t\u000f\u0005u8Q\u0012a\u0001\u0003\"A!QABG\u0001\u0004\u0011I\u0001C\u0004\u0003\u0016\r5\u0005\u0019A\u001b\t\u0015\rm5qOA\u0001\n\u0003\u001bi*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r}5q\u0015\t\u0006\u001f\u0005\r4\u0011\u0015\t\b\u001f\r\r\u0016I!\u00036\u0013\r\u0019)\u000b\u0005\u0002\u0007)V\u0004H.Z\u001a\t\u0015\r%6\u0011TA\u0001\u0002\u0004\tY/A\u0002yIAB!b!,\u0004x\u0005\u0005I\u0011BBX\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\rE\u0006\u0003\u0002B1\u0007gKAa!.\u0003d\t1qJ\u00196fGRD!b!,\u0002 \u0006\u0005I\u0011BBX\u0001")
public class BisectingKMeans
implements Logging {
    private int k;
    private int maxIterations;
    private double minDivisibleClusterSize;
    private long seed;
    private String distanceMeasure;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private int k() {
        return this.k;
    }

    private void k_$eq(int x$1) {
        this.k = x$1;
    }

    private int maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(int x$1) {
        this.maxIterations = x$1;
    }

    private double minDivisibleClusterSize() {
        return this.minDivisibleClusterSize;
    }

    private void minDivisibleClusterSize_$eq(double x$1) {
        this.minDivisibleClusterSize = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    private String distanceMeasure() {
        return this.distanceMeasure;
    }

    private void distanceMeasure_$eq(String x$1) {
        this.distanceMeasure = x$1;
    }

    public BisectingKMeans setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0)new Serializable(this, k){
            public static final long serialVersionUID = 0L;
            private final int k$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k must be positive but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$1)}));
            }
            {
                this.k$1 = k$1;
            }
        });
        this.k_$eq(k);
        return this;
    }

    public int getK() {
        return this.k();
    }

    public BisectingKMeans setMaxIterations(int maxIterations) {
        Predef$.MODULE$.require(maxIterations > 0, (Function0)new Serializable(this, maxIterations){
            public static final long serialVersionUID = 0L;
            private final int maxIterations$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxIterations must be positive but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxIterations$1)}));
            }
            {
                this.maxIterations$1 = maxIterations$1;
            }
        });
        this.maxIterations_$eq(maxIterations);
        return this;
    }

    public int getMaxIterations() {
        return this.maxIterations();
    }

    public BisectingKMeans setMinDivisibleClusterSize(double minDivisibleClusterSize) {
        Predef$.MODULE$.require(minDivisibleClusterSize > 0.0, (Function0)new Serializable(this, minDivisibleClusterSize){
            public static final long serialVersionUID = 0L;
            private final double minDivisibleClusterSize$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"minDivisibleClusterSize must be positive but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.minDivisibleClusterSize$1)}));
            }
            {
                this.minDivisibleClusterSize$1 = minDivisibleClusterSize$1;
            }
        });
        this.minDivisibleClusterSize_$eq(minDivisibleClusterSize);
        return this;
    }

    public double getMinDivisibleClusterSize() {
        return this.minDivisibleClusterSize();
    }

    public BisectingKMeans setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public long getSeed() {
        return this.seed();
    }

    public String getDistanceMeasure() {
        return this.distanceMeasure();
    }

    public BisectingKMeans setDistanceMeasure(String distanceMeasure) {
        DistanceMeasure$.MODULE$.validateDistanceMeasure(distanceMeasure);
        this.distanceMeasure_$eq(distanceMeasure);
        return this;
    }

    public BisectingKMeansModel run(RDD<Vector> input, Option<Instrumentation> instr) {
        StorageLevel storageLevel = input.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)new Serializable(this, input){
                public static final long serialVersionUID = 0L;
                private final RDD input$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The input RDD ", " is not directly cached, which may hurt performance if"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.input$1.id())}))).append((Object)" its parent RDDs are also not cached.").toString();
                }
                {
                    this.input$1 = input$1;
                }
            });
        }
        int d = BoxesRunTime.unboxToInt((Object)input.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Vector x$1) {
                return x$1.size();
            }
        }, ClassTag$.MODULE$.Int()).first());
        this.logInfo((Function0<String>)new Serializable(this, d){
            public static final long serialVersionUID = 0L;
            private final int d$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Feature dimension: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.d$1)}));
            }
            {
                this.d$1 = d$1;
            }
        });
        DistanceMeasure dMeasure = DistanceMeasure$.MODULE$.decodeFromString(this.distanceMeasure());
        RDD norms = input.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Vector v) {
                return Vectors$.MODULE$.norm(v, 2.0);
            }
        }, ClassTag$.MODULE$.Double()).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        RDD vectors = input.zip(norms, ClassTag$.MODULE$.Double()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final VectorWithNorm apply(Tuple2<Vector, Object> x0$1) {
                Tuple2<Vector, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Vector x = (Vector)tuple2._1();
                    double norm2 = tuple2._2$mcD$sp();
                    VectorWithNorm vectorWithNorm = new VectorWithNorm(x, norm2);
                    return vectorWithNorm;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(VectorWithNorm.class));
        ObjectRef assignments = ObjectRef.create((Object)vectors.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, VectorWithNorm> apply(VectorWithNorm v) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$ROOT_INDEX()), (Object)v);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)));
        ObjectRef activeClusters = ObjectRef.create(BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$summarize(d, (RDD<Tuple2<Object, VectorWithNorm>>)((RDD)assignments.elem), dMeasure));
        instr.foreach((Function1)new Serializable(this, activeClusters){
            public static final long serialVersionUID = 0L;
            private final ObjectRef activeClusters$1;

            public final void apply(Instrumentation x$2) {
                x$2.logNumExamples(BoxesRunTime.unboxToLong((Object)((TraversableOnce)((Map)this.activeClusters$1.elem).values().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(ClusterSummary x$3) {
                        return x$3.size();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            }
            {
                this.activeClusters$1 = activeClusters$1;
            }
        });
        ClusterSummary rootSummary = (ClusterSummary)((Map)activeClusters.elem).apply((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$ROOT_INDEX()));
        long n = rootSummary.size();
        this.logInfo((Function0<String>)new Serializable(this, n){
            public static final long serialVersionUID = 0L;
            private final long n$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of points: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.n$1)}));
            }
            {
                this.n$1 = n$1;
            }
        });
        this.logInfo((Function0<String>)new Serializable(this, rootSummary){
            public static final long serialVersionUID = 0L;
            private final ClusterSummary rootSummary$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initial cost: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.rootSummary$1.cost())}));
            }
            {
                this.rootSummary$1 = rootSummary$1;
            }
        });
        long minSize = this.minDivisibleClusterSize() >= 1.0 ? (long)scala.math.package$.MODULE$.ceil(this.minDivisibleClusterSize()) : (long)scala.math.package$.MODULE$.ceil(this.minDivisibleClusterSize() * (double)n);
        this.logInfo((Function0<String>)new Serializable(this, minSize){
            public static final long serialVersionUID = 0L;
            private final long minSize$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The minimum number of points of a divisible cluster is ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.minSize$1)}));
            }
            {
                this.minSize$1 = minSize$1;
            }
        });
        scala.collection.mutable.Seq inactiveClusters = (scala.collection.mutable.Seq)Seq$.MODULE$.empty();
        Random random = new Random(this.seed());
        int numLeafClustersNeeded = this.k() - 1;
        IntRef level = IntRef.create((int)1);
        RDD preIndices = null;
        RDD indices = null;
        while (((Map)activeClusters.elem).nonEmpty() && numLeafClustersNeeded > 0 && (double)level.elem < BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$LEVEL_LIMIT()) {
            Map divisibleClusters = (Map)((Map)activeClusters.elem).filter((Function1)new Serializable(this, minSize){
                public static final long serialVersionUID = 0L;
                private final long minSize$1;

                public final boolean apply(Tuple2<Object, ClusterSummary> x0$2) {
                    Tuple2<Object, ClusterSummary> tuple2 = x0$2;
                    if (tuple2 != null) {
                        ClusterSummary summary2 = (ClusterSummary)tuple2._2();
                        boolean bl = summary2.size() >= this.minSize$1 && summary2.cost() > MLUtils$.MODULE$.EPSILON() * (double)summary2.size();
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.minSize$1 = minSize$1;
                }
            });
            if (divisibleClusters.size() > numLeafClustersNeeded) {
                divisibleClusters = ((TraversableOnce)((IterableLike)divisibleClusters.toSeq().sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Tuple2<Object, ClusterSummary> x0$3) {
                        Tuple2<Object, ClusterSummary> tuple2 = x0$3;
                        if (tuple2 != null) {
                            ClusterSummary summary2 = (ClusterSummary)tuple2._2();
                            long l = -summary2.size();
                            return l;
                        }
                        throw new MatchError(tuple2);
                    }
                }, (Ordering)Ordering.Long$.MODULE$)).take(numLeafClustersNeeded)).toMap(Predef$.MODULE$.$conforms());
            }
            if (divisibleClusters.nonEmpty()) {
                Set divisibleIndices = divisibleClusters.keys().toSet();
                this.logInfo((Function0<String>)new Serializable(this, level, divisibleIndices){
                    public static final long serialVersionUID = 0L;
                    private final IntRef level$1;
                    private final Set divisibleIndices$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dividing ", " clusters on level ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.divisibleIndices$1.size()), BoxesRunTime.boxToInteger((int)this.level$1.elem)}));
                    }
                    {
                        this.level$1 = level$1;
                        this.divisibleIndices$1 = divisibleIndices$1;
                    }
                });
                ObjectRef newClusterCenters = ObjectRef.create((Object)((Map)((TraversableLike)divisibleClusters.flatMap((Function1)new Serializable(this, dMeasure, random){
                    public static final long serialVersionUID = 0L;
                    private final DistanceMeasure dMeasure$1;
                    private final Random random$1;

                    public final Iterator<Tuple2<Object, VectorWithNorm>> apply(Tuple2<Object, ClusterSummary> x0$4) {
                        Tuple2<Object, ClusterSummary> tuple2 = x0$4;
                        if (tuple2 != null) {
                            long index2 = tuple2._1$mcJ$sp();
                            ClusterSummary summary2 = (ClusterSummary)tuple2._2();
                            Tuple2<VectorWithNorm, VectorWithNorm> tuple22 = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$splitCenter(summary2.center(), this.random$1, this.dMeasure$1);
                            if (tuple22 != null) {
                                Tuple2 tuple23;
                                VectorWithNorm left = (VectorWithNorm)tuple22._1();
                                VectorWithNorm right = (VectorWithNorm)tuple22._2();
                                Tuple2 tuple24 = tuple23 = new Tuple2((Object)left, (Object)right);
                                VectorWithNorm left2 = (VectorWithNorm)tuple24._1();
                                VectorWithNorm right2 = (VectorWithNorm)tuple24._2();
                                Iterator iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$leftChildIndex(index2)), (Object)left2), new Tuple2((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$rightChildIndex(index2)), (Object)right2)}));
                                return iterator;
                            }
                            throw new MatchError(tuple22);
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.dMeasure$1 = dMeasure$1;
                        this.random$1 = random$1;
                    }
                }, Map$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, VectorWithNorm> apply(Tuple2<Object, VectorWithNorm> x) {
                        return (Tuple2)Predef$.MODULE$.identity(x);
                    }
                }, Map$.MODULE$.canBuildFrom())));
                ObjectRef newClusters = ObjectRef.create(null);
                ObjectRef newAssignments = ObjectRef.create(null);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.maxIterations()).foreach$mVc$sp((Function1)new Serializable(this, d, dMeasure, assignments, divisibleIndices, newClusterCenters, newClusters, newAssignments){
                    public static final long serialVersionUID = 0L;
                    private final int d$1;
                    private final DistanceMeasure dMeasure$1;
                    private final ObjectRef assignments$1;
                    public final Set divisibleIndices$1;
                    private final ObjectRef newClusterCenters$1;
                    private final ObjectRef newClusters$1;
                    private final ObjectRef newAssignments$1;

                    public final void apply(int iter) {
                        this.apply$mcVI$sp(iter);
                    }

                    public void apply$mcVI$sp(int iter) {
                        this.newAssignments$1.elem = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$updateAssignments((RDD<Tuple2<Object, VectorWithNorm>>)((RDD)this.assignments$1.elem), (Set<Object>)this.divisibleIndices$1, (Map<Object, VectorWithNorm>)((Map)this.newClusterCenters$1.elem), this.dMeasure$1).filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$run$1 $outer;

                            public final boolean apply(Tuple2<Object, VectorWithNorm> x0$5) {
                                Tuple2<Object, VectorWithNorm> tuple2 = x0$5;
                                if (tuple2 != null) {
                                    long index2 = tuple2._1$mcJ$sp();
                                    boolean bl = this.$outer.divisibleIndices$1.contains((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$parentIndex(index2)));
                                    return bl;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.newClusters$1.elem = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$summarize(this.d$1, (RDD<Tuple2<Object, VectorWithNorm>>)((RDD)this.newAssignments$1.elem), this.dMeasure$1);
                        this.newClusterCenters$1.elem = (Map)((Map)this.newClusters$1.elem).mapValues((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final VectorWithNorm apply(ClusterSummary x$5) {
                                return x$5.center();
                            }
                        }).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, VectorWithNorm> apply(Tuple2<Object, VectorWithNorm> x) {
                                return (Tuple2)Predef$.MODULE$.identity(x);
                            }
                        }, Map$.MODULE$.canBuildFrom());
                    }
                    {
                        this.d$1 = d$1;
                        this.dMeasure$1 = dMeasure$1;
                        this.assignments$1 = assignments$1;
                        this.divisibleIndices$1 = divisibleIndices$1;
                        this.newClusterCenters$1 = newClusterCenters$1;
                        this.newClusters$1 = newClusters$1;
                        this.newAssignments$1 = newAssignments$1;
                    }
                });
                Object object = preIndices == null ? BoxedUnit.UNIT : preIndices.unpersist(false);
                preIndices = indices;
                indices = RDD$.MODULE$.rddToPairRDDFunctions(BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$updateAssignments((RDD<Tuple2<Object, VectorWithNorm>>)((RDD)assignments.elem), (Set<Object>)divisibleIndices, (Map<Object, VectorWithNorm>)((Map)newClusterCenters.elem), dMeasure), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(VectorWithNorm.class), (Ordering)Ordering.Long$.MODULE$).keys().persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
                assignments.elem = indices.zip(vectors, ClassTag$.MODULE$.apply(VectorWithNorm.class));
                inactiveClusters = (scala.collection.mutable.Seq)inactiveClusters.$plus$plus((GenTraversableOnce)((Map)activeClusters.elem), Seq$.MODULE$.canBuildFrom());
                activeClusters.elem = (Map)newClusters.elem;
                numLeafClustersNeeded -= divisibleClusters.size();
            } else {
                this.logInfo((Function0<String>)new Serializable(this, level){
                    public static final long serialVersionUID = 0L;
                    private final IntRef level$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"None active and divisible clusters left on level ", ". Stop iterations."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.level$1.elem)}));
                    }
                    {
                        this.level$1 = level$1;
                    }
                });
                inactiveClusters = (scala.collection.mutable.Seq)inactiveClusters.$plus$plus((GenTraversableOnce)((Map)activeClusters.elem), Seq$.MODULE$.canBuildFrom());
                activeClusters.elem = Predef$.MODULE$.Map().empty();
            }
            ++level.elem;
        }
        Object object = preIndices == null ? BoxedUnit.UNIT : preIndices.unpersist(false);
        Object object2 = indices == null ? BoxedUnit.UNIT : indices.unpersist(false);
        norms.unpersist(false);
        Map clusters = ((Map)activeClusters.elem).$plus$plus((GenTraversableOnce)inactiveClusters);
        ClusteringTreeNode root = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$buildTree((Map<Object, ClusterSummary>)clusters, dMeasure);
        return new BisectingKMeansModel(root, this.distanceMeasure());
    }

    public BisectingKMeansModel run(RDD<Vector> input) {
        return this.run(input, (Option<Instrumentation>)None$.MODULE$);
    }

    public BisectingKMeansModel run(JavaRDD<Vector> data) {
        return this.run((RDD<Vector>)data.rdd());
    }

    private BisectingKMeans(int k, int maxIterations, double minDivisibleClusterSize, long seed, String distanceMeasure) {
        this.k = k;
        this.maxIterations = maxIterations;
        this.minDivisibleClusterSize = minDivisibleClusterSize;
        this.seed = seed;
        this.distanceMeasure = distanceMeasure;
        Logging.class.$init$((Logging)this);
    }

    public BisectingKMeans() {
        this(4, 20, 1.0, ScalaRunTime$.MODULE$.hash((Object)BisectingKMeans.class.getName()), DistanceMeasure$.MODULE$.EUCLIDEAN());
    }

    public static class ClusterSummary
    implements Product,
    Serializable {
        private final long size;
        private final VectorWithNorm center;
        private final double cost;

        public long size() {
            return this.size;
        }

        public VectorWithNorm center() {
            return this.center;
        }

        public double cost() {
            return this.cost;
        }

        public ClusterSummary copy(long size, VectorWithNorm center, double cost) {
            return new ClusterSummary(size, center, cost);
        }

        public long copy$default$1() {
            return this.size();
        }

        public VectorWithNorm copy$default$2() {
            return this.center();
        }

        public double copy$default$3() {
            return this.cost();
        }

        public String productPrefix() {
            return "ClusterSummary";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    object = BoxesRunTime.boxToDouble((double)this.cost());
                    break;
                }
                case 1: {
                    object = this.center();
                    break;
                }
                case 0: {
                    object = BoxesRunTime.boxToLong((long)this.size());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ClusterSummary;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.size()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.center()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.cost()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ClusterSummary)) return false;
            boolean bl = true;
            if (!bl) return false;
            ClusterSummary clusterSummary = (ClusterSummary)x$1;
            if (this.size() != clusterSummary.size()) return false;
            VectorWithNorm vectorWithNorm = this.center();
            VectorWithNorm vectorWithNorm2 = clusterSummary.center();
            if (vectorWithNorm == null) {
                if (vectorWithNorm2 != null) {
                    return false;
                }
            } else if (!vectorWithNorm.equals(vectorWithNorm2)) return false;
            if (this.cost() != clusterSummary.cost()) return false;
            if (!clusterSummary.canEqual(this)) return false;
            return true;
        }

        public ClusterSummary(long size, VectorWithNorm center, double cost) {
            this.size = size;
            this.center = center;
            this.cost = cost;
            Product.class.$init$((Product)this);
        }
    }

    public static class ClusterSummaryAggregator
    implements Serializable {
        private final int d;
        private final DistanceMeasure distanceMeasure;
        private long n;
        private final Vector sum;
        private double sumSq;

        public int d() {
            return this.d;
        }

        public DistanceMeasure distanceMeasure() {
            return this.distanceMeasure;
        }

        private long n() {
            return this.n;
        }

        private void n_$eq(long x$1) {
            this.n = x$1;
        }

        private Vector sum() {
            return this.sum;
        }

        private double sumSq() {
            return this.sumSq;
        }

        private void sumSq_$eq(double x$1) {
            this.sumSq = x$1;
        }

        public ClusterSummaryAggregator add(VectorWithNorm v) {
            this.n_$eq(this.n() + 1L);
            this.sumSq_$eq(this.sumSq() + v.norm() * v.norm());
            this.distanceMeasure().updateClusterSum(v, this.sum());
            return this;
        }

        public ClusterSummaryAggregator merge(ClusterSummaryAggregator other) {
            this.n_$eq(this.n() + other.n());
            this.sumSq_$eq(this.sumSq() + other.sumSq());
            this.distanceMeasure().updateClusterSum(new VectorWithNorm(other.sum()), this.sum());
            return this;
        }

        public ClusterSummary summary() {
            VectorWithNorm center = this.distanceMeasure().centroid(this.sum().copy(), this.n());
            double cost = this.distanceMeasure().clusterCost(center, new VectorWithNorm(this.sum()), this.n(), this.sumSq());
            return new ClusterSummary(this.n(), center, cost);
        }

        public ClusterSummaryAggregator(int d, DistanceMeasure distanceMeasure) {
            this.d = d;
            this.distanceMeasure = distanceMeasure;
            this.n = 0L;
            this.sum = Vectors$.MODULE$.zeros(d);
            this.sumSq = 0.0;
        }
    }
}

