/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.PredictorParams$class;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasSolver$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.param.shared.HasWeightCol$class;
import org.apache.spark.ml.regression.GeneralizedLinearRegression;
import org.apache.spark.ml.regression.GeneralizedLinearRegression$FamilyAndLink$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionBase;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionBase$class;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionSummary;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionTrainingSummary;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\r-c\u0001B\u0001\u0003\u00015\u0011\u0001eR3oKJ\fG.\u001b>fI2Kg.Z1s%\u0016<'/Z:tS>tWj\u001c3fY*\u00111\u0001B\u0001\u000be\u0016<'/Z:tS>t'BA\u0003\u0007\u0003\tiGN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u001a9A!q\u0002\u0005\n\u0019\u001b\u0005\u0011\u0011BA\t\u0003\u0005=\u0011Vm\u001a:fgNLwN\\'pI\u0016d\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\u0019a\u0017N\\1mO&\u0011q\u0003\u0006\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u0005=\u0001\u0001CA\b\u001b\u0013\tY\"AA\u0010HK:,'/\u00197ju\u0016$G*\u001b8fCJ\u0014Vm\u001a:fgNLwN\u001c\"bg\u0016\u0004\"!\b\u0011\u000e\u0003yQ!a\b\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003Cy\u0011!\"\u0014'Xe&$\u0018M\u00197f\u0011!\u0019\u0003A!b\u0001\n\u0003\"\u0013aA;jIV\tQ\u0005\u0005\u0002'Y9\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\u00051\u0001K]3eK\u001aL!!\f\u0018\u0003\rM#(/\u001b8h\u0015\tY\u0003\u0006K\u0002#aY\u0002\"!\r\u001b\u000e\u0003IR!a\r\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u00026e\t)1+\u001b8dK\u0006\nq'A\u00033]Ar\u0003\u0007\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003&\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007a\u0002d\u0007\u0003\u0005=\u0001\t\u0015\r\u0011\"\u0001>\u00031\u0019w.\u001a4gS\u000eLWM\u001c;t+\u0005\u0011\u0002fA\u001e1m!A\u0001\t\u0001B\u0001B\u0003%!#A\u0007d_\u00164g-[2jK:$8\u000f\t\u0015\u0004\u007fA2\u0004\u0002C\"\u0001\u0005\u000b\u0007I\u0011\u0001#\u0002\u0013%tG/\u001a:dKB$X#A#\u0011\u0005\u001d2\u0015BA$)\u0005\u0019!u.\u001e2mK\"\u001a!\t\r\u001c\t\u0011)\u0003!\u0011!Q\u0001\n\u0015\u000b!\"\u001b8uKJ\u001cW\r\u001d;!Q\rI\u0005G\u000e\u0005\u0007\u001b\u0002!\t\u0001\u0002(\u0002\rqJg.\u001b;?)\u0011Ar*U*\t\u000b\rb\u0005\u0019A\u0013)\u0007=\u0003d\u0007C\u0003=\u0019\u0002\u0007!\u0003K\u0002RaYBQa\u0011'A\u0002\u0015C3a\u0015\u00197\u0011\u00151\u0006\u0001\"\u0001X\u0003Q\u0019X\r\u001e'j].\u0004&/\u001a3jGRLwN\\\"pYR\u0011\u0001,W\u0007\u0002\u0001!)!,\u0016a\u0001K\u0005)a/\u00197vK\"\u001aQ\u000b\r\u001c\t\u0011u\u0003\u0001R1A\u0005\ny\u000bQBZ1nS2L\u0018I\u001c3MS:\\W#A0\u0011\u0005\u0001\u001cgBA\bb\u0013\t\u0011'!A\u000eHK:,'/\u00197ju\u0016$G*\u001b8fCJ\u0014Vm\u001a:fgNLwN\\\u0005\u0003I\u0016\u0014QBR1nS2L\u0018I\u001c3MS:\\'B\u00012\u0003\u0011!9\u0007\u0001#A!B\u0013y\u0016A\u00044b[&d\u00170\u00118e\u0019&t7\u000e\t\u0005\u0006S\u0002!\tE[\u0001\baJ,G-[2u)\t)5\u000eC\u0003mQ\u0002\u0007!#\u0001\u0005gK\u0006$XO]3t\u0011\u0015I\u0007\u0001\"\u0003o)\r)u\u000e\u001d\u0005\u0006Y6\u0004\rA\u0005\u0005\u0006c6\u0004\r!R\u0001\u0007_\u001a47/\u001a;\t\u000bM\u0004A\u0011\u0002;\u0002\u0017A\u0014X\rZ5di2Kgn\u001b\u000b\u0004\u000bV4\b\"\u00027s\u0001\u0004\u0011\u0002\"B9s\u0001\u0004)\u0005\"\u0002=\u0001\t\u0003J\u0018!\u0003;sC:\u001chm\u001c:n)\rQ\u0018Q\u0004\t\u0004w\u0006]ab\u0001?\u0002\u00129\u0019Q0!\u0004\u000f\u0007y\fYAD\u0002\u0000\u0003\u0013qA!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000ba\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0019\u0011q\u0002\u0004\u0002\u0007M\fH.\u0003\u0003\u0002\u0014\u0005U\u0011a\u00029bG.\fw-\u001a\u0006\u0004\u0003\u001f1\u0011\u0002BA\r\u00037\u0011\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\t\u0005M\u0011Q\u0003\u0005\b\u0003?9\b\u0019AA\u0011\u0003\u001d!\u0017\r^1tKR\u0004D!a\t\u00020A1\u0011QEA\u0014\u0003Wi!!!\u0006\n\t\u0005%\u0012Q\u0003\u0002\b\t\u0006$\u0018m]3u!\u0011\ti#a\f\r\u0001\u0011a\u0011\u0011GA\u000f\u0003\u0003\u0005\tQ!\u0001\u00024\t\u0019q\f\n\u001a\u0012\t\u0005U\u00121\b\t\u0004O\u0005]\u0012bAA\u001dQ\t9aj\u001c;iS:<\u0007cA\u0014\u0002>%\u0019\u0011q\b\u0015\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002D\u0001!\t&!\u0012\u0002\u001bQ\u0014\u0018M\\:g_Jl\u0017*\u001c9m)\rQ\u0018q\t\u0005\t\u0003?\t\t\u00051\u0001\u0002JA\"\u00111JA(!\u0019\t)#a\n\u0002NA!\u0011QFA(\t1\t\t&a\u0012\u0002\u0002\u0003\u0005)\u0011AA\u001a\u0005\ryFe\r\u0005\n\u0003+\u0002\u0001\u0019!C\u0005\u0003/\nq\u0002\u001e:bS:LgnZ*v[6\f'/_\u000b\u0003\u00033\u0002RaJA.\u0003?J1!!\u0018)\u0005\u0019y\u0005\u000f^5p]B\u0019q\"!\u0019\n\u0007\u0005\r$A\u0001\u0016HK:,'/\u00197ju\u0016$G*\u001b8fCJ\u0014Vm\u001a:fgNLwN\u001c+sC&t\u0017N\\4Tk6l\u0017M]=\t\u0013\u0005\u001d\u0004\u00011A\u0005\n\u0005%\u0014a\u0005;sC&t\u0017N\\4Tk6l\u0017M]=`I\u0015\fH\u0003BA6\u0003c\u00022aJA7\u0013\r\ty\u0007\u000b\u0002\u0005+:LG\u000f\u0003\u0006\u0002t\u0005\u0015\u0014\u0011!a\u0001\u00033\n1\u0001\u001f\u00132\u0011!\t9\b\u0001Q!\n\u0005e\u0013\u0001\u0005;sC&t\u0017N\\4Tk6l\u0017M]=!\u0011\u001d\tY\b\u0001C\u0001\u0003{\nqa];n[\u0006\u0014\u00180\u0006\u0002\u0002`!\"\u0011\u0011\u0010\u00197\u0011\u001d\t\u0019\t\u0001C\u0001\u0003\u000b\u000b!\u0002[1t'VlW.\u0019:z+\t\t9\tE\u0002(\u0003\u0013K1!a#)\u0005\u001d\u0011un\u001c7fC:DC!!!1m!A\u0011\u0011\u0013\u0001\u0005\u0002\t\t\u0019*\u0001\u0006tKR\u001cV/\\7bef$2\u0001WAK\u0011!\tY(a$A\u0002\u0005e\u0003bBAM\u0001\u0011\u0005\u00111T\u0001\tKZ\fG.^1uKR!\u0011QTAR!\ry\u0011qT\u0005\u0004\u0003C\u0013!AI$f]\u0016\u0014\u0018\r\\5{K\u0012d\u0015N\\3beJ+wM]3tg&|gnU;n[\u0006\u0014\u0018\u0010\u0003\u0005\u0002 \u0005]\u0005\u0019AASa\u0011\t9+a+\u0011\r\u0005\u0015\u0012qEAU!\u0011\ti#a+\u0005\u0019\u00055\u00161UA\u0001\u0002\u0003\u0015\t!a\r\u0003\u0007}#C\u0007\u000b\u0003\u0002\u0018B2\u0004bBAZ\u0001\u0011\u0005\u0013QW\u0001\u0005G>\u0004\u0018\u0010F\u0002\u0019\u0003oC\u0001\"!/\u00022\u0002\u0007\u00111X\u0001\u0006Kb$(/\u0019\t\u0005\u0003{\u000b\u0019-\u0004\u0002\u0002@*\u0019\u0011\u0011\u0019\u0003\u0002\u000bA\f'/Y7\n\t\u0005\u0015\u0017q\u0018\u0002\t!\u0006\u0014\u0018-\\'ba\"\"\u0011\u0011\u0017\u00197\u0011\u001d\tY\r\u0001C!\u0003\u001b\fQa\u001e:ji\u0016,\"!a4\u0011\u0007u\t\t.C\u0002\u0002Tz\u0011\u0001\"\u0014'Xe&$XM\u001d\u0015\u0005\u0003\u0013\u0004d\u0007C\u0005\u0002Z\u0002\u0011\r\u0011\"\u0011\u0002\\\u0006Ya.^7GK\u0006$XO]3t+\t\ti\u000eE\u0002(\u0003?L1!!9)\u0005\rIe\u000e\u001e\u0005\t\u0003K\u0004\u0001\u0015!\u0003\u0002^\u0006aa.^7GK\u0006$XO]3tA!\u001a\u0001\u0001\r\u001c)\u0007\u0001\tY\u000fE\u00022\u0003[L1!a<3\u00051)\u0005\u0010]3sS6,g\u000e^1m\u000f\u001d\t\u0019P\u0001E\u0001\u0003k\f\u0001eR3oKJ\fG.\u001b>fI2Kg.Z1s%\u0016<'/Z:tS>tWj\u001c3fYB\u0019q\"a>\u0007\r\u0005\u0011\u0001\u0012AA}'!\t90a?\u0003\u0002\t\u001d\u0001cA\u0014\u0002~&\u0019\u0011q \u0015\u0003\r\u0005s\u0017PU3g!\u0011i\"1\u0001\r\n\u0007\t\u0015aD\u0001\u0006N\u0019J+\u0017\rZ1cY\u0016\u00042a\nB\u0005\u0013\r\u0011Y\u0001\u000b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\b\u001b\u0006]H\u0011\u0001B\b)\t\t)\u0010\u0003\u0005\u0003\u0014\u0005]H\u0011\tB\u000b\u0003\u0011\u0011X-\u00193\u0016\u0005\t]\u0001\u0003B\u000f\u0003\u001aaI1Aa\u0007\u001f\u0005!iEJU3bI\u0016\u0014\b\u0006\u0002B\taYB\u0001B!\t\u0002x\u0012\u0005#1E\u0001\u0005Y>\fG\rF\u0002\u0019\u0005KAqAa\n\u0003 \u0001\u0007Q%\u0001\u0003qCRD\u0007\u0006\u0002B\u0010aY2\u0011B!\f\u0002x\u0002\t9Pa\f\u0003M\u001d+g.\u001a:bY&TX\r\u001a'j]\u0016\f'OU3he\u0016\u001c8/[8o\u001b>$W\r\\,sSR,'o\u0005\u0004\u0003,\u0005='\u0011\u0007\t\u0005\u0005g\u0011I$\u0004\u0002\u00036)\u0019!q\u0007\u0004\u0002\u0011%tG/\u001a:oC2LAAa\u000f\u00036\t9Aj\\4hS:<\u0007B\u0003B \u0005W\u0011\t\u0011)A\u00051\u0005A\u0011N\\:uC:\u001cW\rC\u0004N\u0005W!\tAa\u0011\u0015\t\t\u0015#\u0011\n\t\u0005\u0005\u000f\u0012Y#\u0004\u0002\u0002x\"9!q\bB!\u0001\u0004Aba\u0002B'\u0005W!%q\n\u0002\u0005\t\u0006$\u0018m\u0005\u0005\u0003L\u0005m(\u0011\u000bB\u0004!\r9#1K\u0005\u0004\u0005+B#a\u0002)s_\u0012,8\r\u001e\u0005\n\u0007\n-#Q3A\u0005\u0002\u0011C\u0011B\u0013B&\u0005#\u0005\u000b\u0011B#\t\u0013q\u0012YE!f\u0001\n\u0003i\u0004\"\u0003!\u0003L\tE\t\u0015!\u0003\u0013\u0011\u001di%1\nC\u0001\u0005C\"bAa\u0019\u0003h\t%\u0004\u0003\u0002B3\u0005\u0017j!Aa\u000b\t\r\r\u0013y\u00061\u0001F\u0011\u0019a$q\fa\u0001%!Q\u00111\u0017B&\u0003\u0003%\tA!\u001c\u0015\r\t\r$q\u000eB9\u0011!\u0019%1\u000eI\u0001\u0002\u0004)\u0005\u0002\u0003\u001f\u0003lA\u0005\t\u0019\u0001\n\t\u0015\tU$1JI\u0001\n\u0003\u00119(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\te$fA#\u0003|-\u0012!Q\u0010\t\u0005\u0005\u007f\u00129)\u0004\u0002\u0003\u0002*!!1\u0011BC\u0003%)hn\u00195fG.,GM\u0003\u00024Q%!!\u0011\u0012BA\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0005\u001b\u0013Y%%A\u0005\u0002\t=\u0015AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005#S3A\u0005B>\u0011)\u0011)Ja\u0013\u0002\u0002\u0013\u0005#qS\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\te\u0005\u0003\u0002BN\u0005Kk!A!(\u000b\t\t}%\u0011U\u0001\u0005Y\u0006twM\u0003\u0002\u0003$\u0006!!.\u0019<b\u0013\ri#Q\u0014\u0005\u000b\u0005S\u0013Y%!A\u0005\u0002\u0005m\u0017\u0001\u00049s_\u0012,8\r^!sSRL\bB\u0003BW\u0005\u0017\n\t\u0011\"\u0001\u00030\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u001e\u0005cC!\"a\u001d\u0003,\u0006\u0005\t\u0019AAo\u0011)\u0011)La\u0013\u0002\u0002\u0013\u0005#qW\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!\u0011\u0018\t\u0007\u0005w\u0013\t-a\u000f\u000e\u0005\tu&b\u0001B`Q\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t\r'Q\u0018\u0002\t\u0013R,'/\u0019;pe\"Q!q\u0019B&\u0003\u0003%\tA!3\u0002\u0011\r\fg.R9vC2$B!a\"\u0003L\"Q\u00111\u000fBc\u0003\u0003\u0005\r!a\u000f\t\u0015\t='1JA\u0001\n\u0003\u0012\t.\u0001\u0005iCND7i\u001c3f)\t\ti\u000e\u0003\u0006\u0003V\n-\u0013\u0011!C!\u0005/\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00053C!Ba7\u0003L\u0005\u0005I\u0011\tBo\u0003\u0019)\u0017/^1mgR!\u0011q\u0011Bp\u0011)\t\u0019H!7\u0002\u0002\u0003\u0007\u00111H\u0004\u000b\u0005G\u0014Y#!A\t\n\t\u0015\u0018\u0001\u0002#bi\u0006\u0004BA!\u001a\u0003h\u001aQ!Q\nB\u0016\u0003\u0003EIA!;\u0014\r\t\u001d(1\u001eB\u0004!!\u0011iOa=F%\t\rTB\u0001Bx\u0015\r\u0011\t\u0010K\u0001\beVtG/[7f\u0013\u0011\u0011)Pa<\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007C\u0004N\u0005O$\tA!?\u0015\u0005\t\u0015\bB\u0003Bk\u0005O\f\t\u0011\"\u0012\u0003X\"Q!q Bt\u0003\u0003%\ti!\u0001\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\t\r41AB\u0003\u0011\u0019\u0019%Q a\u0001\u000b\"1AH!@A\u0002IA!b!\u0003\u0003h\u0006\u0005I\u0011QB\u0006\u0003\u001d)h.\u00199qYf$Ba!\u0004\u0004\u0016A)q%a\u0017\u0004\u0010A)qe!\u0005F%%\u001911\u0003\u0015\u0003\rQ+\b\u000f\\33\u0011)\u00199ba\u0002\u0002\u0002\u0003\u0007!1M\u0001\u0004q\u0012\u0002\u0004\u0002CB\u000e\u0005W!\tf!\b\u0002\u0011M\fg/Z%na2$B!a\u001b\u0004 !9!qEB\r\u0001\u0004)caBB\u0012\u0003o$1Q\u0005\u0002'\u000f\u0016tWM]1mSj,G\rT5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8N_\u0012,GNU3bI\u0016\u00148\u0003BB\u0011\u0005/Aq!TB\u0011\t\u0003\u0019I\u0003\u0006\u0002\u0004,A!!qIB\u0011\u0011)\u0019yc!\tC\u0002\u0013%!qS\u0001\nG2\f7o\u001d(b[\u0016D\u0011ba\r\u0004\"\u0001\u0006IA!'\u0002\u0015\rd\u0017m]:OC6,\u0007\u0005\u0003\u0005\u0003\"\r\u0005B\u0011IB\u001c)\rA2\u0011\b\u0005\b\u0005O\u0019)\u00041\u0001&\u0011)\u0019i$a>\u0002\u0002\u0013%1qH\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0004BA!!1TB\"\u0013\u0011\u0019)E!(\u0003\r=\u0013'.Z2uQ\u0011\t9\u0010\r\u001c)\t\u0005E\bG\u000e")
public class GeneralizedLinearRegressionModel
extends RegressionModel<Vector, GeneralizedLinearRegressionModel>
implements GeneralizedLinearRegressionBase,
MLWritable {
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private GeneralizedLinearRegression.FamilyAndLink familyAndLink;
    private Option<GeneralizedLinearRegressionTrainingSummary> trainingSummary;
    private final int numFeatures;
    private final Param<String> family;
    private final DoubleParam variancePower;
    private final Param<String> link;
    private final DoubleParam linkPower;
    private final Param<String> linkPredictionCol;
    private final Param<String> offsetCol;
    private final Param<String> solver;
    private final Param<String> weightCol;
    private final DoubleParam regParam;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final BooleanParam fitIntercept;
    private volatile boolean bitmap$0;

    public static GeneralizedLinearRegressionModel load(String string) {
        return GeneralizedLinearRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<GeneralizedLinearRegressionModel> read() {
        return GeneralizedLinearRegressionModel$.MODULE$.read();
    }

    private GeneralizedLinearRegression.FamilyAndLink familyAndLink$lzycompute() {
        GeneralizedLinearRegressionModel generalizedLinearRegressionModel = this;
        synchronized (generalizedLinearRegressionModel) {
            if (!this.bitmap$0) {
                this.familyAndLink = GeneralizedLinearRegression$FamilyAndLink$.MODULE$.apply(this);
                this.bitmap$0 = true;
            }
            return this.familyAndLink;
        }
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final Param<String> family() {
        return this.family;
    }

    @Override
    public final DoubleParam variancePower() {
        return this.variancePower;
    }

    @Override
    public final Param<String> link() {
        return this.link;
    }

    @Override
    public final DoubleParam linkPower() {
        return this.linkPower;
    }

    @Override
    public final Param<String> linkPredictionCol() {
        return this.linkPredictionCol;
    }

    @Override
    public final Param<String> offsetCol() {
        return this.offsetCol;
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$family_$eq(Param x$1) {
        this.family = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$variancePower_$eq(DoubleParam x$1) {
        this.variancePower = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$link_$eq(Param x$1) {
        this.link = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$linkPower_$eq(DoubleParam x$1) {
        this.linkPower = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$linkPredictionCol_$eq(Param x$1) {
        this.linkPredictionCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$offsetCol_$eq(Param x$1) {
        this.offsetCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$solver_$eq(Param x$1) {
        this.solver = x$1;
    }

    @Override
    public String getFamily() {
        return GeneralizedLinearRegressionBase$class.getFamily(this);
    }

    @Override
    public double getVariancePower() {
        return GeneralizedLinearRegressionBase$class.getVariancePower(this);
    }

    @Override
    public String getLink() {
        return GeneralizedLinearRegressionBase$class.getLink(this);
    }

    @Override
    public double getLinkPower() {
        return GeneralizedLinearRegressionBase$class.getLinkPower(this);
    }

    @Override
    public String getLinkPredictionCol() {
        return GeneralizedLinearRegressionBase$class.getLinkPredictionCol(this);
    }

    @Override
    public String getOffsetCol() {
        return GeneralizedLinearRegressionBase$class.getOffsetCol(this);
    }

    @Override
    public boolean hasWeightCol() {
        return GeneralizedLinearRegressionBase$class.hasWeightCol(this);
    }

    @Override
    public boolean hasOffsetCol() {
        return GeneralizedLinearRegressionBase$class.hasOffsetCol(this);
    }

    @Override
    public boolean hasLinkPredictionCol() {
        return GeneralizedLinearRegressionBase$class.hasLinkPredictionCol(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return GeneralizedLinearRegressionBase$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param x$1) {
    }

    @Override
    public final String getSolver() {
        return HasSolver$class.getSolver(this);
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol$class.getWeightCol(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public GeneralizedLinearRegressionModel setLinkPredictionCol(String value) {
        return (GeneralizedLinearRegressionModel)this.set(this.linkPredictionCol(), value);
    }

    private GeneralizedLinearRegression.FamilyAndLink familyAndLink() {
        return this.bitmap$0 ? this.familyAndLink : this.familyAndLink$lzycompute();
    }

    @Override
    public double predict(Vector features) {
        return this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$$predict(features, 0.0);
    }

    public double org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$$predict(Vector features, double offset) {
        double eta = this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$$predictLink(features, offset);
        return this.familyAndLink().fitted(eta);
    }

    public double org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$$predictLink(Vector features, double offset) {
        return BLAS$.MODULE$.dot(features, this.coefficients()) + this.intercept() + offset;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        this.transformSchema(dataset.schema());
        return this.transformImpl(dataset);
    }

    @Override
    public Dataset<Row> transformImpl(Dataset<?> dataset) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GeneralizedLinearRegressionModel.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator1$1(GeneralizedLinearRegressionModel $outer) {
            }
        }
        UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeneralizedLinearRegressionModel $outer;

            public final double apply(Vector features, double offset) {
                return this.$outer.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$$predict(features, offset);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator1$1(this)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(GeneralizedLinearRegressionModel.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator2$1(GeneralizedLinearRegressionModel $outer) {
            }
        }
        UserDefinedFunction predictLinkUDF = functions$.MODULE$.udf((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeneralizedLinearRegressionModel $outer;

            public final double apply(Vector features, double offset) {
                return this.$outer.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$$predictLink(features, offset);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator2$1(this)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
        Column offset = this.hasOffsetCol() ? functions$.MODULE$.col(this.$(this.offsetCol())).cast((DataType)DoubleType$.MODULE$) : functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)0.0));
        Dataset output = dataset;
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
            output = output.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol())), offset})));
        }
        if (this.hasLinkPredictionCol()) {
            output = output.withColumn(this.$(this.linkPredictionCol()), predictLinkUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol())), offset})));
        }
        return output.toDF();
    }

    private Option<GeneralizedLinearRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    private void trainingSummary_$eq(Option<GeneralizedLinearRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    public GeneralizedLinearRegressionTrainingSummary summary() {
        return (GeneralizedLinearRegressionTrainingSummary)this.trainingSummary().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new SparkException("No training summary available for this GeneralizedLinearRegressionModel");
            }
        });
    }

    public boolean hasSummary() {
        return this.trainingSummary().nonEmpty();
    }

    public GeneralizedLinearRegressionModel setSummary(Option<GeneralizedLinearRegressionTrainingSummary> summary2) {
        this.trainingSummary_$eq(summary2);
        return this;
    }

    public GeneralizedLinearRegressionSummary evaluate(Dataset<?> dataset) {
        return new GeneralizedLinearRegressionSummary(dataset, this);
    }

    @Override
    public GeneralizedLinearRegressionModel copy(ParamMap extra) {
        GeneralizedLinearRegressionModel copied = this.copyValues(new GeneralizedLinearRegressionModel(this.uid(), this.coefficients(), this.intercept()), extra);
        return (GeneralizedLinearRegressionModel)copied.setSummary(this.trainingSummary()).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new GeneralizedLinearRegressionModelWriter(this);
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    public GeneralizedLinearRegressionModel(String uid, Vector coefficients2, double intercept) {
        this.uid = uid;
        this.coefficients = coefficients2;
        this.intercept = intercept;
        HasFitIntercept$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasTol$class.$init$(this);
        HasRegParam$class.$init$(this);
        HasWeightCol$class.$init$(this);
        HasSolver$class.$init$(this);
        GeneralizedLinearRegressionBase$class.$init$(this);
        MLWritable$class.$init$(this);
        this.trainingSummary = None$.MODULE$;
        this.numFeatures = coefficients2.size();
    }

    public static class GeneralizedLinearRegressionModelWriter
    extends MLWriter {
        private final GeneralizedLinearRegressionModel instance;
        private volatile GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$ org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$Data$module;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$ org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$Data$lzycompute() {
            GeneralizedLinearRegressionModelWriter generalizedLinearRegressionModelWriter = this;
            synchronized (generalizedLinearRegressionModelWriter) {
                if (this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$Data$module != null) return this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$Data$module;
                this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$Data$module = new GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$(this);
                return this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$Data$module;
            }
        }

        public GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$ org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$Data() {
            return this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$Data$module == null ? this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$Data$lzycompute() : this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$Data().apply(this.instance.intercept(), this.instance.coefficients());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GeneralizedLinearRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.GeneralizedLinearRegressionModel.GeneralizedLinearRegressionModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.regression.GeneralizedLinearRegressionModel.GeneralizedLinearRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$typecreator3$1(GeneralizedLinearRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$typecreator3$1(this))).repartition(1).write().parquet(dataPath);
        }

        public GeneralizedLinearRegressionModelWriter(GeneralizedLinearRegressionModel instance) {
            this.instance = instance;
        }

        public class Data
        implements Product,
        Serializable {
            private final double intercept;
            private final Vector coefficients;
            public final /* synthetic */ GeneralizedLinearRegressionModelWriter $outer;

            public double intercept() {
                return this.intercept;
            }

            public Vector coefficients() {
                return this.coefficients;
            }

            public Data copy(double intercept, Vector coefficients2) {
                return new Data(this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$$$outer(), intercept, coefficients2);
            }

            public double copy$default$1() {
                return this.intercept();
            }

            public Vector copy$default$2() {
                return this.coefficients();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 2;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                    case 1: {
                        object = this.coefficients();
                        break;
                    }
                    case 0: {
                        object = BoxesRunTime.boxToDouble((double)this.intercept());
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficients()));
                return Statics.finalizeHash((int)n, (int)2);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.intercept() != data.intercept()) return false;
                Vector vector = this.coefficients();
                Vector vector2 = data.coefficients();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ GeneralizedLinearRegressionModelWriter org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(GeneralizedLinearRegressionModelWriter $outer, double intercept, Vector coefficients2) {
                this.intercept = intercept;
                this.coefficients = coefficients2;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.class.$init$((Product)this);
            }
        }
    }

    public static class GeneralizedLinearRegressionModelReader
    extends MLReader<GeneralizedLinearRegressionModel> {
        private final String className = GeneralizedLinearRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public GeneralizedLinearRegressionModel load(String path) {
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            String dataPath = new Path(path, "data").toString();
            Row data = (Row)this.sparkSession().read().parquet(dataPath).select("intercept", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).head();
            double intercept = data.getDouble(0);
            Vector coefficients2 = (Vector)data.getAs(1);
            GeneralizedLinearRegressionModel model = new GeneralizedLinearRegressionModel(metadata.uid(), coefficients2, intercept);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }
}

