/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Arrays;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.EngineStatement;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.Util;

public class EmbedStatement
extends ConnectionChild
implements EngineStatement {
    private final Connection applicationConnection;
    protected EngineStatement applicationStatement;
    long updateCount = -1L;
    EmbedResultSet results;
    private java.sql.ResultSet autoGeneratedKeysResultSet;
    private String cursorName;
    private final boolean forMetaData;
    final int resultSetType;
    final int resultSetConcurrency;
    private final int resultSetHoldability;
    final LanguageConnectionContext lcc;
    private SQLWarning warnings;
    String SQLText;
    private int fetchSize = 1;
    private int fetchDirection = 1000;
    int MaxFieldSize;
    long timeoutMillis;
    private boolean active = true;
    Vector<Object> batchStatements;
    long maxRows;
    private ParameterValueSet pvs;
    protected boolean isPoolable = false;
    private boolean closeOnCompletion = false;
    private boolean closingResultSets = false;
    private EmbedResultSet[] dynamicResults;
    private int currentDynamicResultSet;

    public EmbedStatement(EmbedConnection embedConnection, boolean bl, int n, int n2, int n3) {
        super(embedConnection);
        this.forMetaData = bl;
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
        this.resultSetHoldability = n3;
        this.lcc = this.getLanguageConnectionContext(this.getEmbedConnection());
        this.applicationConnection = this.getEmbedConnection().getApplicationConnection();
        this.applicationStatement = this;
    }

    @Override
    public java.sql.ResultSet executeQuery(String string) throws SQLException {
        this.execute(string, true, false, 2, null, null);
        return this.results;
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        return (int)this.executeLargeUpdate(string);
    }

    @Override
    public long executeLargeUpdate(String string) throws SQLException {
        this.execute(string, false, true, 2, null, null);
        return this.updateCount;
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        return (int)this.executeLargeUpdate(string, n);
    }

    @Override
    public long executeLargeUpdate(String string, int n) throws SQLException {
        this.execute(string, false, true, n, null, null);
        return this.updateCount;
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        return (int)this.executeLargeUpdate(string, nArray);
    }

    @Override
    public long executeLargeUpdate(String string, int[] nArray) throws SQLException {
        this.execute(string, false, true, nArray == null || nArray.length == 0 ? 2 : 1, nArray, null);
        return this.updateCount;
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        return (int)this.executeLargeUpdate(string, stringArray);
    }

    @Override
    public long executeLargeUpdate(String string, String[] stringArray) throws SQLException {
        this.execute(string, false, true, stringArray == null || stringArray.length == 0 ? 2 : 1, null, stringArray);
        return this.updateCount;
    }

    final void checkIfInMiddleOfBatch() throws SQLException {
        if (this.batchStatements != null) {
            throw EmbedStatement.newSQLException("XJ068.S", new Object[0]);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.active) {
            try {
                this.checkExecStatus();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return !this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SQLException {
        if (!this.active) {
            return;
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.closeActions();
            this.active = false;
            this.clearResultSets();
            this.cursorName = null;
            this.warnings = null;
            this.SQLText = null;
            this.batchStatements = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.results != null && this.results.singleUseActivation != null) {
            this.results.singleUseActivation.markUnused();
        }
    }

    void closeActions() throws SQLException {
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkStatus();
        return this.MaxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        this.checkStatus();
        if (n < 0) {
            throw EmbedStatement.newSQLException("XJ066.S", new Integer(n));
        }
        this.MaxFieldSize = n;
    }

    @Override
    public int getMaxRows() throws SQLException {
        return (int)this.getLargeMaxRows();
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        this.checkStatus();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        this.setLargeMaxRows(n);
    }

    @Override
    public void setLargeMaxRows(long l) throws SQLException {
        this.checkStatus();
        if (l < 0L) {
            throw EmbedStatement.newSQLException("XJ063.S", new Long(l));
        }
        this.maxRows = l;
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkStatus();
    }

    @Override
    public final int getQueryTimeout() throws SQLException {
        this.checkStatus();
        return (int)(this.timeoutMillis / 1000L);
    }

    @Override
    public final void setQueryTimeout(int n) throws SQLException {
        this.checkStatus();
        if (n < 0) {
            throw EmbedStatement.newSQLException("XJ074.S", new Integer(n));
        }
        this.timeoutMillis = (long)n * 1000L;
    }

    @Override
    public void cancel() throws SQLException {
        throw Util.notImplemented("cancel");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkStatus();
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkStatus();
        this.warnings = null;
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.checkStatus();
        this.cursorName = string;
    }

    @Override
    public boolean execute(String string) throws SQLException {
        return this.execute(string, false, false, 2, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execute(String string, boolean bl, boolean bl2, int n, int[] nArray, String[] stringArray) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            boolean bl3;
            this.checkExecStatus();
            if (string == null) {
                throw EmbedStatement.newSQLException("XJ067.S", new Object[0]);
            }
            this.checkIfInMiddleOfBatch();
            this.clearResultSets();
            this.setupContextStack();
            this.SQLText = string;
            try {
                Activation activation;
                try {
                    PreparedStatement preparedStatement = this.lcc.prepareInternalStatement(this.lcc.getDefaultSchema(), string, this.resultSetConcurrency == 1007, false);
                    activation = preparedStatement.getActivation(this.lcc, this.resultSetType == 1004);
                    this.checkRequiresCallableStatement(activation);
                    InterruptStatus.restoreIntrFlagIfSeen(this.lcc);
                }
                catch (Throwable throwable) {
                    throw this.handleException(throwable);
                }
                activation.setSingleExecution();
                if (n == 1) {
                    activation.setAutoGeneratedKeysResultsetInfo(nArray, stringArray);
                }
                bl3 = this.executeStatement(activation, bl, bl2);
            }
            catch (Throwable throwable) {
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return bl3;
        }
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        return this.execute(string, false, false, n, null, null);
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        return this.execute(string, false, true, nArray == null || nArray.length == 0 ? 2 : 1, nArray, null);
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        return this.execute(string, false, true, stringArray == null || stringArray.length == 0 ? 2 : 1, null, stringArray);
    }

    @Override
    public final java.sql.ResultSet getResultSet() throws SQLException {
        this.checkStatus();
        return this.results;
    }

    @Override
    public final int getUpdateCount() throws SQLException {
        this.checkStatus();
        return (int)this.updateCount;
    }

    @Override
    public final long getLargeUpdateCount() throws SQLException {
        this.checkStatus();
        return this.updateCount;
    }

    @Override
    public final boolean getMoreResults() throws SQLException {
        return this.getMoreResults(3);
    }

    @Override
    public final int getResultSetType() throws SQLException {
        this.checkStatus();
        return this.resultSetType;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.checkStatus();
        if (n != 1000 && n != 1001 && n != 1002) {
            throw EmbedStatement.newSQLException("XJ064.S", new Integer(n));
        }
        this.fetchDirection = n;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkStatus();
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this.checkStatus();
        if (n < 0 || this.getMaxRows() != 0 && n > this.getMaxRows()) {
            throw EmbedStatement.newSQLException("XJ065.S", new Integer(n));
        }
        if (n > 0) {
            this.fetchSize = n;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkStatus();
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkStatus();
        return this.resultSetConcurrency;
    }

    @Override
    public final int getResultSetHoldability() throws SQLException {
        this.checkStatus();
        return this.resultSetHoldability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch(String string) throws SQLException {
        this.checkStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            if (this.batchStatements == null) {
                this.batchStatements = new Vector();
            }
            this.batchStatements.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearBatch() throws SQLException {
        this.checkStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.batchStatements = null;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return Util.squashLongs(this.executeLargeBatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkExecStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            SQLException sQLException;
            int n;
            this.setupContextStack();
            this.clearResultSets();
            Vector<Object> vector = this.batchStatements;
            this.batchStatements = null;
            int n2 = vector == null ? 0 : vector.size();
            long[] lArray = new long[n2];
            try {
                for (n = 0; n < n2; ++n) {
                    InterruptStatus.throwIf(this.lcc);
                    if (this.executeBatchElement(vector.get(n))) {
                        throw EmbedStatement.newSQLException("XJ04B.S", new Object[0]);
                    }
                    lArray[n] = this.getLargeUpdateCount();
                }
                InterruptStatus.restoreIntrFlagIfSeen(this.lcc);
                long[] lArray2 = lArray;
                return lArray2;
            }
            catch (StandardException standardException) {
                sQLException = this.handleException(standardException);
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
            finally {
                this.restoreContextStack();
            }
            long[] lArray3 = new long[n];
            System.arraycopy(lArray, 0, lArray3, 0, n);
            SQLException sQLException3 = Util.newBatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), lArray3, sQLException);
            throw sQLException3;
        }
    }

    boolean executeBatchElement(Object object) throws SQLException, StandardException {
        return this.execute((String)object, false, true, 2, null, null);
    }

    @Override
    public final Connection getConnection() throws SQLException {
        this.checkStatus();
        Connection connection = this.getEmbedConnection().getApplicationConnection();
        if (connection != this.applicationConnection || connection == null) {
            throw Util.noCurrentConnection();
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean getMoreResults(int n) throws SQLException {
        this.checkExecStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            if (this.dynamicResults == null) {
                this.clearResultSets();
                this.closeMeOnCompletion();
                return false;
            }
            switch (n) {
                default: {
                    int n2 = 0;
                    break;
                }
                case 1: {
                    int n2 = this.currentDynamicResultSet;
                    break;
                }
                case 2: {
                    int n2 = this.dynamicResults.length;
                }
            }
            SQLException sQLException = null;
            for (int i = n2; i <= this.currentDynamicResultSet && i < this.dynamicResults.length; ++i) {
                EmbedResultSet embedResultSet = this.dynamicResults[i];
                if (embedResultSet == null) continue;
                try {
                    embedResultSet.close();
                    continue;
                }
                catch (SQLException sQLException2) {
                    if (sQLException == null) {
                        sQLException = sQLException2;
                        continue;
                    }
                    sQLException.setNextException(sQLException2);
                    continue;
                }
                finally {
                    this.dynamicResults[i] = null;
                }
            }
            if (sQLException != null) {
                throw sQLException;
            }
            this.updateCount = -1L;
            while (++this.currentDynamicResultSet < this.dynamicResults.length) {
                EmbedResultSet embedResultSet = this.dynamicResults[this.currentDynamicResultSet];
                if (embedResultSet == null) continue;
                if (embedResultSet.isClosed) {
                    this.dynamicResults[this.currentDynamicResultSet] = null;
                    continue;
                }
                this.results = embedResultSet;
                return true;
            }
            this.results = null;
            return false;
        }
    }

    @Override
    public final java.sql.ResultSet getGeneratedKeys() throws SQLException {
        this.checkStatus();
        if (this.autoGeneratedKeysResultSet == null) {
            return null;
        }
        this.execute("VALUES IDENTITY_VAL_LOCAL()", true, false, 2, null, null);
        return this.results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeStatement(Activation activation, boolean bl, boolean bl2) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            boolean bl3;
            this.setupContextStack();
            this.pvs = activation.getParameterValueSet();
            try {
                this.clearWarnings();
                if (!this.forMetaData) {
                    this.commitIfNeeded();
                    this.needCommit();
                } else if (this.lcc.getActivationCount() <= 1) {
                    this.commitIfNeeded();
                    this.needCommit();
                }
                ExecPreparedStatement execPreparedStatement = activation.getPreparedStatement();
                if (this.cursorName != null) {
                    activation.setCursorName(this.cursorName);
                }
                boolean bl4 = this.getExecuteHoldable();
                activation.setResultSetHoldability(bl4);
                activation.reset();
                activation.setMaxRows(this.maxRows);
                ResultSet resultSet = execPreparedStatement.execute(activation, this.forMetaData, this.timeoutMillis);
                this.addWarning(execPreparedStatement.getCompileTimeWarnings());
                this.addWarning(activation.getWarnings());
                if (resultSet.returnsRows()) {
                    EmbedResultSet embedResultSet;
                    if (bl2) {
                        throw StandardException.newException("X0Y79.S", new Object[0]);
                    }
                    this.results = embedResultSet = this.factory.newEmbedResultSet(this.getEmbedConnection(), resultSet, this.forMetaData, this, execPreparedStatement.isAtomic());
                    if (activation.isSingleExecution()) {
                        embedResultSet.singleUseActivation = activation;
                    }
                    this.updateCount = -1L;
                    bl3 = true;
                } else {
                    if (activation.getAutoGeneratedKeysResultsetMode() && resultSet.getAutoGeneratedKeysResultset() != null) {
                        resultSet.getAutoGeneratedKeysResultset().open();
                        this.autoGeneratedKeysResultSet = this.factory.newEmbedResultSet(this.getEmbedConnection(), resultSet.getAutoGeneratedKeysResultset(), false, this, execPreparedStatement.isAtomic());
                    }
                    this.updateCount = resultSet.modifiedRowCount();
                    this.results = null;
                    int n = 0;
                    if (activation.getDynamicResults() != null) {
                        n = this.processDynamicResults(activation.getDynamicResults(), activation.getMaxDynamicResults());
                    }
                    resultSet.close();
                    if (bl && n != 1) {
                        throw StandardException.newException("X0Y78.S", new Object[0]);
                    }
                    if (bl2 && n > 0) {
                        throw StandardException.newException("X0Y79.S", new Object[0]);
                    }
                    if (n == 0) {
                        if (activation.isSingleExecution()) {
                            activation.close();
                        }
                        if (!this.forMetaData) {
                            this.commitIfNeeded();
                        } else if (this.lcc.getActivationCount() <= 1) {
                            this.commitIfNeeded();
                        }
                    }
                    bl3 = n > 0;
                }
                InterruptStatus.restoreIntrFlagIfSeen(this.lcc);
            }
            catch (Throwable throwable) {
                if (activation.isSingleExecution()) {
                    try {
                        activation.close();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                throw this.handleException(throwable);
            }
            finally {
                this.restoreContextStack();
            }
            return bl3;
        }
    }

    final void addWarning(SQLWarning sQLWarning) {
        if (sQLWarning != null) {
            if (this.warnings == null) {
                this.warnings = sQLWarning;
            } else {
                this.warnings.setNextException(sQLWarning);
            }
        }
    }

    public String getSQLText() {
        return this.SQLText;
    }

    public ParameterValueSet getParameterValueSet() {
        return this.pvs;
    }

    final void checkStatus() throws SQLException {
        if (!this.active) {
            Connection connection = this.getEmbedConnection().getApplicationConnection();
            if (connection == null || connection.isClosed()) {
                throw Util.noCurrentConnection();
            }
            throw EmbedStatement.newSQLException("XJ012.S", "Statement");
        }
    }

    final void checkExecStatus() throws SQLException {
        if (!this.getConnection().isClosed()) {
            return;
        }
        this.active = false;
        throw Util.noCurrentConnection();
    }

    void clearResultSets() throws SQLException {
        try {
            this.closingResultSets = true;
            this.clearResultSetsMinion();
        }
        finally {
            this.closingResultSets = false;
        }
    }

    private void clearResultSetsMinion() throws SQLException {
        SQLException sQLException = null;
        try {
            if (this.results != null) {
                this.results.close();
                this.results = null;
            }
        }
        catch (SQLException sQLException2) {
            sQLException = sQLException2;
        }
        try {
            if (this.autoGeneratedKeysResultSet != null) {
                this.autoGeneratedKeysResultSet.close();
                this.autoGeneratedKeysResultSet = null;
            }
        }
        catch (SQLException sQLException3) {
            if (sQLException == null) {
                sQLException = sQLException3;
            }
            sQLException.setNextException(sQLException3);
        }
        if (this.dynamicResults != null) {
            for (int i = 0; i < this.dynamicResults.length; ++i) {
                EmbedResultSet embedResultSet = this.dynamicResults[i];
                if (embedResultSet == null) continue;
                try {
                    embedResultSet.close();
                    continue;
                }
                catch (SQLException sQLException4) {
                    if (sQLException == null) {
                        sQLException = sQLException4;
                        continue;
                    }
                    sQLException.setNextException(sQLException4);
                }
            }
            this.dynamicResults = null;
        }
        this.updateCount = -1L;
        if (sQLException != null) {
            throw sQLException;
        }
    }

    void checkRequiresCallableStatement(Activation activation) throws SQLException {
        ParameterValueSet parameterValueSet = activation.getParameterValueSet();
        if (parameterValueSet == null) {
            return;
        }
        if (parameterValueSet.checkNoDeclaredOutputParameters()) {
            try {
                activation.close();
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            throw EmbedStatement.newSQLException("XJ009.S", this.SQLText);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferBatch(EmbedStatement embedStatement) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            embedStatement.batchStatements = this.batchStatements;
            this.batchStatements = null;
        }
    }

    public final void setApplicationStatement(EngineStatement engineStatement) {
        this.applicationStatement = engineStatement;
    }

    private int processDynamicResults(java.sql.ResultSet[][] resultSetArray, int n) throws SQLException {
        int n2;
        Object[] objectArray = new EmbedResultSet[resultSetArray.length];
        int n3 = 0;
        for (n2 = 0; n2 < resultSetArray.length; ++n2) {
            java.sql.ResultSet[] resultSetArray2 = resultSetArray[n2];
            java.sql.ResultSet resultSet = resultSetArray2[0];
            resultSetArray2[0] = null;
            EmbedResultSet embedResultSet = EmbedStatement.processDynamicResult(this.getEmbedConnection(), resultSet, this);
            if (embedResultSet == null) continue;
            objectArray[n3++] = embedResultSet;
        }
        if (n3 != 0) {
            if (n3 != 1) {
                Arrays.sort(objectArray, 0, n3);
            }
            this.dynamicResults = objectArray;
            if (n3 > n) {
                this.addWarning(StandardException.newWarning("0100E", new Object[0]));
                for (n2 = n; n2 < n3; ++n2) {
                    ((EmbedResultSet)objectArray[n2]).close();
                    objectArray[n2] = null;
                }
                n3 = n;
            }
            this.updateCount = -1L;
            this.results = objectArray[0];
            this.currentDynamicResultSet = 0;
        }
        return n3;
    }

    static EmbedResultSet processDynamicResult(EmbedConnection embedConnection, java.sql.ResultSet resultSet, EmbedStatement embedStatement) {
        if (resultSet == null) {
            return null;
        }
        if (!(resultSet instanceof EmbedResultSet)) {
            return null;
        }
        EmbedResultSet embedResultSet = (EmbedResultSet)resultSet;
        if (embedResultSet.getEmbedConnection().rootConnection != embedConnection.rootConnection) {
            return null;
        }
        try {
            embedResultSet.checkIfClosed("");
        }
        catch (SQLException sQLException) {
            return null;
        }
        embedResultSet.setDynamicResultSet(embedStatement);
        return embedResultSet;
    }

    void resultSetClosing(EmbedResultSet embedResultSet) throws SQLException {
        if (!this.getEmbedConnection().autoCommit) {
            return;
        }
        if (this.dynamicResults != null) {
            for (int i = 0; i < this.dynamicResults.length; ++i) {
                EmbedResultSet embedResultSet2 = this.dynamicResults[i];
                if (embedResultSet2 == null || embedResultSet2.isClosed || embedResultSet2 == embedResultSet) continue;
                return;
            }
        }
        this.commitIfAutoCommit();
    }

    private boolean getExecuteHoldable() throws SQLException {
        if (this.resultSetHoldability == 2) {
            return false;
        }
        if (this.applicationStatement == this) {
            return true;
        }
        return this.applicationStatement.getResultSetHoldability() == 1;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkStatus();
        return this.isPoolable;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        this.checkStatus();
        this.isPoolable = bl;
    }

    @Override
    public final boolean isWrapperFor(Class<?> clazz) throws SQLException {
        this.checkStatus();
        return clazz.isInstance(this);
    }

    @Override
    public final <T> T unwrap(Class<T> clazz) throws SQLException {
        this.checkStatus();
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw EmbedStatement.newSQLException("XJ128.S", clazz);
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.checkStatus();
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkStatus();
        return this.closeOnCompletion;
    }

    void closeMeOnCompletion() {
        if (this.active && !this.closingResultSets && this.closeOnCompletion) {
            try {
                if (this.isOpen(this.results)) {
                    return;
                }
                if (this.autoGeneratedKeysResultSet != null) {
                    return;
                }
                if (this.dynamicResults != null) {
                    int n = this.dynamicResults.length;
                    for (int i = 0; i < n; ++i) {
                        if (!this.isOpen(this.dynamicResults[i])) continue;
                        return;
                    }
                }
                this.close();
            }
            catch (SQLException sQLException) {
                Util.logSQLException(sQLException);
            }
        }
    }

    private boolean isOpen(EmbedResultSet embedResultSet) throws SQLException {
        return embedResultSet != null && !embedResultSet.isClosed();
    }
}

