/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import org.apache.hadoop.fs.Path;
import org.apache.spark.streaming.util.FileBasedWriteAheadLog;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.StringOps;
import scala.collection.parallel.ExecutionContextTaskSupport;
import scala.collection.parallel.ParSeq;
import scala.collection.parallel.ParSeq$;
import scala.collection.parallel.TaskSupport;
import scala.concurrent.ExecutionContext;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.matching.Regex;

public final class FileBasedWriteAheadLog$ {
    public static final FileBasedWriteAheadLog$ MODULE$;
    private final Regex logFileRegex;

    static {
        new FileBasedWriteAheadLog$();
    }

    public Regex logFileRegex() {
        return this.logFileRegex;
    }

    public String timeToLogFile(long startTime, long stopTime) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startTime), BoxesRunTime.boxToLong((long)stopTime)}));
    }

    public Option<String> getCallerName() {
        Seq blacklist = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WriteAheadLog", "Logging", "java.lang", "scala."}));
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Thread.currentThread().getStackTrace()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StackTraceElement x$8) {
                return x$8.getClassName();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).find((Function1)new Serializable(blacklist){
            public static final long serialVersionUID = 0L;
            private final Seq blacklist$1;

            public final boolean apply(String c) {
                return !this.blacklist$1.exists((Function1)new Serializable(this, c){
                    public static final long serialVersionUID = 0L;
                    private final String c$1;

                    public final boolean apply(CharSequence x$1) {
                        return this.c$1.contains(x$1);
                    }
                    {
                        this.c$1 = c$1;
                    }
                });
            }
            {
                this.blacklist$1 = blacklist$1;
            }
        }).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(String x$9) {
                return Predef$.MODULE$.refArrayOps((Object[])x$9.split("\\.")).lastOption();
            }
        }).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(String x$10) {
                return Predef$.MODULE$.refArrayOps((Object[])x$10.split("\\$\\$")).headOption();
            }
        });
    }

    public Seq<FileBasedWriteAheadLog.LogInfo> logFilesTologInfo(Seq<Path> files) {
        return (Seq)((SeqLike)files.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<FileBasedWriteAheadLog.LogInfo> apply(Path file) {
                Option option;
                block4: {
                    Iterable iterable;
                    block3: {
                        block2: {
                            option = FileBasedWriteAheadLog$.MODULE$.logFileRegex().findFirstIn((CharSequence)file.getName());
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            CharSequence charSequence = (CharSequence)some.x();
                            Option option2 = FileBasedWriteAheadLog$.MODULE$.logFileRegex().unapplySeq(charSequence);
                            if (option2.isEmpty() || option2.get() == null || ((LinearSeqOptimized)option2.get()).lengthCompare(2) != 0) break block2;
                            String startTimeStr = (String)((LinearSeqOptimized)option2.get()).apply(0);
                            String stopTimeStr = (String)((LinearSeqOptimized)option2.get()).apply(1);
                            long startTime = new StringOps(Predef$.MODULE$.augmentString(startTimeStr)).toLong();
                            long stopTime = new StringOps(Predef$.MODULE$.augmentString(stopTimeStr)).toLong();
                            iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new FileBasedWriteAheadLog.LogInfo(startTime, stopTime, file.toString())));
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    return iterable;
                }
                throw new MatchError((Object)option);
            }
        }, Seq$.MODULE$.canBuildFrom())).sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(FileBasedWriteAheadLog.LogInfo x$11) {
                return x$11.startTime();
            }
        }, (Ordering)Ordering.Long$.MODULE$);
    }

    public <I, O> Iterator<O> seqToParIterator(ExecutionContext executionContext, Seq<I> source, Function1<I, Iterator<O>> handler) {
        ExecutionContextTaskSupport taskSupport = new ExecutionContextTaskSupport(executionContext);
        int groupSize = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(taskSupport.parallelismLevel()), 8);
        return TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)source.grouped(groupSize).flatMap((Function1)new Serializable(handler, taskSupport){
            public static final long serialVersionUID = 0L;
            private final Function1 handler$1;
            private final ExecutionContextTaskSupport taskSupport$1;

            public final ParSeq<Iterator<O>> apply(Seq<I> group) {
                ParSeq parallelCollection = (ParSeq)group.par();
                parallelCollection.tasksupport_$eq((TaskSupport)this.taskSupport$1);
                return (ParSeq)parallelCollection.map(this.handler$1, (CanBuildFrom)ParSeq$.MODULE$.canBuildFrom());
            }
            {
                this.handler$1 = handler$1;
                this.taskSupport$1 = taskSupport$1;
            }
        }), (Function1)Predef$.MODULE$.$conforms()).flatten();
    }

    private FileBasedWriteAheadLog$() {
        MODULE$ = this;
        this.logFileRegex = new StringOps(Predef$.MODULE$.augmentString("log-(\\d+)-(\\d+)")).r();
    }
}

