namespace TryCatchMatic
{
	using System;
	using Microsoft.Office.Core;
	using Extensibility;
	using System.Runtime.InteropServices;
	using EnvDTE;

	#region Read me for Add-in installation and setup information.
	// When run, the Add-in wizard prepared the registry for the Add-in.
	// At a later time, if the Add-in becomes unavailable for reasons such as:
	//   1) You moved this project to a computer other than which is was originally created on.
	//   2) You chose 'Yes' when presented with a message asking if you wish to remove the Add-in.
	//   3) Registry corruption.
	// you will need to re-register the Add-in by building the MyAddin21Setup project 
	// by right clicking the project in the Solution Explorer, then choosing install.
	#endregion
	
	/// <summary>
	///   Obiekt implementowanego dodatku.
	/// </summary>
	/// <seealso class='IDTExtensibility2' />
	[GuidAttribute("BC7C96F4-E34F-45CB-8D8D-283B68F0B81D"), ProgId("TryCatchMatic.Connect")]
	public class Connect : Object, Extensibility.IDTExtensibility2, IDTCommandTarget
	{
		/// <summary>
		///		Implementuje konstruktora obiektu dodatku.
		///		W tej metodzie naley umieci kod inicjalizujcy.
		/// </summary>
		public Connect()
		{
		}

		/// <summary>
		///      Implementuje metod OnConnection interfejsu IDTExtensibility2.
		///      Odbiera powiadomienie o adowaniu dodatku.
		/// </summary>
		/// <param term='application'>
		///      Obiekt gwny aplikacji docelowej.
		/// </param>
		/// <param term='connectMode'>
		///      Opisuje sposb adowania dodatku.
		/// </param>
		/// <param term='addInInst'>
		///      Obiekt reprezentujcy dodatek.
		/// </param>
		/// <seealso class='IDTExtensibility2' />
		public void OnConnection(object application, Extensibility.ext_ConnectMode connectMode, object addInInst, ref System.Array custom)
		{
			applicationObject = (_DTE)application;
			addInInstance = (AddIn)addInInst;
			if(connectMode == Extensibility.ext_ConnectMode.ext_cm_UISetup)
			{
				object []contextGUIDS = new object[] { };
				Commands commands = applicationObject.Commands;
				_CommandBars commandBars = applicationObject.CommandBars;

				// W momencie uruchomienia kreator dodatkw przygotowa wpisy w rejestrze dla dodatku.
				// Pniej dodatek lub jego polecenia mog si sta niedostpne z takich powodw, jak:
				//   1) Projekt przeniesiono na inny komputer ni ten, na ktrym go utworzono.
				//   2) Wybrano odpowied 'Tak' na pytanie o usunicie dodatku.
				//   3) Dodano nowe polecenia lub zmodyfikowano ju istniejce.
				// Naley wwczas ponownie zarejestrowa dodatek konsolidujc projekt TryCatchMaticSetup,
				// naciskajc prawy przycisk myszy na projekcie w oknie Solution Explorer i wybierajc opcj Install.
				// Alternatywne rozwizanie polega na uruchomieniu pliku ReCreateCommands.reg, ktry wygenerowa kreator
				// dodatkw w katalogu projektu lub uruchomieniu polecenia 'devenv /setup' z poziomu wiersza polece.
				try
				{
					Command command = commands.AddNamedCommand(addInInstance, "TryCatchMatic", "TryCatchMatic", "Surround W/ Try..Catch", false, 101, ref contextGUIDS, (int)vsCommandStatus.vsCommandStatusSupported+(int)vsCommandStatus.vsCommandStatusEnabled);
					CommandBar commandBar = (CommandBar)commandBars["Tools"];
					CommandBarControl commandBarControl = command.AddControl(commandBar, 1);
					
					CommandBar commandBar2 = (CommandBar)commandBars["Code Window"];
					CommandBarControl commandBarControl2 = command.AddControl(commandBar2, 1);
				}
				catch(System.Exception /*e*/)
				{
				}
			}
			
		}

		/// <summary>
		///     Implementuje metod OnDisconnection interfejsu IDTExtensibility2.
		///     Odbiera powiadomienia o dezaktywacji dodatku.
		/// </summary>
		/// <param term='disconnectMode'>
		///      Opisuje, w jaki sposb dodatek jest dezaktywowany.
		/// </param>
		/// <param term='custom'>
		///      Tablica parametrw zwizanych z aplikacj docelow.
		/// </param>
		/// <seealso class='IDTExtensibility2' />
		public void OnDisconnection(Extensibility.ext_DisconnectMode disconnectMode, ref System.Array custom)
		{
		}

		/// <summary>
		///      Implementuje metod OnAddInsUpdate interfejsu IDTExtensibility2.
		///      Odbiera powiadomienia o zmianie kolekcji dodatku.
		/// </summary>
		/// <param term='custom'>
		///      Tablica parametrw zwizanych z aplikacj docelow.
		/// </param>
		/// <seealso class='IDTExtensibility2' />
		public void OnAddInsUpdate(ref System.Array custom)
		{
		}

		/// <summary>
		///      Implementuje metod OnStartupComplete interfejsu IDTExtensibility2.
		///      Odbiera powiadomienia o zakoczeniu adowania aplikacji docelowej.
		/// </summary>
		/// <param term='custom'>
		///      Tablica parametrw zwizanych z aplikacj docelow.
		/// </param>
		/// <seealso class='IDTExtensibility2' />
		public void OnStartupComplete(ref System.Array custom)
		{
		}

		/// <summary>
		///      Implementuje metod OnBeginShutdown interfejsu IDTExtensibility2.
		///      Odbiera powiadomienia o dezaktywacji aplikacji docelowej.
		/// </summary>
		/// <param term='custom'>
		///      Tablica parametrw zwizanych z aplikacj docelow.
		/// </param>
		/// <seealso class='IDTExtensibility2' />
		public void OnBeginShutdown(ref System.Array custom)
		{
		}
		
		/// <summary>
		///      Implementuje metod QueryStatus interfejsu IDTCommandTarget.
		///      Jest ona wywoywana, kiedy zostaj zaktualizowane informacje o dostpnoci polecenia
		/// </summary>
		/// <param term='commandName'>
		///		Nazwa polecenia, ktrego stan ma zosta okrelony.
		/// </param>
		/// <param term='neededText'>
		///		Tekst wymagany dla polecenia.
		/// </param>
		/// <param term='status'>
		///		Stan polecenia na poziomie interfejsu uytkownika.
		/// </param>
		/// <param term='commandText'>
		///		Tekst wymagany przez parametr neededText.
		/// </param>
		/// <seealso class='Exec' />
		public void QueryStatus(string commandName, EnvDTE.vsCommandStatusTextWanted neededText, ref EnvDTE.vsCommandStatus status, ref object commandText)
		{
			if(neededText == EnvDTE.vsCommandStatusTextWanted.vsCommandStatusTextWantedNone)
			{
				if(commandName == "TryCatchMatic.Connect.TryCatchMatic")
				{
					status = (vsCommandStatus)vsCommandStatus.vsCommandStatusSupported|vsCommandStatus.vsCommandStatusEnabled;
				}
			}
		}

		/// <summary>
		///      Implementuje metod Exec interfejsu IDTCommandTarget.
		///      Jest ona wywoywana w momencie wykonania polecenia.
		/// </summary>
		/// <param term='commandName'>
		///		Nazwa wykonywanego polecenia.
		/// </param>
		/// <param term='executeOption'>
		///		Opisuje sposb wykonania polecenia.
		/// </param>
		/// <param term='varIn'>
		///		Parametry przekazywane przez obiekt wywoujcy do metody obsugi polecenia.
		/// </param>
		/// <param term='varOut'>
		///		Parametry przekazywane przez metod obsugi polecenia do obiektu wywoujcego.
		/// </param>
		/// <param term='handled'>
		///		Informuje obiket wywoujcy o tym, czy polecenie zostao obsuone.
		/// </param>
		/// <seealso class='Exec' />
		public void Exec(string commandName, EnvDTE.vsCommandExecOption executeOption, ref object varIn, ref object varOut, ref bool handled)
		{
			handled = false;
			if(executeOption == EnvDTE.vsCommandExecOption.vsCommandExecOptionDoDefault)
			{
				if(commandName == "TryCatchMatic.Connect.TryCatchMatic")
				{
					EnvDTE.TextDocument textDoc = (EnvDTE.TextDocument)applicationObject.ActiveDocument.Object("TextDocument");
					string selectedText = textDoc.Selection.Text;
					
					string newText = "try\n { \n" + selectedText + "\n}\ncatch\n{\n}";
	
					textDoc.Selection.Text = newText;   
					handled = true;
					return;
				}
			}
		}
		private _DTE applicationObject;
		private AddIn addInInstance;
		
	}
}