using System;
using System.Windows.Forms;
using Office = Microsoft.Office.Core;
using Excel = Microsoft.Office.Interop.Excel;
using MSForms = Microsoft.Vbe.Interop.Forms;

// Atrybut integracji z pakietem Office. Identyfikuje klas pocztkow skoroszytu. Nie wolno modyfikowa.
[assembly:System.ComponentModel.DescriptionAttribute("OfficeStartupClass, Version=1.0, Class=CustomerOrders.OfficeCodeBehind")]

namespace CustomerOrders
{
	/// <summary>
	/// Zawiera rozszerzenia kodu zarzdzanego dla dokumentu.
	/// </summary>
	public class OfficeCodeBehind
	{
        
		/// <summary>
		/// Obiekt aplikacji.
		/// </summary>
		internal Excel.Application ThisApplication
		{
			get { return thisApplication;}
		}

		/// <summary>
		/// Obiekt skoroszytu.
		/// </summary>
		internal Excel.Workbook ThisWorkbook
		{
			get { return thisWorkbook;}
		}

		private Excel.Application thisApplication = null;
		private Excel.Workbook thisWorkbook = null;

		private Excel.WorkbookEvents_OpenEventHandler openEvent;
		private Excel.WorkbookEvents_BeforeCloseEventHandler beforeCloseEvent;

		#region Generated initialization code

		/// <summary>
		/// Default constructor.
		/// </summary>
		public OfficeCodeBehind()
		{
		}

		/// <summary>
		/// Required procedure. Do not modify.
		/// </summary>
		/// <param name="application">Application object.</param>
		/// <param name="workbook">Workbook object.</param>
		public void _Startup(object application, object workbook)
		{
			this.thisApplication = application as Excel.Application;
			this.thisWorkbook = workbook as Excel.Workbook;

			openEvent= new Excel.WorkbookEvents_OpenEventHandler (ThisWorkbook_Open);
			thisWorkbook.Open += openEvent;
            
			beforeCloseEvent = new Excel.WorkbookEvents_BeforeCloseEventHandler(ThisWorkbook_BeforeClose);
			thisWorkbook.BeforeClose += beforeCloseEvent;
		}

		/// <summary>
		/// Required procedure. Do not modify.
		/// </summary>
		public void _Shutdown()
		{
			thisApplication = null;
			thisWorkbook = null;
		}

		/// <summary>
		/// Finds the control with the specified name in the active worksheet.
		/// </summary>
		/// <param name='name'>Name of the control to find.</param>
		/// <returns>
		/// Returns the specified control, or null if it is not found.
		/// </returns>
		object FindControl(string name )
		{
			return FindControl(name, (Excel.Worksheet) ThisWorkbook.ActiveSheet);
		}

		/// <summary>
		/// Returns the control with the specified name in the specified worksheet.
		/// </summary>
		/// <param name='name'>Name of the control to find.</param>
		/// <param name='sheet'>Worksheet object that contains the control.</param>
		/// <returns>
		/// Returns the specified control, or null if it is not found.
		/// </returns>
		object FindControl(string name, Excel.Worksheet sheet ) 
		{
			Excel.OLEObject theObject;
			try
			{
				theObject = (Excel.OLEObject) sheet.OLEObjects(name);
				return theObject.Object;
			}
			catch
			{
				// Returns null if the control is not found.
			}
			return null;
		}

		#endregion

		/// <summary>
		/// Metoda wywoywana w momencie otwierania skoroszytu.
		/// </summary>
		protected void ThisWorkbook_Open()
		{
			GetCustomer inputForm = new GetCustomer(this);
			inputForm.Show();
		}

		/// <summary>
		/// Metoda wywoywana przed zamkniciem skoroszytu. Naley zauway,
		/// e moe ona zosta wywoana wielokrotnie i warto przypisana Cancel
		/// moe by ignorowana, jeeli bdziemy mie do czynienia z pewnymi dziaaniami
		/// ze strony innego kodu lub uytkownika.
		/// </summary>
		/// <param name="Cancel">Warto False, kiedy wystpuje zdarzenie. Jeeli procedura
		/// zdarzenia ustawi warto tego parametru na True, dokument nie zostanie zamknity
		/// po jej zakoczeniu.
		/// </param>
		protected void ThisWorkbook_BeforeClose(ref bool Cancel)
		{
			Cancel = false;
		}

		public void EchoStringToCell(string str, int[] Cell)
		{
			Excel.Worksheet sheet1 =
				(Excel.Worksheet)this.ThisApplication.Sheets.get_Item(1);
			((Excel.Range)sheet1.Cells[Cell[0],Cell[1]]).Value2 = str;
		}

		public void CreateChart(string CustomerID, string CompanyName, int Year) 
		{
			// Utworzenie wykresu.
			Excel.Worksheet xlSheet = (Excel.Worksheet)this.ThisApplication.Sheets.get_Item(1);
			Excel.Chart xlChart = (Excel.Chart)ThisWorkbook.Charts.Add(Type.Missing, xlSheet, Type.Missing, Type.Missing);
			Excel.Range cellRange = (Excel.Range)xlSheet.UsedRange;
				
			xlChart.Name = CustomerID + "-" + Year.ToString();

			xlChart.ChartWizard(cellRange.CurrentRegion, 
				Excel.Constants.xl3DBar, Type.Missing, 
				Excel.XlRowCol.xlColumns, 1, Type.Missing, false, 
				CompanyName + " Orders for " + Year.ToString(),
				Type.Missing, Type.Missing, Type.Missing);

			// Sformatowanie wykresu.
			xlChart.ChartTitle.Font.Size = 18;
			xlChart.ChartTitle.Shadow = true;
			xlChart.ChartTitle.Border.LineStyle = Excel.Constants.xlSolid;
		}
	}
}
