Imports System.Data
Imports System.Data.SqlClient

Public Class GetCustomer
    Inherits System.Windows.Forms.Form

    Private excelCode As OfficeCodeBehind
#Region " Windows Form Designer generated code "

    Public Sub New(ByVal targetExcelCode As OfficeCodeBehind)
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call
        Me.excelCode = targetExcelCode
    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents Label2 As System.Windows.Forms.Label
    Friend WithEvents cboCustomer As System.Windows.Forms.ComboBox
    Friend WithEvents cboYear As System.Windows.Forms.ComboBox
    Friend WithEvents cmdOK As System.Windows.Forms.Button
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.Label1 = New System.Windows.Forms.Label
        Me.Label2 = New System.Windows.Forms.Label
        Me.cboCustomer = New System.Windows.Forms.ComboBox
        Me.cboYear = New System.Windows.Forms.ComboBox
        Me.cmdOK = New System.Windows.Forms.Button
        Me.SuspendLayout()
        '
        'Label1
        '
        Me.Label1.Location = New System.Drawing.Point(16, 16)
        Me.Label1.Name = "Label1"
        Me.Label1.TabIndex = 0
        Me.Label1.Text = "Customer Name:"
        '
        'Label2
        '
        Me.Label2.Location = New System.Drawing.Point(16, 55)
        Me.Label2.Name = "Label2"
        Me.Label2.TabIndex = 1
        Me.Label2.Text = "Year:"
        '
        'cboCustomer
        '
        Me.cboCustomer.Location = New System.Drawing.Point(120, 17)
        Me.cboCustomer.Name = "cboCustomer"
        Me.cboCustomer.Size = New System.Drawing.Size(160, 21)
        Me.cboCustomer.TabIndex = 2
        '
        'cboYear
        '
        Me.cboYear.Location = New System.Drawing.Point(120, 56)
        Me.cboYear.Name = "cboYear"
        Me.cboYear.Size = New System.Drawing.Size(121, 21)
        Me.cboYear.TabIndex = 3
        '
        'cmdOK
        '
        Me.cmdOK.Location = New System.Drawing.Point(120, 96)
        Me.cmdOK.Name = "cmdOK"
        Me.cmdOK.TabIndex = 4
        Me.cmdOK.Text = "Get Data"
        '
        'GetCustomer
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(292, 126)
        Me.Controls.Add(Me.cmdOK)
        Me.Controls.Add(Me.cboYear)
        Me.Controls.Add(Me.cboCustomer)
        Me.Controls.Add(Me.Label2)
        Me.Controls.Add(Me.Label1)
        Me.Name = "GetCustomer"
        Me.Text = "GetCustomer"
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Sub GetCustomer_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'Get the customers and order years from the database
        Dim conn As New SqlConnection("data source=localhost;	initial catalog=Northwind;integrated security=true")
        Dim da As New SqlDataAdapter("select CustomerID, CompanyName from customers", conn)
        Dim ds As New DataSet
        da.Fill(ds, "Customers")
        da.SelectCommand.CommandText = "select distinct datepart(""Year"", orderdate) as [Year] from orders"
        da.Fill(ds, "Years")

        'Using databinding, fill the combo boxes with data
        cboCustomer.DisplayMember = "CompanyName"
        cboCustomer.ValueMember = "CustomerID"
        cboCustomer.DataSource = ds.Tables("Customers")
        cboYear.DisplayMember = "Year"
        cboYear.ValueMember = "Year"
        cboYear.DataSource = ds.Tables("Years")
    End Sub

    Private Sub cmdOK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdOK.Click
        Dim conn As New SqlConnection("data source=localhost; initial catalog=Northwind;integrated security=true")
        Dim cmd As New SqlCommand("select datepart(""Month"", Orderdate) as [Month], count(orderid) as OrderCount from orders where customerid = @CustID and datepart(""Year"", OrderDate) = @Year  group by customerid, datepart(""Month"", Orderdate)", conn)
        cmd.Parameters.Add("@CustID", cboCustomer.SelectedValue)
        cmd.Parameters.Add("@Year", cboYear.SelectedValue)
        Dim dr As SqlDataReader
        conn.Open()
        dr = cmd.ExecuteReader()

        'initialize array	
        Dim OrderCounts(,) As String = {{"Jan", "0"}, {"Feb", "0"}, {"Mar", "0"}, {"Apr", "0"}, {"May", "0"}, {"Jun", "0"}, {"Jul", "0"}, {"Aug", "0"}, {"Sep", "0"}, {"Oct", "0"}, {"Nov", "0"}, {"Dec", "0"}}
        Do While (dr.Read())

            'get Month number from first column
            Dim Month As Integer = CInt(dr("Month"))
            'get OrderCount from second column and put in array
            OrderCounts(Month - 1, 1) = dr("OrderCount").ToString()
        Loop
        dr.Close()
        conn.Close()

        'Output customers order data to Excel
        For i As Integer = 0 To 11
            For j As Integer = 0 To 1
                Dim values() As Integer = {i + 1, j + 1}
                Me.excelCode.EchoStringToCell(OrderCounts(i, j), values)
            Next j
        Next i

        'Data has already been loaded to the page, now create chart
        Me.excelCode.CreateChart(CStr(cboCustomer.SelectedValue), cboCustomer.Text, CInt(cboYear.SelectedValue))
    End Sub
End Class
