using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Data.SqlClient;

namespace CustomerOrders
{
	/// <summary>
	/// Summary description for GetCustomer.
	/// </summary>
	public class GetCustomer : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.ComboBox cboCustomer;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.ComboBox cboYear;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Button cmdOK;
		private OfficeCodeBehind excelCode;

		public GetCustomer(OfficeCodeBehind targetExcelCode)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
			this.excelCode = targetExcelCode;
			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.cboCustomer = new System.Windows.Forms.ComboBox();
			this.label1 = new System.Windows.Forms.Label();
			this.cboYear = new System.Windows.Forms.ComboBox();
			this.label2 = new System.Windows.Forms.Label();
			this.cmdOK = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// cboCustomer
			// 
			this.cboCustomer.Location = new System.Drawing.Point(112, 8);
			this.cboCustomer.Name = "cboCustomer";
			this.cboCustomer.Size = new System.Drawing.Size(176, 21);
			this.cboCustomer.TabIndex = 0;
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 8);
			this.label1.Name = "label1";
			this.label1.TabIndex = 1;
			this.label1.Text = "Nazwisko klienta:";
			// 
			// cboYear
			// 
			this.cboYear.Location = new System.Drawing.Point(112, 40);
			this.cboYear.Name = "cboYear";
			this.cboYear.Size = new System.Drawing.Size(121, 21);
			this.cboYear.TabIndex = 2;
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(8, 40);
			this.label2.Name = "label2";
			this.label2.TabIndex = 3;
			this.label2.Text = "Rok:";
			// 
			// cmdOK
			// 
			this.cmdOK.Location = new System.Drawing.Point(168, 80);
			this.cmdOK.Name = "cmdOK";
			this.cmdOK.TabIndex = 4;
			this.cmdOK.Text = "Pobierz dane";
			this.cmdOK.Click += new System.EventHandler(this.cmdOK_Click);
			// 
			// GetCustomer
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(292, 118);
			this.Controls.Add(this.cmdOK);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.cboYear);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.cboCustomer);
			this.Name = "GetCustomer";
			this.Text = "GetCustomer";
			this.Load += new System.EventHandler(this.GetCustomer_Load);
			this.ResumeLayout(false);

		}
		#endregion

		private void GetCustomer_Load(object sender, System.EventArgs e)
		{
			SqlConnection conn = new SqlConnection("data source=localhost; initial catalog=Northwind;integrated security=true");
			SqlDataAdapter da = new SqlDataAdapter("select distinct CustomerID, CompanyName from customers", conn);
			DataSet ds = new DataSet();
			da.Fill(ds, "Customers");
			da.SelectCommand.CommandText = "select distinct datepart(\"Year\", orderdate) as [Year] from orders";
			da.Fill(ds, "Years");
			cboCustomer.DisplayMember = "CompanyName";
			cboCustomer.ValueMember = "CustomerID";
			cboCustomer.DataSource = ds.Tables["Customers"];
			cboYear.DisplayMember = "Year";
			cboYear.ValueMember = "Year";
			cboYear.DataSource = ds.Tables["Years"];
		}

		private void cmdOK_Click(object sender, System.EventArgs e)
		{
			SqlConnection conn = new SqlConnection("data source=localhost; initial catalog=Northwind;integrated security=true");
			SqlCommand cmd = new SqlCommand("select datepart(\"Month\", Orderdate) as [Month], count(orderid) as OrderCount from orders where customerid = @CustID and datepart(\"Year\", OrderDate) = @Year group by customerid, datepart(\"Month\", Orderdate) order by 1", conn);
			cmd.Parameters.Add("@CustID", cboCustomer.SelectedValue);
			cmd.Parameters.Add("@Year", cboYear.SelectedValue); 
			SqlDataReader dr;
			conn.Open();
			dr = cmd.ExecuteReader();
			//Przesanie adresu klienta do Worda
			string[,] OrderCounts = new string[12,2] {
				{"Jan", "0"},	{"Feb", "0"},{"Mar", "0"},{"Apr", "0"},
				{"May", "0"},{"Jun", "0"},{"Jul", "0"},{"Aug", "0"},
				{"Sep", "0"},{"Oct", "0"},{"Nov", "0"},{"Dec", "0"}
													 };
			while (dr.Read())
			{
				//pobranie numeru miesica z pierwszej kolumny
				int Month = (int)dr["Month"];
				//pobranie liczby zlece z drugiej kolumny i umieszczenie w tablicy
				OrderCounts[Month - 1, 1] = dr["OrderCount"].ToString();
			}
			dr.Close();
			conn.Close();
			for (int i = 0; i != 12; i++) 
			{
				for (int j = 0; j !=2; j++)
				{
					this.excelCode.EchoStringToCell(OrderCounts[i,j], new int[2] {i+1,j+1});
				}
			}
			this.excelCode.CreateChart((string)cboCustomer.SelectedValue, (string)cboCustomer.Text, (int)cboYear.SelectedValue);
		}
	}
}
