--100 sposobw na SQL, Sposb 77: 
--Wersja oracle

----------------------
--   Przygotowania  --
----------------------

CREATE TABLE lokalizacja(id VARCHAR(10) PRIMARY KEY);
INSERT INTO lokalizacja VALUES ('Centrum');
INSERT INTO lokalizacja VALUES ('Wschod');
INSERT INTO lokalizacja VALUES ('Polnoc');
INSERT INTO lokalizacja VALUES ('Poludnie');
INSERT INTO lokalizacja VALUES ('Zachod');
CREATE TABLE przyczyna(id VARCHAR(10) PRIMARY KEY);
INSERT INTO przyczyna VALUES ('Wypadek');
INSERT INTO przyczyna VALUES ('Defraudacja');
INSERT INTO przyczyna VALUES ('Proces');
CREATE TABLE szkodliwosc (id VARCHAR(10) PRIMARY KEY);
INSERT INTO szkodliwosc VALUES ('Bardzo duza');
INSERT INTO szkodliwosc VALUES ('Duza');
INSERT INTO szkodliwosc VALUES ('Srednia');
INSERT INTO szkodliwosc VALUES ('Mala');
CREATE TABLE incydent
(nr   INT PRIMARY KEY
,szkodliwosc VARCHAR(10)
,lokalizacja VARCHAR(10)
,przyczyna    VARCHAR(10)
,FOREIGN KEY (szkodliwosc) REFERENCES szkodliwosc(id)
,FOREIGN KEY (lokalizacja) REFERENCES lokalizacja(id)
,FOREIGN KEY (przyczyna) REFERENCES przyczyna(id)
);
INSERT INTO incydent VALUES (1,'Duza','Polnoc','Wypadek');
INSERT INTO incydent VALUES (2,'Srednia','Polnoc','Defraudacja');
INSERT INTO incydent VALUES (3,'Mala','Poludnie','Defraudacja');
INSERT INTO incydent VALUES (4,'Mala','Poludnie','Wypadek');
INSERT INTO incydent VALUES (5,'Mala','Zachod','Wypadek');
COL nr FORMAT 9
COL lokalizacja FORMAT A10
COL przyczyna FORMAT A10
COL szkodliwosc FORMAT A10
---------------------
--       Sposb    --
---------------------

SELECT nr, szkodliwosc, lokalizacja.id AS lokalizacja, przyczyna
  FROM incydent RIGHT OUTER JOIN lokalizacja
        ON (lokalizacja=lokalizacja.id)
;


SELECT nr, szkodliwosc.id AS szkodliwosc
          , lokalizacja.id AS lokalizacja
          , przyczyna
  FROM incydent RIGHT OUTER JOIN lokalizacja
        ON (lokalizacja=lokalizacja.id)
                RIGHT OUTER JOIN szkodliwosc
        ON (szkodliwosc=szkodliwosc.id)
;
SELECT nr, szkodliwosc.id AS szkodliwosc, lokalizacja.id AS lokalizacja, przyczyna
  FROM incydent FULL OUTER JOIN lokalizacja
        ON (lokalizacja=lokalizacja.id)
                FULL OUTER JOIN szkodliwosc
        ON (szkodliwosc=szkodliwosc.id)
;
SELECT nr, szkodliwosc.id AS szkodliwosc
          , lokalizacja.id AS lokalizacja
          , przyczyna.id    AS przyczyna
  FROM incydent FULL OUTER JOIN lokalizacja
        ON (lokalizacja=lokalizacja.id)
                FULL OUTER JOIN szkodliwosc
        ON (szkodliwosc=szkodliwosc.id)
                FULL OUTER JOIN przyczyna
        ON (przyczyna   =przyczyna.id)
;

SELECT nr, szkodliwosc.id AS szkodliwosc,
            lokalizacja.id AS lokalizacja,
            przyczyna.id    AS przyczyna
  FROM incydent
     RIGHT JOIN szkodliwosc ON szkodliwosc=szkodliwosc.id
     RIGHT JOIN lokalizacja ON COALESCE(lokalizacja,'Polnoc')=lokalizacja.id
     RIGHT JOIN przyczyna    ON COALESCE(przyczyna,'Wypadek')=przyczyna.id;

SELECT nr, szkodliwosc, lokalizacja, przyczyna FROM incydent
UNION
SELECT NULL,id,      NULL,      NULL FROM szkodliwosc
UNION
SELECT NULL,NULL,    id,        NULL FROM lokalizacja
UNION
SELECT NULL,NULL,    NULL,      id   FROM przyczyna;
--------------------------
--    Usuwanie danych   --
--------------------------

DROP TABLE incydent;
DROP TABLE lokalizacja;
DROP TABLE szkodliwosc;
DROP TABLE przyczyna;
