--100 sposobw na SQL, Sposb 77: Uzupenianie brakujcych wartoci w tabeli przestawnej
--Wersja mysql

----------------------
--   Przygotowania  --
----------------------

CREATE TABLE lokalizacja(id VARCHAR(10) PRIMARY KEY);
INSERT INTO lokalizacja VALUES ('Centrum');
INSERT INTO lokalizacja VALUES ('Wschd');
INSERT INTO lokalizacja VALUES ('Pnoc');
INSERT INTO lokalizacja VALUES ('Poudnie');
INSERT INTO lokalizacja VALUES ('Zachd');
CREATE TABLE przyczyna(id VARCHAR(15) PRIMARY KEY);
INSERT INTO przyczyna VALUES ('Wypadek');
INSERT INTO przyczyna VALUES ('Defraudacja');
INSERT INTO przyczyna VALUES ('Proces');
CREATE TABLE szkodliwosc (id VARCHAR(15) PRIMARY KEY);
INSERT INTO szkodliwosc VALUES ('Bardzo dua');
INSERT INTO szkodliwosc VALUES ('Dua');
INSERT INTO szkodliwosc VALUES ('rednia');
INSERT INTO szkodliwosc VALUES ('Maa');
CREATE TABLE incydent
(nr   INT PRIMARY KEY
,szkodliwosc VARCHAR(15)
,lokalizacja VARCHAR(10)
,przyczyna    VARCHAR(15)
,FOREIGN KEY (szkodliwosc) REFERENCES szkodliwosc(id)
,FOREIGN KEY (lokalizacja) REFERENCES lokalizacja(id)
,FOREIGN KEY (przyczyna) REFERENCES przyczyna(id)
);
INSERT INTO incydent VALUES (1,'Dua','Pnoc','Wypadek');
INSERT INTO incydent VALUES (2,'rednia','Pnoc','Defraudacja');
INSERT INTO incydent VALUES (3,'Maa','Poudnie','Defraudacja');
INSERT INTO incydent VALUES (4,'Maa','Poudnie','Wypadek');
INSERT INTO incydent VALUES (5,'Maa','Zachd','Wypadek');
COL nr FORMAT 9
COL lokalizacja FORMAT A10
COL przyczyna FORMAT A10
COL szkodliwosc FORMAT A10
----------------------
--       Sposb     --
----------------------

SELECT nr, szkodliwosc, lokalizacja.id AS lokalizacja, przyczyna
  FROM incydent RIGHT OUTER JOIN lokalizacja
        ON (lokalizacja=lokalizacja.id)
;


SELECT nr, szkodliwosc.id AS szkodliwosc
          , lokalizacja.id AS lokalizacja
          , przyczyna
  FROM incydent RIGHT OUTER JOIN lokalizacja
        ON (lokalizacja=lokalizacja.id)
                RIGHT OUTER JOIN szkodliwosc
        ON (szkodliwosc=szkodliwosc.id)
;

SELECT nr, szkodliwosc.id AS szkodliwosc,
            lokalizacja.id AS lokalizacja,
            przyczyna.id    AS przyczyna
  FROM incydent
     RIGHT JOIN szkodliwosc ON szkodliwosc=szkodliwosc.id
     RIGHT JOIN lokalizacja ON COALESCE(lokalizacja,'Polnoc')=lokalizacja.id
     RIGHT JOIN przyczyna    ON COALESCE(przyczyna,'Wypadek')=przyczyna.id;

SELECT nr, szkodliwosc, lokalizacja, przyczyna FROM incydent
UNION
SELECT NULL,id,      NULL,      NULL FROM szkodliwosc
UNION
SELECT NULL,NULL,    id,        NULL FROM lokalizacja
UNION
SELECT NULL,NULL,    NULL,      id   FROM przyczyna;
--------------------------
--    Usuwanie danych   --
--------------------------

DROP TABLE incydent;
DROP TABLE lokalizacja;
DROP TABLE szkodliwosc;
DROP TABLE przyczyna;











