#!/bin/sh
#phonecam.sh
filepath="/home/nazwauzytkownika/public_html/phonecam"
imgdir="img"
html="html"
time=`date +%s`
baseref="http://twojastrona.com/~nazwauzytkownika/phonecam"
title="Phonecam v.3"
arcdate=`date +%D |sed '''s/\//./g'''`
perpage="16"

umask 062

if [ ! -f $filepath/count ]; then
  echo "0" > $filepath/count
fi

if [ ! -f $filepath/arc.txt ]; then 
  touch $filepath/arc.txt
fi

if [ ! -d $filepath/archive ]; then 
  mkdir $filepath/archive
fi

if [ ! -d $filepath/$html ]; then 
  mkdir $filepath/$html
fi

if [ ! -d $filepath/$imgdir ]; then 
  mkdir $filepath/$imgdir
fi

count=`head -1 $filepath/count`

mkdir ~/.$$
cd ~/.$$
munpack

for i in *.jpg; do
  a=`basename $i .jpg`
  mv $i $filepath/$imgdir/$time.jpg
  convert -resize 320x240 \
    $filepath/$imgdir/$time.jpg $filepath/$imgdir/$time.thumb.jpg

  convert -resize 150x90 $filepath/$imgdir/$time.jpg $filepath/latest.jpg

  # tworzenie nowej strony
  cat $filepath/new.txt > $filepath/new.tmp
  echo "<a href=\"$baseref/$html/$time.html\"> 
    <img src=\"$baseref/$imgdir/$time.thumb.jpg\"
    width=\"320\" height=\"240\" border=0></a>" 
      > $filepath/new.txt

  cat $filepath/new.tmp >> $filepath/new.txt
  rm $filepath/new.tmp

  # tworzenie stron poszczeglnych zdj 
  echo "<html>
  <head><title>$title</title></head><body bgcolor=000000>
  <center><img src=\"$baseref/$imgdir/$time.jpg\" border=1></center><p>" 
    > $filepath/$html/$time.html

  cat $a.desc >> $filepath/$html/$time.html

  echo "</body></html>" >> $filepath/$html/$time.html

  count=`expr $count + 1`
done

echo $count > $filepath/count

if [ $count = 1 ]; then 
  echo "W kolejce znajduje si jedno zdjcie" > $filepath/notify
else
  echo "W kolejce znajduje si $count zdj" > $filepath/notify
fi

if [ $count = $perpage ]; then 
  echo "<html><head><title>$title</title></head><body bgcolor=000000><center>" 
    > $filepath/archive/$time.html

  cat $filepath/index.txt >> $filepath/archive/$time.html
  cp $filepath/new.txt $filepath/index.txt
  rm $filepath/count
  rm $filepath/new.txt
  cat $filepath/arc.txt > $filepath/arc.tmp
  echo "<li><a href=\"$baseref/archive/$time.html\">$arcdate</a></li>" 
    >> $filepath/arcn.txt

  cat $filepath/arc.tmp >> $filepath/arcn.txt
  rm $filepath/arc.tmp
  mv $filepath/arcn.txt $filepath/arc.txt

  echo "W kolejce nie ma adnych zdj" > $filepath/notify
fi

rm -rf ~/.$$
