Option Explicit
On Error Resume Next
Dim numThreshold
Dim strMachine
Dim strArchivePath
Dim strMoniker
Dim refWMI
Dim colEventLogs
Dim refEventLog

If WScript.Arguments.Count < 2 Then
WScript.Echo _
"Zastosowanie: archivelogs.vbs <komputer> <cieka_archiwum> [prg]"
WScript.Quit
End If

If WScript.Arguments.Count = 2 Then
numThreshold = 0
Else
numThreshold = WScript.Arguments(2)
If Not IsNumeric(numThreshold) Then
WScript.Echo "Trzeci parametr musi by liczb!"
WScript.Quit
End If

If numThreshold < 0 OR numThreshold > 100 Then
WScript.Echo "Trzeci parametr musi mieci si w zakresie 0-100"
WScript.Quit
End If
End If

strMachine = WScript.Arguments(0)
strArchivePath = WScript.Arguments(1)

strMoniker = "winMgmts:{(Backup,Security)}!\\" & strMachine
Set refWMI = GetObject(strMoniker)
If Err <> 0 Then
WScript.Echo "Nie mona poczy si z usug WMI."
WScript.Quit
End If

Set colEventLogs = refWMI.InstancesOf("Win32_NTEventLogFile")
If Err <> 0 Then
WScript.Echo "Nie mona pobra obiektu dziennika zdarze"
WScript.Quit
End If

For Each refEventLog In colEventLogs
'if shouldAct( ) zwraca niezerowy wynik
If shouldAct(refEventLog.FileSize,refEventLog.MaxFileSize) <> 0 Then
If refEventLog.ClearEventLog(_
makeFileName(refEventLog.LogfileName)) = 0 Then
WScript.Echo refEventLog.LogfileName & _
" zarchiwizowano pomylnie"
Else
WScript.Echo refEventLog.LogfileName & _
" nie mona zarchiwizowa"
End If
Else
WScript.Echo refEventLog.LogfileName & _
" nie przekroczy progu tworzenia kopii zapasowej"
End If
Next
Set refEventLog = Nothing
Set colEventLogs = Nothing
Set refWMI = Nothing

Function shouldAct(numCurSize, numMaxSize)
If (numCurSize/numMaxSize)*100 > numThreshold Then
shouldAct = 1
Else
shouldAct = 0
End If
End Function

Function makeFileName(strLogname)
makeFileName = strArchivePath & "\" & _
strMachine & "-" & strLogname & "-" & _
Year(Now) & Month(Now) & Day(Now) & ".evt"
End Function
